/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.parser.IGeneratorParser;
import cofh.cofhworld.parser.variables.BlockData;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.util.random.WeightedWorldGenerator;
import cofh.cofhworld.world.generator.WorldGenMulti;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.gen.feature.WorldGenerator;

public class GeneratorData {
    public static WorldGenerator parseGenerator(String def, Config genObject, List<WeightedBlock> defaultMaterial) throws IGeneratorParser.InvalidGeneratorException {
        if (!genObject.hasPath("generator")) {
            throw new IGeneratorParser.InvalidGeneratorException("No `generator` entry present", genObject.origin());
        }
        ConfigValue genData = genObject.getValue("generator");
        if (genData.valueType() == ConfigValueType.LIST) {
            List<? extends Config> list = genObject.getConfigList("generator");
            ArrayList<WeightedWorldGenerator> gens = new ArrayList<WeightedWorldGenerator>(list.size());
            for (Config config : list) {
                WorldGenerator gen = GeneratorData.parseGeneratorData(def, config, defaultMaterial);
                int weight = config.hasPath("weight") ? config.getInt("weight") : 100;
                gens.add(new WeightedWorldGenerator(gen, weight));
            }
            return new WorldGenMulti(gens);
        }
        if (genData.valueType() == ConfigValueType.OBJECT) {
            return GeneratorData.parseGeneratorData(def, genObject.getConfig("generator"), defaultMaterial);
        }
        CoFHWorld.log.error("Invalid data type for field 'generator'. > It must be an object or list.");
        throw new IGeneratorParser.InvalidGeneratorException("Invalid data type", genData.origin());
    }

    public static WorldGenerator parseGeneratorData(String def, Config genObject, List<WeightedBlock> defaultMaterial) throws IGeneratorParser.InvalidGeneratorException {
        IGeneratorParser parser;
        String name = def;
        if (genObject.hasPath("type") && null == FeatureParser.getGenerator(name = genObject.getString("type"))) {
            CoFHWorld.log.warn("Unknown generator '{}'! using '{}'", (Object)name, (Object)def);
            name = def;
        }
        if ((parser = FeatureParser.getGenerator(name)) == null) {
            throw new IGeneratorParser.InvalidGeneratorException("Generator '" + name + "' is not registered!", genObject.origin());
        }
        if (parser.isMeta() && name == def) {
            throw new IllegalStateException("Default generator for a distribution is a meta generator!");
        }
        boolean missedFields = false;
        for (String field : parser.getRequiredFields()) {
            if (genObject.hasPath(field)) continue;
            CoFHWorld.log.error("Missing required setting `{}` for generator type '{}' on line {}.", (Object)field, (Object)name, (Object)genObject.origin().lineNumber());
            missedFields = true;
        }
        if (missedFields) {
            throw new IGeneratorParser.InvalidGeneratorException("Missing fields", genObject.origin());
        }
        ArrayList<WeightedBlock> resList = new ArrayList<WeightedBlock>();
        if (!parser.isMeta() && !genObject.hasPath("block")) {
            CoFHWorld.log.error("Generators cannot generate blocks unless `block` is specified.");
            throw new IGeneratorParser.InvalidGeneratorException("`block` not specified", genObject.origin());
        }
        if (!BlockData.parseBlockList(genObject.root().get("block"), resList, true) && !parser.isMeta()) {
            throw new IGeneratorParser.InvalidGeneratorException("`block` not valid", genObject.origin());
        }
        ArrayList<WeightedBlock> matList = new ArrayList();
        if (!genObject.hasPath("material")) {
            CoFHWorld.log.debug("Using the default material list.");
            matList = defaultMaterial;
        } else if (!BlockData.parseBlockList(genObject.root().get("material"), matList, false)) {
            CoFHWorld.log.warn("Invalid material list! Using default list.");
            matList = defaultMaterial;
        }
        return parser.parseGenerator(parser.isMeta() ? def : name, genObject, CoFHWorld.log, resList, matList);
    }
}

