/*
 * Decompiled with CFR 0.152.
 */
package mageprotocol.shutters.objects.tileentity;

import mageprotocol.shutters.objects.ModObjects;
import mageprotocol.shutters.objects.blocks.MainRoller;
import mageprotocol.shutters.objects.blocks.Shutter;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TileEntityMainRoller
extends TileEntity
implements ITickable {
    private World world;
    private BlockPos pos;
    private boolean isActive = false;
    private boolean isDeployed;
    private int tickCount;
    private int counter = this.tickCount = 20;
    private int shutterDropSize;
    private int shutterMaxDropSize;
    private int shutterCount;

    public void activateRoller(World world, BlockPos pos, int shutterMaxDropSize) {
        this.shutterMaxDropSize = shutterMaxDropSize;
        this.isActive = true;
        this.world = world;
        this.pos = pos;
        this.shutterCount = shutterMaxDropSize;
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModObjects.shutter) {
            this.isDeployed = true;
            this.shutterDropSize = shutterMaxDropSize;
        } else {
            this.isDeployed = false;
            this.shutterDropSize = 1;
        }
    }

    @SubscribeEvent
    public void func_73660_a() {
        if (this.isActive) {
            if (this.counter <= 0) {
                this.counter = this.tickCount;
                if (!this.isDeployed) {
                    this.placeShutter(this.world, this.pos);
                } else {
                    this.removeShutter(this.world, this.pos);
                }
            } else {
                --this.counter;
            }
        }
    }

    public void placeShutter(World world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177979_c(this.shutterDropSize)).func_177230_c() != Blocks.field_150350_a) {
            this.isActive = !this.isActive;
        } else if (this.shutterCount <= 0) {
            this.isActive = !this.isActive;
            this.isDeployed = true;
        } else {
            world.func_175656_a(pos.func_177979_c(this.shutterDropSize), ModObjects.shutter.func_176223_P());
            Shutter shutter = (Shutter)world.func_180495_p(pos.func_177979_c(this.shutterDropSize)).func_177230_c();
            shutter.setFacing(world, pos.func_177979_c(this.shutterDropSize), (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)MainRoller.FACING));
            ++this.shutterDropSize;
            --this.shutterCount;
        }
    }

    public void removeShutter(World world, BlockPos pos) {
        if (this.shutterCount <= 0) {
            this.isActive = !this.isActive;
            this.isDeployed = false;
        } else if (world.func_180495_p(pos.func_177979_c(this.shutterDropSize)).func_177230_c() == ModObjects.shutter) {
            world.func_175698_g(pos.func_177979_c(this.shutterDropSize));
            --this.shutterDropSize;
            --this.shutterCount;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.isDeployed = compound.func_74767_n("isDeployed");
        this.shutterMaxDropSize = compound.func_74762_e("shutterMaxDropSize");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("isDeployed", this.isDeployed);
        compound.func_74768_a("shutterMaxDropSize", this.shutterMaxDropSize);
        return super.func_189515_b(compound);
    }
}

