/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.layout;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.LayoutManager;
import codechicken.nei.layout.LayoutStyleDefault;
import codechicken.nei.widget.Button;
import net.minecraft.client.gui.inventory.GuiContainer;

public class LayoutStyleTMIOld
extends LayoutStyleDefault {
    public static final Rectangle4i stateOff = new Rectangle4i(48, 0, 8, 12);
    public static final Rectangle4i stateOn = new Rectangle4i(56, 0, 8, 12);
    public static final Rectangle4i stateDisabled = new Rectangle4i(64, 0, 8, 12);
    int stateButtonCount;
    int clickButtonCount;

    @Override
    public String getName() {
        return "oldtmi";
    }

    @Override
    public void init() {
        LayoutManager.delete.icon = new Rectangle4i(24, 12, 12, 12);
        LayoutManager.gamemode.icons[0] = new Rectangle4i(12, 12, 12, 12);
        LayoutManager.gamemode.icons[1] = new Rectangle4i(36, 12, 12, 12);
        LayoutManager.gamemode.icons[2] = new Rectangle4i(48, 12, 12, 12);
        LayoutManager.rain.icon = new Rectangle4i(0, 12, 12, 12);
        LayoutManager.magnet.icon = new Rectangle4i(60, 24, 12, 12);
        LayoutManager.timeButtons[0].icon = new Rectangle4i(12, 24, 12, 12);
        LayoutManager.timeButtons[1].icon = new Rectangle4i(0, 24, 12, 12);
        LayoutManager.timeButtons[2].icon = new Rectangle4i(24, 24, 12, 12);
        LayoutManager.timeButtons[3].icon = new Rectangle4i(36, 24, 12, 12);
        LayoutManager.heal.icon = new Rectangle4i(48, 24, 12, 12);
        LayoutManager.dropDown.x = 93;
    }

    @Override
    public void reset() {
        this.clickButtonCount = 0;
        this.stateButtonCount = 0;
    }

    @Override
    public void layoutButton(Button button) {
        int offsetx = 2;
        int offsety = 2;
        if ((button.state & 4) != 0) {
            button.x = offsetx + this.stateButtonCount * 22;
            button.y = offsety;
            ++this.stateButtonCount;
        } else {
            button.x = offsetx + this.clickButtonCount % 4 * 22;
            button.y = offsety + (1 + this.clickButtonCount / 4) * 17;
            ++this.clickButtonCount;
        }
        button.h = 14;
        button.w = button.contentWidth() + 2;
        if ((button.state & 4) != 0) {
            button.w += LayoutStyleTMIOld.stateOff.w;
        }
    }

    @Override
    public void drawBackground(GuiContainer gui) {
        if (this.clickButtonCount == 0 && this.stateButtonCount == 0) {
            return;
        }
        int maxx = Math.max(this.stateButtonCount, this.clickButtonCount);
        if (maxx > 4) {
            maxx = 4;
        }
        int maxy = this.clickButtonCount == 0 ? 1 : this.clickButtonCount / 4 + 2;
        GuiDraw.drawRect((int)0, (int)0, (int)(2 + 22 * maxx), (int)(1 + maxy * 17), (int)-16777216);
    }

    @Override
    public void drawButton(Button b, int mousex, int mousey) {
        int cwidth = b.contentWidth();
        if ((b.state & 4) != 0) {
            cwidth += LayoutStyleTMIOld.stateOff.w;
        }
        int textx = b.x + (b.w - cwidth) / 2;
        int texty = b.y + (b.h - 8) / 2;
        GuiDraw.drawRect((int)b.x, (int)b.y, (int)b.w, (int)b.h, (int)(b.contains(mousex, mousey) ? -297791480 : -301989888));
        Rectangle4i icon = b.getRenderIcon();
        if (icon == null) {
            GuiDraw.drawString((String)b.getRenderLabel(), (int)textx, (int)texty, (int)-1);
        } else {
            int icony = b.y + (b.h - icon.h) / 2;
            LayoutManager.drawIcon(textx, icony, icon);
            if ((b.state & 3) == 2) {
                GuiDraw.drawRect((int)textx, (int)icony, (int)icon.w, (int)icon.h, (int)Integer.MIN_VALUE);
            }
            if ((b.state & 4) != 0) {
                Rectangle4i stateimage = (b.state & 3) == 1 ? stateOn : ((b.state & 3) == 2 ? stateDisabled : stateOff);
                LayoutManager.drawIcon(textx + icon.w, icony, stateimage);
            }
        }
    }

    @Override
    public void drawSubsetTag(String text, int x, int y, int w, int h, int state, boolean mouseover) {
        GuiDraw.drawRect((int)x, (int)y, (int)w, (int)h, (int)(mouseover ? -12578808 : -16777216));
        if (text != null) {
            int colour = -1;
            if (state == 0) {
                colour = -10481648;
            } else if (state == 1) {
                colour = -8359824;
            }
            GuiDraw.drawStringC((String)text, (int)x, (int)y, (int)w, (int)h, (int)colour, (state == 0 ? 1 : 0) != 0);
        }
    }
}

