/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCircuitFabricator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDeconstructor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenStorageModule;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockMachine2
extends BlockMachineBase {
    public static final PropertyEnum<EnumMachineExtendedType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineExtendedType.class);
    public static IMachineSidesProperties MACHINESIDES_RENDERTYPE = IMachineSidesProperties.TWOFACES_HORIZ;
    public static final PropertyEnum SIDES = BlockMachine2.MACHINESIDES_RENDERTYPE.asProperty;

    public BlockMachine2(String assetName) {
        super(assetName);
    }

    @Override
    protected void initialiseTypes() {
        this.types = EnumMachineExtendedType.values;
        this.typeBase = EnumMachineExtendedType.values[0];
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumMachineExtendedType type = (EnumMachineExtendedType)this.typeBase.fromMetadata(meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumMachineExtendedType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE, SIDES});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        return IMachineSides.addPropertyForTile(state, tile, MACHINESIDES_RENDERTYPE, (PropertyEnum<IMachineSidesProperties.MachineSidesModel>)SIDES);
    }

    public static enum EnumMachineExtendedType implements BlockMachineBase.EnumMachineBase,
    IStringSerializable
    {
        ELECTRIC_COMPRESSOR(0, "electric_compressor", TileEntityElectricIngotCompressor::new, "tile.compressor_electric.description", "tile.machine2.4"),
        CIRCUIT_FABRICATOR(4, "circuit_fabricator", TileEntityCircuitFabricator::new, "tile.circuit_fabricator.description", "tile.machine2.5"),
        OXYGEN_STORAGE(8, "oxygen_storage", TileEntityOxygenStorageModule::new, "tile.oxygen_storage_module.description", "tile.machine2.6"),
        DECONSTRUCTOR(12, "deconstructor", TileEntityDeconstructor::new, "tile.deconstructor.description", "tile.machine2.10");

        private final int meta;
        private final String name;
        private final TileConstructor tile;
        private final String shiftDescriptionKey;
        private final String blockName;
        private static final EnumMachineExtendedType[] values;

        private EnumMachineExtendedType(int meta, String name, TileConstructor tile, String key, String blockName) {
            this.meta = meta;
            this.name = name;
            this.tile = tile;
            this.shiftDescriptionKey = key;
            this.blockName = blockName;
        }

        @Override
        public int getMetadata() {
            return this.meta;
        }

        @Override
        public EnumMachineExtendedType fromMetadata(int meta) {
            return values[meta / 4 % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public TileEntity tileConstructor() {
            return this.tile.create();
        }

        @Override
        public String getShiftDescriptionKey() {
            return this.shiftDescriptionKey;
        }

        @Override
        public String getUnlocalizedName() {
            return this.blockName;
        }

        static {
            values = EnumMachineExtendedType.values();
        }

        @FunctionalInterface
        private static interface TileConstructor {
            public TileEntity create();
        }
    }
}

