/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.entities.layer;

import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.model.ModelPlayerGC;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderPlayerGC;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import micdoodle8.mods.galacticraft.planets.venus.items.ItemThermalPaddingTier2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class LayerThermalPadding
extends LayerArmorBase<ModelBiped> {
    private final RenderPlayer renderer;

    public LayerThermalPadding(RenderPlayer playerRendererIn) {
        super((RenderLivingBase)playerRendererIn);
        this.renderer = playerRendererIn;
    }

    public boolean func_177142_b() {
        return false;
    }

    protected void setModelSlotVisible(ModelBiped model, EntityEquipmentSlot slotIn) {
        model.func_178719_a(false);
        switch (slotIn) {
            case HEAD: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case CHEST: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case LEGS: {
                model.field_78115_e.field_78806_j = true;
                model.field_178723_h.field_78806_j = true;
                model.field_178724_i.field_78806_j = true;
                break;
            }
            case FEET: {
                model.field_78116_c.field_78806_j = true;
                model.field_178720_f.field_78806_j = true;
            }
        }
    }

    public ItemStack getItemStackFromSlot(EntityLivingBase living, EntityEquipmentSlot slotIn) {
        int padding;
        PlayerGearData gearData = GalacticraftCore.proxy.getGearData((EntityPlayer)living);
        if (gearData != null && (padding = gearData.getThermalPadding(slotIn.func_188452_c() - 1)) != -1) {
            switch (padding) {
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return new ItemStack(AsteroidsItems.thermalPadding, 1, slotIn.func_188452_c() - 1);
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    return new ItemStack(VenusItems.thermalPaddingTier2, 1, slotIn.func_188452_c() - 1);
                }
            }
        }
        return null;
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
    }

    private void renderArmorLayer(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slotIn) {
        ItemStack itemstack = this.getItemStackFromSlot(entityLivingBaseIn, slotIn);
        if (itemstack != null) {
            ModelBiped model = this.getModelFromSlot(slotIn);
            model.func_178686_a((ModelBase)this.renderer.func_177087_b());
            model.func_78086_a(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.setModelSlotVisible(model, slotIn);
            this.renderer.func_110776_a(itemstack.func_77973_b() instanceof ItemThermalPaddingTier2 ? RenderPlayerGC.thermalPaddingTexture1_T2 : RenderPlayerGC.thermalPaddingTexture1);
            model.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179140_f();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderPlayerGC.thermalPaddingTexture0);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            float time = (float)entityLivingBaseIn.field_70173_aa / 10.0f;
            float sTime = (float)Math.sin(time) * 0.5f + 0.5f;
            float r = 0.2f * sTime;
            float g = 1.0f * sTime;
            float b = 0.2f * sTime;
            if (entityLivingBaseIn.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
                float modifier = ((IGalacticraftWorldProvider)entityLivingBaseIn.field_70170_p.field_73011_w).getThermalLevelModifier();
                if (modifier > 0.0f) {
                    b = g;
                    g = r;
                } else if (modifier < 0.0f) {
                    r = g;
                    g = b;
                }
            }
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)(0.4f * sTime));
            model.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
        }
    }

    protected void func_177177_a() {
        this.field_177189_c = new ModelPlayerGC(0.55f, false);
        this.field_177186_d = new ModelPlayerGC(0.05f, false);
    }

    public ModelBiped getModelFromSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.FEET ? (ModelBiped)this.field_177189_c : (ModelBiped)this.field_177186_d;
    }
}

