/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.IControllableEntity;
import micdoodle8.mods.galacticraft.core.entities.InventoryEntity;
import micdoodle8.mods.galacticraft.core.network.PacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityAdvancedMotion
extends InventoryEntity
implements IControllableEntity,
PacketEntityUpdate.IEntityFullSync {
    protected long ticks = 0L;
    public float currentDamage;
    public int timeSinceHit;
    public int rockDirection;
    public double advancedPositionX;
    public double advancedPositionY;
    public double advancedPositionZ;
    public double advancedYaw;
    public double advancedPitch;
    public int posRotIncrements;
    protected boolean lastOnGround;

    public EntityAdvancedMotion(World world) {
        super(world);
        this.field_70156_m = true;
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public EntityAdvancedMotion(World world, double var2, double var4, double var6) {
        this(world);
        this.func_70107_b(var2, var4, var6);
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 1.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double offsetx = Math.cos((double)this.field_70177_z / 57.29577951308232 + 114.8) * -0.5;
            double offsetz = Math.sin((double)this.field_70177_z / 57.29577951308232 + 114.8) * -0.5;
            passenger.func_70107_b(this.field_70165_t + offsetx, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + offsetz);
        }
    }

    @Override
    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, double motX, double motY, double motZ, boolean onGround) {
        if (this.field_70170_p.field_72995_K) {
            this.advancedPositionX = x;
            this.advancedPositionY = y;
            this.advancedPositionZ = z;
            this.advancedYaw = yaw;
            this.advancedPitch = pitch;
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
            this.posRotIncrements = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.func_70101_b(yaw, pitch);
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
            if (onGround || this.forceGroundUpdate()) {
                this.field_70122_E = onGround;
            }
        }
    }

    protected boolean forceGroundUpdate() {
        return true;
    }

    public void func_70057_ab() {
        this.rockDirection = -this.rockDirection;
        this.timeSinceHit = 10;
        this.currentDamage *= 5.0f;
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (this.field_70128_L || var1.equals(DamageSource.field_76367_g) || !this.allowDamageSource(var1)) {
            return true;
        }
        Entity e = var1.func_76346_g();
        if (this.func_180431_b(var1) || this.field_70163_u > 300.0 || e instanceof EntityLivingBase && !(e instanceof EntityPlayer)) {
            return false;
        }
        this.rockDirection = -this.rockDirection;
        this.timeSinceHit = 10;
        this.currentDamage += var2 * 10.0f;
        this.func_70018_K();
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            this.currentDamage = 100.0f;
        }
        if (this.currentDamage > 70.0f) {
            if (!this.func_184188_bt().isEmpty()) {
                this.func_184226_ay();
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.dropItems();
                this.func_70106_y();
            }
        }
        return true;
    }

    public abstract List<ItemStack> getItemsDropped();

    public abstract boolean shouldMove();

    public abstract boolean shouldSpawnParticles();

    public abstract Map<Vector3, Vector3> getParticleMap();

    @SideOnly(value=Side.CLIENT)
    public abstract Particle getParticle(Random var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public abstract void tickInAir();

    public abstract void tickOnGround();

    public abstract void onGroundHit();

    public abstract Vector3 getMotionVec();

    public abstract ArrayList<Object> getNetworkedData();

    public abstract int getPacketTickSpacing();

    public abstract double getPacketSendDistance();

    public abstract void readNetworkedData(ByteBuf var1);

    public abstract boolean allowDamageSource(DamageSource var1);

    public void dropItems() {
        if (this.getItemsDropped() == null) {
            return;
        }
        for (ItemStack item : this.getItemsDropped()) {
            if (item == null || item.func_190926_b()) continue;
            this.func_70099_a(item, 0.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean b) {
        if (!this.func_184188_bt().isEmpty() && !this.func_184188_bt().contains(FMLClientHandler.instance().getClient().field_71439_g)) {
            this.posRotIncrements = posRotationIncrements + 5;
            this.advancedPositionX = x;
            this.advancedPositionY = y;
            this.advancedPositionZ = z;
            this.advancedYaw = yaw;
            this.advancedPitch = pitch;
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.shouldMove()) {
            super.func_70091_d(type, x, y, z);
        }
    }

    public abstract boolean canSetPositionClient();

    public abstract boolean shouldSendAdvancedMotionPacket();

    @Override
    public void func_70071_h_() {
        ++this.ticks;
        super.func_70071_h_();
        if (this.canSetPositionClient() && this.field_70170_p.field_72995_K && (this.func_184188_bt().isEmpty() || !this.func_184188_bt().contains(FMLClientHandler.instance().getClient().field_71439_g)) && this.posRotIncrements > 0) {
            double x = this.field_70165_t + (this.advancedPositionX - this.field_70165_t) / (double)this.posRotIncrements;
            double y = this.field_70163_u + (this.advancedPositionY - this.field_70163_u) / (double)this.posRotIncrements;
            double z = this.field_70161_v + (this.advancedPositionZ - this.field_70161_v) / (double)this.posRotIncrements;
            double var12 = MathHelper.func_76138_g((double)(this.advancedYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + var12 / (double)this.posRotIncrements);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.advancedPitch - (double)this.field_70125_A) / (double)this.posRotIncrements);
            --this.posRotIncrements;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        if (this.timeSinceHit > 0) {
            --this.timeSinceHit;
        }
        if (this.currentDamage > 0.0f) {
            this.currentDamage -= 1.0f;
        }
        if (this.shouldSpawnParticles() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getParticleMap());
        }
        if (this.field_70122_E) {
            this.tickOnGround();
        } else {
            this.tickInAir();
        }
        if (this.field_70170_p.field_72995_K) {
            Vector3 mot = this.getMotionVec();
            this.field_70159_w = mot.x;
            this.field_70181_x = mot.y;
            this.field_70179_y = mot.z;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70122_E && !this.lastOnGround) {
            this.onGroundHit();
        }
        if (this.shouldSendAdvancedMotionPacket()) {
            if (this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendToServer(new PacketEntityUpdate(this));
            }
            if (!this.field_70170_p.field_72995_K && this.ticks % 5L == 0L) {
                GalacticraftCore.packetPipeline.sendToAllAround(new PacketEntityUpdate(this), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
            }
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.lastOnGround = this.field_70122_E;
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        sendData.addAll(this.getNetworkedData());
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        this.readNetworkedData(buffer);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(Map<Vector3, Vector3> points) {
        for (Map.Entry<Vector3, Vector3> vec : points.entrySet()) {
            Vector3 posVec = vec.getKey();
            Vector3 motionVec = vec.getValue();
            this.spawnParticle(this.getParticle(this.field_70146_Z, posVec.x, posVec.y, posVec.z, motionVec.x, motionVec.y, motionVec.z));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(Particle fx) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null && mc.func_175606_aa() != null && mc.field_71452_i != null && fx != null) {
            mc.field_71452_i.func_78873_a(fx);
        }
    }
}

