/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.block.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.text.TextFormatting;

public class BlockStateHelper {
    public static <T extends Comparable<T>> IProperty<T> getProperty(IBlockState blockState, String name) {
        for (IProperty prop : blockState.func_177227_a()) {
            if (!prop.func_177701_a().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public static <T extends Comparable<T>> T getPropertyValue(IBlockState blockState, String name) {
        IProperty<T> property = BlockStateHelper.getProperty(blockState, name);
        if (property == null) {
            throw new IllegalArgumentException(name + " does not exist in " + blockState);
        }
        return (T)blockState.func_177229_b(property);
    }

    public static List<String> getFormattedProperties(IBlockState blockState) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : blockState.func_177228_b().entrySet()) {
            IProperty key = (IProperty)entry.getKey();
            Comparable value = (Comparable)entry.getValue();
            String formattedValue = value.toString();
            if (Boolean.TRUE.equals(value)) {
                formattedValue = TextFormatting.GREEN + formattedValue + TextFormatting.RESET;
            } else if (Boolean.FALSE.equals(value)) {
                formattedValue = TextFormatting.RED + formattedValue + TextFormatting.RESET;
            }
            list.add(key.func_177701_a() + ": " + formattedValue);
        }
        return list;
    }

    public static boolean areBlockStatesEqual(IBlockState blockStateA, IBlockState blockStateB) {
        Block blockB;
        if (blockStateA == blockStateB) {
            return true;
        }
        Block blockA = blockStateA.func_177230_c();
        return blockA == (blockB = blockStateB.func_177230_c()) && blockA.func_176201_c(blockStateA) == blockB.func_176201_c(blockStateB);
    }
}

