/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.gui.control;

import com.github.lunatrius.core.client.gui.GuiNumericField;
import com.github.lunatrius.core.client.gui.GuiScreenBase;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.client.gui.control.GuiSchematicMaterials;
import com.github.lunatrius.schematica.client.printer.SchematicPrinter;
import com.github.lunatrius.schematica.client.renderer.RenderSchematic;
import com.github.lunatrius.schematica.client.util.FlipHelper;
import com.github.lunatrius.schematica.client.util.RotationHelper;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;

public class GuiSchematicControl
extends GuiScreenBase {
    private final SchematicWorld schematic;
    private final SchematicPrinter printer;
    private int centerX = 0;
    private int centerY = 0;
    private GuiNumericField numericX = null;
    private GuiNumericField numericY = null;
    private GuiNumericField numericZ = null;
    private GuiButton btnUnload = null;
    private GuiButton btnLayerMode = null;
    private GuiNumericField nfLayer = null;
    private GuiButton btnHide = null;
    private GuiButton btnMove = null;
    private GuiButton btnFlipDirection = null;
    private GuiButton btnFlip = null;
    private GuiButton btnRotateDirection = null;
    private GuiButton btnRotate = null;
    private GuiButton btnMaterials = null;
    private GuiButton btnPrint = null;
    private final String strMoveSchematic = I18n.func_135052_a((String)"schematica.gui.moveschematic", (Object[])new Object[0]);
    private final String strOperations = I18n.func_135052_a((String)"schematica.gui.operations", (Object[])new Object[0]);
    private final String strUnload = I18n.func_135052_a((String)"schematica.gui.unload", (Object[])new Object[0]);
    private final String strMaterials = I18n.func_135052_a((String)"schematica.gui.materials", (Object[])new Object[0]);
    private final String strPrinter = I18n.func_135052_a((String)"schematica.gui.printer", (Object[])new Object[0]);
    private final String strHide = I18n.func_135052_a((String)"schematica.gui.hide", (Object[])new Object[0]);
    private final String strShow = I18n.func_135052_a((String)"schematica.gui.show", (Object[])new Object[0]);
    private final String strX = I18n.func_135052_a((String)"schematica.gui.x", (Object[])new Object[0]);
    private final String strY = I18n.func_135052_a((String)"schematica.gui.y", (Object[])new Object[0]);
    private final String strZ = I18n.func_135052_a((String)"schematica.gui.z", (Object[])new Object[0]);
    private final String strOn = I18n.func_135052_a((String)"schematica.gui.on", (Object[])new Object[0]);
    private final String strOff = I18n.func_135052_a((String)"schematica.gui.off", (Object[])new Object[0]);

    public GuiSchematicControl(GuiScreen guiScreen) {
        super(guiScreen);
        this.schematic = ClientProxy.schematic;
        this.printer = SchematicPrinter.INSTANCE;
    }

    public void func_73866_w_() {
        this.centerX = this.field_146294_l / 2;
        this.centerY = this.field_146295_m / 2;
        this.field_146292_n.clear();
        int id = 0;
        this.numericX = new GuiNumericField(this.field_146289_q, id++, this.centerX - 50, this.centerY - 30, 100, 20);
        this.field_146292_n.add(this.numericX);
        this.numericY = new GuiNumericField(this.field_146289_q, id++, this.centerX - 50, this.centerY - 5, 100, 20);
        this.field_146292_n.add(this.numericY);
        this.numericZ = new GuiNumericField(this.field_146289_q, id++, this.centerX - 50, this.centerY + 20, 100, 20);
        this.field_146292_n.add(this.numericZ);
        this.btnUnload = new GuiButton(id++, this.field_146294_l - 90, this.field_146295_m - 200, 80, 20, this.strUnload);
        this.field_146292_n.add(this.btnUnload);
        this.btnLayerMode = new GuiButton(id++, this.field_146294_l - 90, this.field_146295_m - 150 - 25, 80, 20, I18n.func_135052_a((String)(this.schematic != null ? this.schematic.layerMode : SchematicWorld.LayerMode.ALL).name, (Object[])new Object[0]));
        this.field_146292_n.add(this.btnLayerMode);
        this.nfLayer = new GuiNumericField(this.field_146289_q, id++, this.field_146294_l - 90, this.field_146295_m - 150, 80, 20);
        this.field_146292_n.add(this.nfLayer);
        this.btnHide = new GuiButton(id++, this.field_146294_l - 90, this.field_146295_m - 105, 80, 20, this.schematic != null && this.schematic.isRendering ? this.strHide : this.strShow);
        this.field_146292_n.add(this.btnHide);
        this.btnMove = new GuiButton(id++, this.field_146294_l - 90, this.field_146295_m - 80, 80, 20, I18n.func_135052_a((String)"schematica.gui.movehere", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnMove);
        this.btnFlipDirection = new GuiButton(id++, this.field_146294_l - 180, this.field_146295_m - 55, 80, 20, I18n.func_135052_a((String)("schematica.gui." + ClientProxy.axisFlip.func_176610_l()), (Object[])new Object[0]));
        this.field_146292_n.add(this.btnFlipDirection);
        this.btnFlip = new GuiUnicodeGlyphButton(id++, this.field_146294_l - 90, this.field_146295_m - 55, 80, 20, " " + I18n.func_135052_a((String)"schematica.gui.flip", (Object[])new Object[0]), "\u2194", 2.0f);
        this.field_146292_n.add(this.btnFlip);
        this.btnRotateDirection = new GuiButton(id++, this.field_146294_l - 180, this.field_146295_m - 30, 80, 20, I18n.func_135052_a((String)("schematica.gui." + ClientProxy.axisRotation.func_176610_l()), (Object[])new Object[0]));
        this.field_146292_n.add(this.btnRotateDirection);
        this.btnRotate = new GuiUnicodeGlyphButton(id++, this.field_146294_l - 90, this.field_146295_m - 30, 80, 20, " " + I18n.func_135052_a((String)"schematica.gui.rotate", (Object[])new Object[0]), "\u21bb", 2.0f);
        this.field_146292_n.add(this.btnRotate);
        this.btnMaterials = new GuiButton(id++, 10, this.field_146295_m - 70, 80, 20, this.strMaterials);
        this.field_146292_n.add(this.btnMaterials);
        this.btnPrint = new GuiButton(id++, 10, this.field_146295_m - 30, 80, 20, this.printer.isPrinting() ? this.strOn : this.strOff);
        this.field_146292_n.add(this.btnPrint);
        this.numericX.setEnabled(this.schematic != null);
        this.numericY.setEnabled(this.schematic != null);
        this.numericZ.setEnabled(this.schematic != null);
        this.btnUnload.field_146124_l = this.schematic != null;
        this.btnLayerMode.field_146124_l = this.schematic != null;
        this.nfLayer.setEnabled(this.schematic != null && this.schematic.layerMode != SchematicWorld.LayerMode.ALL);
        this.btnHide.field_146124_l = this.schematic != null;
        this.btnMove.field_146124_l = this.schematic != null;
        this.btnFlipDirection.field_146124_l = this.schematic != null;
        this.btnFlip.field_146124_l = this.schematic != null;
        this.btnRotateDirection.field_146124_l = this.schematic != null;
        this.btnRotate.field_146124_l = this.schematic != null;
        this.btnMaterials.field_146124_l = this.schematic != null;
        this.btnPrint.field_146124_l = this.schematic != null && this.printer.isEnabled();
        this.setMinMax(this.numericX);
        this.setMinMax(this.numericY);
        this.setMinMax(this.numericZ);
        if (this.schematic != null) {
            this.setPoint(this.numericX, this.numericY, this.numericZ, (BlockPos)this.schematic.position);
        }
        this.nfLayer.setMinimum(0);
        this.nfLayer.setMaximum(this.schematic != null ? this.schematic.func_72800_K() - 1 : 0);
        if (this.schematic != null) {
            this.nfLayer.setValue(this.schematic.renderingLayer);
        }
    }

    private void setMinMax(GuiNumericField numericField) {
        numericField.setMinimum(-30000000);
        numericField.setMaximum(30000000);
    }

    private void setPoint(GuiNumericField numX, GuiNumericField numY, GuiNumericField numZ, BlockPos point) {
        numX.setValue(point.func_177958_n());
        numY.setValue(point.func_177956_o());
        numZ.setValue(point.func_177952_p());
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton.field_146124_l) {
            if (this.schematic == null) {
                return;
            }
            if (guiButton.field_146127_k == this.numericX.field_146127_k) {
                this.schematic.position.field_177962_a = this.numericX.getValue();
                RenderSchematic.INSTANCE.refresh();
            } else if (guiButton.field_146127_k == this.numericY.field_146127_k) {
                this.schematic.position.field_177960_b = this.numericY.getValue();
                RenderSchematic.INSTANCE.refresh();
            } else if (guiButton.field_146127_k == this.numericZ.field_146127_k) {
                this.schematic.position.field_177961_c = this.numericZ.getValue();
                RenderSchematic.INSTANCE.refresh();
            } else if (guiButton.field_146127_k == this.btnUnload.field_146127_k) {
                Schematica.proxy.unloadSchematic();
                this.field_146297_k.func_147108_a(this.parentScreen);
            } else if (guiButton.field_146127_k == this.btnLayerMode.field_146127_k) {
                this.schematic.layerMode = SchematicWorld.LayerMode.next(this.schematic.layerMode);
                this.btnLayerMode.field_146126_j = I18n.func_135052_a((String)this.schematic.layerMode.name, (Object[])new Object[0]);
                this.nfLayer.setEnabled(this.schematic.layerMode != SchematicWorld.LayerMode.ALL);
                RenderSchematic.INSTANCE.refresh();
            } else if (guiButton.field_146127_k == this.nfLayer.field_146127_k) {
                this.schematic.renderingLayer = this.nfLayer.getValue();
                RenderSchematic.INSTANCE.refresh();
            } else if (guiButton.field_146127_k == this.btnHide.field_146127_k) {
                this.btnHide.field_146126_j = this.schematic.toggleRendering() ? this.strHide : this.strShow;
            } else if (guiButton.field_146127_k == this.btnMove.field_146127_k) {
                ClientProxy.moveSchematicToPlayer(this.schematic);
                RenderSchematic.INSTANCE.refresh();
                this.setPoint(this.numericX, this.numericY, this.numericZ, (BlockPos)this.schematic.position);
            } else if (guiButton.field_146127_k == this.btnFlipDirection.field_146127_k) {
                EnumFacing[] values = EnumFacing.field_82609_l;
                ClientProxy.axisFlip = values[(ClientProxy.axisFlip.ordinal() + 2) % values.length];
                guiButton.field_146126_j = I18n.func_135052_a((String)("schematica.gui." + ClientProxy.axisFlip.func_176610_l()), (Object[])new Object[0]);
            } else if (guiButton.field_146127_k == this.btnFlip.field_146127_k) {
                if (FlipHelper.INSTANCE.flip(this.schematic, ClientProxy.axisFlip, GuiSchematicControl.func_146272_n())) {
                    RenderSchematic.INSTANCE.refresh();
                    SchematicPrinter.INSTANCE.refresh();
                }
            } else if (guiButton.field_146127_k == this.btnRotateDirection.field_146127_k) {
                EnumFacing[] values = EnumFacing.field_82609_l;
                ClientProxy.axisRotation = values[(ClientProxy.axisRotation.ordinal() + 1) % values.length];
                guiButton.field_146126_j = I18n.func_135052_a((String)("schematica.gui." + ClientProxy.axisRotation.func_176610_l()), (Object[])new Object[0]);
            } else if (guiButton.field_146127_k == this.btnRotate.field_146127_k) {
                if (RotationHelper.INSTANCE.rotate(this.schematic, ClientProxy.axisRotation, GuiSchematicControl.func_146272_n())) {
                    this.setPoint(this.numericX, this.numericY, this.numericZ, (BlockPos)this.schematic.position);
                    RenderSchematic.INSTANCE.refresh();
                    SchematicPrinter.INSTANCE.refresh();
                }
            } else if (guiButton.field_146127_k == this.btnMaterials.field_146127_k) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiSchematicMaterials((GuiScreen)this));
            } else if (guiButton.field_146127_k == this.btnPrint.field_146127_k && this.printer.isEnabled()) {
                boolean isPrinting = this.printer.togglePrinting();
                this.btnPrint.field_146126_j = isPrinting ? this.strOn : this.strOff;
            }
        }
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        if (this.btnFlip.field_146124_l) {
            int n = this.btnFlip.packedFGColour = GuiSchematicControl.func_146272_n() ? 0xFF0000 : 0;
        }
        if (this.btnRotate.field_146124_l) {
            this.btnRotate.packedFGColour = GuiSchematicControl.func_146272_n() ? 0xFF0000 : 0;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_73732_a(this.field_146289_q, this.strMoveSchematic, this.centerX, this.centerY - 45, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.strMaterials, 50, this.field_146295_m - 85, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.strPrinter, 50, this.field_146295_m - 45, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.strOperations, this.field_146294_l - 50, this.field_146295_m - 120, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strX, this.centerX - 65, this.centerY - 24, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strY, this.centerX - 65, this.centerY + 1, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strZ, this.centerX - 65, this.centerY + 26, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

