/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.gui.save;

import com.github.lunatrius.core.client.gui.GuiNumericField;
import com.github.lunatrius.core.client.gui.GuiScreenBase;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GuiSchematicSave
extends GuiScreenBase {
    private int centerX = 0;
    private int centerY = 0;
    private GuiButton btnPointA = null;
    private GuiNumericField numericAX = null;
    private GuiNumericField numericAY = null;
    private GuiNumericField numericAZ = null;
    private GuiButton btnPointB = null;
    private GuiNumericField numericBX = null;
    private GuiNumericField numericBY = null;
    private GuiNumericField numericBZ = null;
    private GuiButton btnEnable = null;
    private GuiButton btnFormat = null;
    private GuiButton btnSave = null;
    private GuiTextField tfFilename = null;
    private String filename = "";
    private String format;
    private Iterator<String> formatIterator = null;
    private final String strSaveSelection = I18n.func_135052_a((String)"schematica.gui.saveselection", (Object[])new Object[0]);
    private final String strX = I18n.func_135052_a((String)"schematica.gui.x", (Object[])new Object[0]);
    private final String strY = I18n.func_135052_a((String)"schematica.gui.y", (Object[])new Object[0]);
    private final String strZ = I18n.func_135052_a((String)"schematica.gui.z", (Object[])new Object[0]);
    private final String strOn = I18n.func_135052_a((String)"schematica.gui.on", (Object[])new Object[0]);
    private final String strOff = I18n.func_135052_a((String)"schematica.gui.off", (Object[])new Object[0]);

    public GuiSchematicSave(GuiScreen guiScreen) {
        super(guiScreen);
        this.format = this.nextFormat();
    }

    public void func_73866_w_() {
        this.centerX = this.field_146294_l / 2;
        this.centerY = this.field_146295_m / 2;
        this.field_146292_n.clear();
        int id = 0;
        this.btnPointA = new GuiButton(id++, this.centerX - 130, this.centerY - 55, 100, 20, I18n.func_135052_a((String)"schematica.gui.point.red", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnPointA);
        this.numericAX = new GuiNumericField(this.field_146289_q, id++, this.centerX - 130, this.centerY - 30);
        this.field_146292_n.add(this.numericAX);
        this.numericAY = new GuiNumericField(this.field_146289_q, id++, this.centerX - 130, this.centerY - 5);
        this.field_146292_n.add(this.numericAY);
        this.numericAZ = new GuiNumericField(this.field_146289_q, id++, this.centerX - 130, this.centerY + 20);
        this.field_146292_n.add(this.numericAZ);
        this.btnPointB = new GuiButton(id++, this.centerX + 30, this.centerY - 55, 100, 20, I18n.func_135052_a((String)"schematica.gui.point.blue", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnPointB);
        this.numericBX = new GuiNumericField(this.field_146289_q, id++, this.centerX + 30, this.centerY - 30);
        this.field_146292_n.add(this.numericBX);
        this.numericBY = new GuiNumericField(this.field_146289_q, id++, this.centerX + 30, this.centerY - 5);
        this.field_146292_n.add(this.numericBY);
        this.numericBZ = new GuiNumericField(this.field_146289_q, id++, this.centerX + 30, this.centerY + 20);
        this.field_146292_n.add(this.numericBZ);
        this.btnEnable = new GuiButton(id++, this.field_146294_l - 210, this.field_146295_m - 55, 50, 20, ClientProxy.isRenderingGuide && Schematica.proxy.isSaveEnabled ? this.strOn : this.strOff);
        this.field_146292_n.add(this.btnEnable);
        this.tfFilename = new GuiTextField(id++, this.field_146289_q, this.field_146294_l - 209, this.field_146295_m - 29, 153, 18);
        this.textFields.add(this.tfFilename);
        this.btnSave = new GuiButton(id++, this.field_146294_l - 50, this.field_146295_m - 30, 40, 20, I18n.func_135052_a((String)"schematica.gui.save", (Object[])new Object[0]));
        this.btnSave.field_146124_l = ClientProxy.isRenderingGuide && Schematica.proxy.isSaveEnabled || ClientProxy.schematic != null;
        this.field_146292_n.add(this.btnSave);
        this.btnFormat = new GuiButton(id++, this.field_146294_l - 155, this.field_146295_m - 55, 145, 20, I18n.func_135052_a((String)"schematica.gui.format", (Object[])new Object[]{I18n.func_135052_a((String)SchematicFormat.getFormatName(this.format), (Object[])new Object[0])}));
        this.btnFormat.field_146124_l = ClientProxy.isRenderingGuide && Schematica.proxy.isSaveEnabled || ClientProxy.schematic != null;
        this.field_146292_n.add(this.btnFormat);
        this.tfFilename.func_146203_f(1024);
        this.tfFilename.func_146180_a(this.filename);
        this.setMinMax(this.numericAX);
        this.setMinMax(this.numericAY);
        this.setMinMax(this.numericAZ);
        this.setMinMax(this.numericBX);
        this.setMinMax(this.numericBY);
        this.setMinMax(this.numericBZ);
        this.setPoint(this.numericAX, this.numericAY, this.numericAZ, (BlockPos)ClientProxy.pointA);
        this.setPoint(this.numericBX, this.numericBY, this.numericBZ, (BlockPos)ClientProxy.pointB);
    }

    private void setMinMax(GuiNumericField numericField) {
        numericField.setMinimum(-30000000);
        numericField.setMaximum(30000000);
    }

    private void setPoint(GuiNumericField numX, GuiNumericField numY, GuiNumericField numZ, BlockPos point) {
        numX.setValue(point.func_177958_n());
        numY.setValue(point.func_177956_o());
        numZ.setValue(point.func_177952_p());
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton.field_146124_l) {
            if (guiButton.field_146127_k == this.btnPointA.field_146127_k) {
                ClientProxy.movePointToPlayer(ClientProxy.pointA);
                ClientProxy.updatePoints();
                this.setPoint(this.numericAX, this.numericAY, this.numericAZ, (BlockPos)ClientProxy.pointA);
            } else if (guiButton.field_146127_k == this.numericAX.field_146127_k) {
                ClientProxy.pointA.field_177962_a = this.numericAX.getValue();
                ClientProxy.updatePoints();
            } else if (guiButton.field_146127_k == this.numericAY.field_146127_k) {
                ClientProxy.pointA.field_177960_b = this.numericAY.getValue();
                ClientProxy.updatePoints();
            } else if (guiButton.field_146127_k == this.numericAZ.field_146127_k) {
                ClientProxy.pointA.field_177961_c = this.numericAZ.getValue();
                ClientProxy.updatePoints();
            } else if (guiButton.field_146127_k == this.btnPointB.field_146127_k) {
                ClientProxy.movePointToPlayer(ClientProxy.pointB);
                ClientProxy.updatePoints();
                this.setPoint(this.numericBX, this.numericBY, this.numericBZ, (BlockPos)ClientProxy.pointB);
            } else if (guiButton.field_146127_k == this.numericBX.field_146127_k) {
                ClientProxy.pointB.field_177962_a = this.numericBX.getValue();
                ClientProxy.updatePoints();
            } else if (guiButton.field_146127_k == this.numericBY.field_146127_k) {
                ClientProxy.pointB.field_177960_b = this.numericBY.getValue();
                ClientProxy.updatePoints();
            } else if (guiButton.field_146127_k == this.numericBZ.field_146127_k) {
                ClientProxy.pointB.field_177961_c = this.numericBZ.getValue();
                ClientProxy.updatePoints();
            } else if (guiButton.field_146127_k == this.btnEnable.field_146127_k) {
                ClientProxy.isRenderingGuide = !ClientProxy.isRenderingGuide && Schematica.proxy.isSaveEnabled;
                this.btnEnable.field_146126_j = ClientProxy.isRenderingGuide ? this.strOn : this.strOff;
                this.btnSave.field_146124_l = ClientProxy.isRenderingGuide || ClientProxy.schematic != null;
                this.btnFormat.field_146124_l = ClientProxy.isRenderingGuide || ClientProxy.schematic != null;
            } else if (guiButton.field_146127_k == this.btnFormat.field_146127_k) {
                this.format = this.nextFormat();
                this.btnFormat.field_146126_j = I18n.func_135052_a((String)"schematica.gui.format", (Object[])new Object[]{I18n.func_135052_a((String)SchematicFormat.getFormatName(this.format), (Object[])new Object[0])});
            } else if (guiButton.field_146127_k == this.btnSave.field_146127_k) {
                String path = this.tfFilename.func_146179_b() + SchematicFormat.getExtension(this.format);
                if (ClientProxy.isRenderingGuide) {
                    if (Schematica.proxy.saveSchematic((EntityPlayer)this.field_146297_k.field_71439_g, ConfigurationHandler.schematicDirectory, path, (World)this.field_146297_k.field_71441_e, this.format, (BlockPos)ClientProxy.pointMin, (BlockPos)ClientProxy.pointMax)) {
                        this.filename = "";
                        this.tfFilename.func_146180_a(this.filename);
                    }
                } else {
                    SchematicFormat.writeToFileAndNotify(new File(ConfigurationHandler.schematicDirectory, path), this.format, ClientProxy.schematic.getSchematic(), (EntityPlayer)this.field_146297_k.field_71439_g);
                }
            }
        }
    }

    protected void func_73869_a(char character, int code) throws IOException {
        super.func_73869_a(character, code);
        this.filename = this.tfFilename.func_146179_b();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_73731_b(this.field_146289_q, this.strSaveSelection, this.field_146294_l - 205, this.field_146295_m - 70, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strX, this.centerX - 145, this.centerY - 24, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, Integer.toString(ClientProxy.pointA.field_177962_a), this.centerX - 25, this.centerY - 24, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strY, this.centerX - 145, this.centerY + 1, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, Integer.toString(ClientProxy.pointA.field_177960_b), this.centerX - 25, this.centerY + 1, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strZ, this.centerX - 145, this.centerY + 26, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, Integer.toString(ClientProxy.pointA.field_177961_c), this.centerX - 25, this.centerY + 26, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strX, this.centerX + 15, this.centerY - 24, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, Integer.toString(ClientProxy.pointB.field_177962_a), this.centerX + 135, this.centerY - 24, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strY, this.centerX + 15, this.centerY + 1, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, Integer.toString(ClientProxy.pointB.field_177960_b), this.centerX + 135, this.centerY + 1, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strZ, this.centerX + 15, this.centerY + 26, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, Integer.toString(ClientProxy.pointB.field_177961_c), this.centerX + 135, this.centerY + 26, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private String nextFormat() {
        if (this.formatIterator == null) {
            assert (SchematicFormat.FORMATS.size() > 0) : "No formats are defined!";
            assert (SchematicFormat.FORMATS.containsKey(SchematicFormat.FORMAT_DEFAULT)) : "The default format does not exist!";
            this.formatIterator = SchematicFormat.FORMATS.keySet().iterator();
            while (!this.formatIterator.next().equals(SchematicFormat.FORMAT_DEFAULT)) {
            }
            return SchematicFormat.FORMAT_DEFAULT;
        }
        if (!this.formatIterator.hasNext()) {
            this.formatIterator = SchematicFormat.FORMATS.keySet().iterator();
        }
        return this.formatIterator.next();
    }
}

