/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.printer.registry;

import com.github.lunatrius.schematica.client.printer.registry.IExtraClick;
import com.github.lunatrius.schematica.client.printer.registry.IOffset;
import com.github.lunatrius.schematica.client.printer.registry.IValidBlockFacing;
import com.github.lunatrius.schematica.client.printer.registry.IValidPlayerFacing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PlacementData {
    private final IValidPlayerFacing validPlayerFacing;
    private final IValidBlockFacing validBlockFacing;
    private IOffset offsetX;
    private IOffset offsetY;
    private IOffset offsetZ;
    private IExtraClick extraClick;

    public PlacementData() {
        this(null, null);
    }

    public PlacementData(IValidPlayerFacing validPlayerFacing) {
        this(validPlayerFacing, null);
    }

    public PlacementData(IValidBlockFacing validBlockFacing) {
        this(null, validBlockFacing);
    }

    public PlacementData(IValidPlayerFacing validPlayerFacing, IValidBlockFacing validBlockFacing) {
        this.validPlayerFacing = validPlayerFacing;
        this.validBlockFacing = validBlockFacing;
        this.offsetX = null;
        this.offsetY = null;
        this.offsetZ = null;
    }

    public PlacementData setOffsetX(IOffset offset) {
        this.offsetX = offset;
        return this;
    }

    public PlacementData setOffsetY(IOffset offset) {
        this.offsetY = offset;
        return this;
    }

    public PlacementData setOffsetZ(IOffset offset) {
        this.offsetZ = offset;
        return this;
    }

    public PlacementData setExtraClick(IExtraClick extraClick) {
        this.extraClick = extraClick;
        return this;
    }

    public float getOffsetX(IBlockState blockState) {
        if (this.offsetX != null) {
            return this.offsetX.getOffset(blockState);
        }
        return 0.5f;
    }

    public float getOffsetY(IBlockState blockState) {
        if (this.offsetY != null) {
            return this.offsetY.getOffset(blockState);
        }
        return 0.5f;
    }

    public float getOffsetZ(IBlockState blockState) {
        if (this.offsetZ != null) {
            return this.offsetZ.getOffset(blockState);
        }
        return 0.5f;
    }

    public int getExtraClicks(IBlockState blockState) {
        if (this.extraClick != null) {
            return this.extraClick.getExtraClicks(blockState);
        }
        return 0;
    }

    public boolean isValidPlayerFacing(IBlockState blockState, EntityPlayer player, BlockPos pos, World world) {
        return this.validPlayerFacing == null || this.validPlayerFacing.isValid(blockState, player, pos, world);
    }

    public List<EnumFacing> getValidBlockFacings(List<EnumFacing> solidSides, IBlockState blockState) {
        List<EnumFacing> list = this.validBlockFacing != null ? this.validBlockFacing.getValidBlockFacings(solidSides, blockState) : new ArrayList<EnumFacing>(solidSides);
        Iterator<EnumFacing> iterator = list.iterator();
        while (iterator.hasNext()) {
            EnumFacing facing = iterator.next();
            if (this.offsetY == null) continue;
            float offset = this.offsetY.getOffset(blockState);
            if ((double)offset < 0.5 && facing == EnumFacing.UP) {
                iterator.remove();
                continue;
            }
            if (!((double)offset > 0.5) || facing != EnumFacing.DOWN) continue;
            iterator.remove();
        }
        return list;
    }
}

