/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.printer.registry;

import com.github.lunatrius.schematica.block.state.BlockStateHelper;
import com.github.lunatrius.schematica.client.printer.registry.IExtraClick;
import com.github.lunatrius.schematica.client.printer.registry.IOffset;
import com.github.lunatrius.schematica.client.printer.registry.IValidBlockFacing;
import com.github.lunatrius.schematica.client.printer.registry.IValidPlayerFacing;
import com.github.lunatrius.schematica.client.printer.registry.PlacementData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class PlacementRegistry {
    public static final PlacementRegistry INSTANCE = new PlacementRegistry();
    private final Map<Class<? extends Block>, PlacementData> classPlacementMap = new LinkedHashMap<Class<? extends Block>, PlacementData>();
    private final Map<Block, PlacementData> blockPlacementMap = new HashMap<Block, PlacementData>();
    private final Map<Item, PlacementData> itemPlacementMap = new HashMap<Item, PlacementData>();

    private void populateMappings() {
        this.classPlacementMap.clear();
        this.blockPlacementMap.clear();
        this.itemPlacementMap.clear();
        IValidPlayerFacing playerFacingEntity = (blockState, player, pos, world) -> {
            EnumFacing facing = (EnumFacing)BlockStateHelper.getPropertyValue(blockState, "facing");
            return facing == player.func_174811_aO();
        };
        IValidPlayerFacing playerFacingEntityOpposite = (blockState, player, pos, world) -> {
            EnumFacing facing = (EnumFacing)BlockStateHelper.getPropertyValue(blockState, "facing");
            return facing == player.func_174811_aO().func_176734_d();
        };
        IValidPlayerFacing playerFacingPiston = (blockState, player, pos, world) -> {
            EnumFacing facing = (EnumFacing)BlockStateHelper.getPropertyValue(blockState, "facing");
            return facing == EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)player);
        };
        IValidPlayerFacing playerFacingObserver = (blockState, player, pos, world) -> {
            EnumFacing facing = (EnumFacing)BlockStateHelper.getPropertyValue(blockState, "facing");
            return facing == EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)player).func_176734_d();
        };
        IValidPlayerFacing playerFacingRotateY = (blockState, player, pos, world) -> {
            EnumFacing facing = (EnumFacing)BlockStateHelper.getPropertyValue(blockState, "facing");
            return facing == player.func_174811_aO().func_176746_e();
        };
        IValidPlayerFacing playerFacingLever = (blockState, player, pos, world) -> {
            BlockLever.EnumOrientation value = (BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a);
            return !value.func_176852_c().func_176740_k().func_176720_b() || BlockLever.EnumOrientation.func_176856_a((EnumFacing)value.func_176852_c(), (EnumFacing)player.func_174811_aO()) == value;
        };
        IValidPlayerFacing playerFacingStandingSign = (blockState, player, pos, world) -> {
            int facing;
            int value = (Integer)blockState.func_177229_b((IProperty)BlockStandingSign.field_176413_a);
            return value == (facing = MathHelper.func_76128_c((double)(((double)player.field_70177_z + 180.0) * 16.0 / 360.0 + 0.5)) & 0xF);
        };
        IValidPlayerFacing playerFacingIgnore = (blockState, player, pos, world) -> false;
        IOffset offsetSlab = blockState -> {
            if (!((BlockSlab)blockState.func_177230_c()).func_176552_j()) {
                BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)blockState.func_177229_b((IProperty)BlockSlab.field_176554_a);
                return half == BlockSlab.EnumBlockHalf.TOP ? 1.0f : 0.0f;
            }
            return 0.0f;
        };
        IOffset offsetStairs = blockState -> {
            BlockStairs.EnumHalf half = (BlockStairs.EnumHalf)blockState.func_177229_b((IProperty)BlockStairs.field_176308_b);
            return half == BlockStairs.EnumHalf.TOP ? 1.0f : 0.0f;
        };
        IOffset offsetTrapDoor = blockState -> {
            BlockTrapDoor.DoorHalf half = (BlockTrapDoor.DoorHalf)blockState.func_177229_b((IProperty)BlockTrapDoor.field_176285_M);
            return half == BlockTrapDoor.DoorHalf.TOP ? 1.0f : 0.0f;
        };
        IValidBlockFacing blockFacingLog = (solidSides, blockState) -> {
            ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
            BlockLog.EnumAxis axis = (BlockLog.EnumAxis)blockState.func_177229_b((IProperty)BlockLog.field_176299_a);
            for (EnumFacing side : solidSides) {
                if (axis != BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)side.func_176740_k())) continue;
                list.add(side);
            }
            return list;
        };
        IValidBlockFacing blockFacingPillar = (solidSides, blockState) -> {
            ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
            EnumFacing.Axis axis = (EnumFacing.Axis)blockState.func_177229_b((IProperty)BlockRotatedPillar.field_176298_M);
            for (EnumFacing side : solidSides) {
                if (axis != side.func_176740_k()) continue;
                list.add(side);
            }
            return list;
        };
        IValidBlockFacing blockFacingOpposite = (solidSides, blockState) -> {
            ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
            IProperty propertyFacing = BlockStateHelper.getProperty(blockState, "facing");
            if (propertyFacing != null && propertyFacing.func_177699_b().equals(EnumFacing.class)) {
                EnumFacing facing = (EnumFacing)blockState.func_177229_b(propertyFacing);
                for (EnumFacing side : solidSides) {
                    if (facing.func_176734_d() != side) continue;
                    list.add(side);
                }
            }
            return list;
        };
        IValidBlockFacing blockFacingSame = (solidSides, blockState) -> {
            ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
            IProperty propertyFacing = BlockStateHelper.getProperty(blockState, "facing");
            if (propertyFacing != null && propertyFacing.func_177699_b().equals(EnumFacing.class)) {
                EnumFacing facing = (EnumFacing)blockState.func_177229_b(propertyFacing);
                for (EnumFacing side : solidSides) {
                    if (facing != side) continue;
                    list.add(side);
                }
            }
            return list;
        };
        IValidBlockFacing blockFacingHopper = (solidSides, blockState) -> {
            ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockHopper.field_176430_a);
            for (EnumFacing side : solidSides) {
                if (facing != side) continue;
                list.add(side);
            }
            return list;
        };
        IValidBlockFacing blockFacingLever = (solidSides, blockState) -> {
            ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
            BlockLever.EnumOrientation facing = (BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a);
            for (EnumFacing side : solidSides) {
                if (facing.func_176852_c().func_176734_d() != side) continue;
                list.add(side);
            }
            return list;
        };
        IValidBlockFacing blockFacingQuartz = (solidSides, blockState) -> {
            ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
            BlockQuartz.EnumType variant = (BlockQuartz.EnumType)blockState.func_177229_b((IProperty)BlockQuartz.field_176335_a);
            for (EnumFacing side : solidSides) {
                if (variant == BlockQuartz.EnumType.LINES_X && side.func_176740_k() != EnumFacing.Axis.X || variant == BlockQuartz.EnumType.LINES_Y && side.func_176740_k() != EnumFacing.Axis.Y || variant == BlockQuartz.EnumType.LINES_Z && side.func_176740_k() != EnumFacing.Axis.Z) continue;
                list.add(side);
            }
            return list;
        };
        IExtraClick extraClickDoubleSlab = blockState -> ((BlockSlab)blockState.func_177230_c()).func_176552_j() ? 1 : 0;
        this.addPlacementMapping(BlockLog.class, new PlacementData(blockFacingLog));
        this.addPlacementMapping(BlockButton.class, new PlacementData(blockFacingOpposite));
        this.addPlacementMapping(BlockChest.class, new PlacementData(playerFacingEntityOpposite));
        this.addPlacementMapping(BlockDispenser.class, new PlacementData(playerFacingPiston));
        this.addPlacementMapping(BlockDoor.class, new PlacementData(playerFacingEntity));
        this.addPlacementMapping(BlockEnderChest.class, new PlacementData(playerFacingEntityOpposite));
        this.addPlacementMapping(BlockEndRod.class, new PlacementData(blockFacingOpposite));
        this.addPlacementMapping(BlockFenceGate.class, new PlacementData(playerFacingEntity));
        this.addPlacementMapping(BlockFurnace.class, new PlacementData(playerFacingEntityOpposite));
        this.addPlacementMapping(BlockHopper.class, new PlacementData(blockFacingHopper));
        this.addPlacementMapping(BlockObserver.class, new PlacementData(playerFacingObserver));
        this.addPlacementMapping(BlockPistonBase.class, new PlacementData(playerFacingPiston));
        this.addPlacementMapping(BlockPumpkin.class, new PlacementData(playerFacingEntityOpposite));
        this.addPlacementMapping(BlockRotatedPillar.class, new PlacementData(blockFacingPillar));
        this.addPlacementMapping(BlockSlab.class, new PlacementData().setOffsetY(offsetSlab).setExtraClick(extraClickDoubleSlab));
        this.addPlacementMapping(BlockStairs.class, new PlacementData(playerFacingEntity).setOffsetY(offsetStairs));
        this.addPlacementMapping(BlockTorch.class, new PlacementData(blockFacingOpposite));
        this.addPlacementMapping(BlockTrapDoor.class, new PlacementData(blockFacingOpposite).setOffsetY(offsetTrapDoor));
        this.addPlacementMapping(Blocks.field_150467_bQ, new PlacementData(playerFacingRotateY));
        this.addPlacementMapping(Blocks.field_185777_dd, new PlacementData(playerFacingEntityOpposite));
        this.addPlacementMapping(Blocks.field_150375_by, new PlacementData(blockFacingSame));
        this.addPlacementMapping(Blocks.field_150378_br, new PlacementData(playerFacingEntityOpposite));
        this.addPlacementMapping(Blocks.field_150468_ap, new PlacementData(blockFacingOpposite));
        this.addPlacementMapping(Blocks.field_150442_at, new PlacementData(playerFacingLever, blockFacingLever));
        this.addPlacementMapping(Blocks.field_150371_ca, new PlacementData(blockFacingQuartz));
        this.addPlacementMapping(Blocks.field_185776_dc, new PlacementData(playerFacingEntityOpposite));
        this.addPlacementMapping(Blocks.field_150472_an, new PlacementData(playerFacingStandingSign));
        this.addPlacementMapping((Block)Blocks.field_150479_bC, new PlacementData(blockFacingOpposite));
        this.addPlacementMapping(Blocks.field_150444_as, new PlacementData(blockFacingOpposite));
        this.addPlacementMapping(Items.field_151132_bS, new PlacementData(playerFacingEntityOpposite));
        this.addPlacementMapping(Items.field_151107_aW, new PlacementData(playerFacingEntityOpposite));
        this.addPlacementMapping(Blocks.field_150324_C, new PlacementData(playerFacingIgnore));
        this.addPlacementMapping(Blocks.field_150384_bq, new PlacementData(playerFacingIgnore));
        this.addPlacementMapping((Block)Blocks.field_180384_M, new PlacementData(playerFacingIgnore));
        this.addPlacementMapping((Block)Blocks.field_150332_K, new PlacementData(playerFacingIgnore));
        this.addPlacementMapping((Block)Blocks.field_150427_aO, new PlacementData(playerFacingIgnore));
        this.addPlacementMapping((Block)Blocks.field_150465_bP, new PlacementData(playerFacingIgnore));
        this.addPlacementMapping(Blocks.field_180393_cK, new PlacementData(playerFacingIgnore));
        this.addPlacementMapping(Blocks.field_180394_cL, new PlacementData(playerFacingIgnore));
    }

    private PlacementData addPlacementMapping(Class<? extends Block> clazz, PlacementData data) {
        if (clazz == null || data == null) {
            return null;
        }
        return this.classPlacementMap.put(clazz, data);
    }

    private PlacementData addPlacementMapping(Block block, PlacementData data) {
        if (block == null || data == null) {
            return null;
        }
        return this.blockPlacementMap.put(block, data);
    }

    private PlacementData addPlacementMapping(Item item, PlacementData data) {
        if (item == null || data == null) {
            return null;
        }
        return this.itemPlacementMap.put(item, data);
    }

    public PlacementData getPlacementData(IBlockState blockState, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        PlacementData placementDataItem = this.itemPlacementMap.get(item);
        if (placementDataItem != null) {
            return placementDataItem;
        }
        Block block = blockState.func_177230_c();
        PlacementData placementDataBlock = this.blockPlacementMap.get(block);
        if (placementDataBlock != null) {
            return placementDataBlock;
        }
        for (Class<? extends Block> clazz : this.classPlacementMap.keySet()) {
            if (!clazz.isInstance(block)) continue;
            return this.classPlacementMap.get(clazz);
        }
        return null;
    }

    static {
        INSTANCE.populateMappings();
    }
}

