/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.world;

import com.github.lunatrius.core.util.math.BlockPosHelper;
import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.block.state.pattern.BlockStateReplacer;
import com.github.lunatrius.schematica.client.world.chunk.ChunkProviderSchematic;
import com.github.lunatrius.schematica.reference.Reference;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SchematicWorld
extends WorldClient {
    private static final WorldSettings WORLD_SETTINGS = new WorldSettings(0L, GameType.CREATIVE, false, false, WorldType.field_77138_c);
    private ISchematic schematic;
    public final MBlockPos position = new MBlockPos();
    public boolean isRendering = false;
    public LayerMode layerMode = LayerMode.ALL;
    public int renderingLayer = 0;

    public SchematicWorld(ISchematic schematic) {
        super(null, WORLD_SETTINGS, 0, EnumDifficulty.PEACEFUL, Minecraft.func_71410_x().field_71424_I);
        this.schematic = schematic;
        for (TileEntity tileEntity : schematic.getTileEntities()) {
            this.initializeTileEntity(tileEntity);
        }
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (!this.layerMode.shouldUseLayer(this, pos.func_177956_o())) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.schematic.getBlockState(pos);
    }

    public boolean func_180501_a(BlockPos pos, IBlockState state, int flags) {
        return this.schematic.setBlockState(pos, state);
    }

    public TileEntity func_175625_s(BlockPos pos) {
        if (!this.layerMode.shouldUseLayer(this, pos.func_177956_o())) {
            return null;
        }
        return this.schematic.getTileEntity(pos);
    }

    public void func_175690_a(BlockPos pos, TileEntity tileEntity) {
        this.schematic.setTileEntity(pos, tileEntity);
        this.initializeTileEntity(tileEntity);
    }

    public void func_175713_t(BlockPos pos) {
        this.schematic.removeTileEntity(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175705_a(EnumSkyBlock type, BlockPos pos) {
        return 15;
    }

    public float func_175724_o(BlockPos pos) {
        return 1.0f;
    }

    public boolean func_175677_d(BlockPos pos, boolean _default) {
        return this.func_180495_p(pos).func_185915_l();
    }

    public void func_72966_v() {
    }

    protected void func_72947_a() {
    }

    public void func_175652_B(BlockPos pos) {
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState blockState = this.func_180495_p(pos);
        return blockState.func_177230_c().isAir(blockState, (IBlockAccess)this, pos);
    }

    public Biome func_180494_b(BlockPos pos) {
        return Biomes.field_76782_w;
    }

    public int getWidth() {
        return this.schematic.getWidth();
    }

    public int getLength() {
        return this.schematic.getLength();
    }

    public int func_72800_K() {
        return this.schematic.getHeight();
    }

    protected IChunkProvider func_72970_h() {
        this.field_73020_y = new ChunkProviderSchematic(this);
        return this.field_73020_y;
    }

    public Entity func_73045_a(int id) {
        return null;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side) {
        return this.isSideSolid(pos, side, false);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }

    public void setSchematic(ISchematic schematic) {
        this.schematic = schematic;
    }

    public ISchematic getSchematic() {
        return this.schematic;
    }

    public void initializeTileEntity(TileEntity tileEntity) {
        tileEntity.func_145834_a((World)this);
        tileEntity.func_145838_q();
        try {
            tileEntity.func_145843_s();
            tileEntity.func_145829_t();
        }
        catch (Exception e) {
            Reference.logger.error("TileEntity validation for {} failed!", tileEntity.getClass(), (Object)e);
        }
    }

    public void setIcon(ItemStack icon) {
        this.schematic.setIcon(icon);
    }

    public ItemStack getIcon() {
        return this.schematic.getIcon();
    }

    public List<TileEntity> getTileEntities() {
        return this.schematic.getTileEntities();
    }

    public boolean toggleRendering() {
        this.isRendering = !this.isRendering;
        return this.isRendering;
    }

    public String getDebugDimensions() {
        return "WHL: " + this.getWidth() + " / " + this.func_72800_K() + " / " + this.getLength();
    }

    public int replaceBlock(BlockStateMatcher matcher, BlockStateReplacer replacer, Map<IProperty, Comparable> properties) {
        int count = 0;
        for (MBlockPos pos : BlockPosHelper.getAllInBox((int)0, (int)0, (int)0, (int)this.getWidth(), (int)this.func_72800_K(), (int)this.getLength())) {
            IBlockState replacement;
            IBlockState blockState = this.schematic.getBlockState((BlockPos)pos);
            if (blockState.func_177230_c().hasTileEntity(blockState) || !matcher.apply(blockState) || (replacement = replacer.getReplacement(blockState, properties)).func_177230_c().hasTileEntity(replacement) || !this.schematic.setBlockState((BlockPos)pos, replacement)) continue;
            this.func_184138_a((BlockPos)pos.add((Vec3i)this.position), blockState, replacement, 3);
            ++count;
        }
        return count;
    }

    public boolean isInside(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return x >= 0 && y >= 0 && z >= 0 && x < this.getWidth() && y < this.func_72800_K() && z < this.getLength();
    }

    public static enum LayerMode {
        ALL("schematica.gui.all"){

            @Override
            public boolean shouldUseLayer(SchematicWorld world, int layer) {
                return true;
            }
        }
        ,
        SINGLE_LAYER("schematica.gui.layers"){

            @Override
            public boolean shouldUseLayer(SchematicWorld world, int layer) {
                return layer == world.renderingLayer;
            }
        }
        ,
        ALL_BELOW("schematica.gui.below"){

            @Override
            public boolean shouldUseLayer(SchematicWorld world, int layer) {
                return layer <= world.renderingLayer;
            }
        };

        public final String name;

        public abstract boolean shouldUseLayer(SchematicWorld var1, int var2);

        private LayerMode(String name) {
            this.name = name;
        }

        public static LayerMode next(LayerMode mode) {
            LayerMode[] values = LayerMode.values();
            return values[(mode.ordinal() + 1) % values.length];
        }
    }
}

