/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.command;

import com.github.lunatrius.core.util.FileUtils;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.command.CommandSchematicaBase;
import com.github.lunatrius.schematica.handler.DownloadHandler;
import com.github.lunatrius.schematica.network.transfer.SchematicTransfer;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.util.FileFilterSchematic;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CommandSchematicaDownload
extends CommandSchematicaBase {
    private static final FileFilterSchematic FILE_FILTER_SCHEMATIC = new FileFilterSchematic(false);

    public String func_71517_b() {
        return "schematicaDownload";
    }

    public String func_71518_a(ICommandSender sender) {
        return "schematica.command.download.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (!(sender instanceof EntityPlayer)) {
            return Collections.emptyList();
        }
        File directory = Schematica.proxy.getPlayerSchematicDirectory((EntityPlayer)sender, true);
        File[] files = directory.listFiles(FILE_FILTER_SCHEMATIC);
        if (files != null) {
            ArrayList<String> filenames = new ArrayList<String>();
            for (File file : files) {
                filenames.add(file.getName());
            }
            return CommandSchematicaDownload.func_175762_a((String[])args, filenames);
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (!(sender instanceof EntityPlayerMP)) {
            throw new CommandException("schematica.command.save.playersOnly", new Object[0]);
        }
        String filename = String.join((CharSequence)" ", args);
        EntityPlayerMP player = (EntityPlayerMP)sender;
        File directory = Schematica.proxy.getPlayerSchematicDirectory((EntityPlayer)player, true);
        if (!FileUtils.contains((File)directory, (String)filename)) {
            Reference.logger.error("{} has tried to download the file {}", (Object)player.func_70005_c_(), (Object)filename);
            throw new CommandException("schematica.command.download.downloadFail", new Object[0]);
        }
        ISchematic schematic = SchematicFormat.readFromFile(directory, filename);
        if (schematic == null) {
            throw new CommandException("schematica.command.download.downloadFail", new Object[0]);
        }
        DownloadHandler.INSTANCE.transferMap.put(player, new SchematicTransfer(schematic, filename));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("schematica.command.download.started", new Object[]{filename}));
    }
}

