/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.client.sounds;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AlarmResource
implements IResourcePack {
    public static final String PACK_NAME = "opensecurity";
    public static Map<String, String> sound_map = new HashMap<String, String>();
    private static File mc_dir = Minecraft.func_71410_x().field_71412_D;

    public InputStream func_110590_a(ResourceLocation resourceLocation) throws IOException {
        if (resourceLocation.func_110623_a().equals("sounds.json")) {
            return AlarmResource.generateSoundsJSON();
        }
        return this.getResourceStream(resourceLocation);
    }

    public boolean func_110589_b(ResourceLocation l) {
        return this.isResourceFromThisPack(l) && (l.func_110623_a().equals("sounds.json") || this.isResourceFromThisPack(l) && this.getRealPath(l.func_110623_a()).exists());
    }

    public Set<String> func_110587_b() {
        return Sets.newHashSet((Object[])new String[]{this.func_130077_b()});
    }

    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) {
        return null;
    }

    public BufferedImage func_110586_a() {
        return null;
    }

    public String func_130077_b() {
        return PACK_NAME;
    }

    private InputStream getResourceStream(ResourceLocation l) {
        try {
            return new FileInputStream(mc_dir + "/mods/OpenSecurity/assets/opensecurity/sounds/" + l.func_110623_a().substring(7));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isResourceFromThisPack(ResourceLocation l) {
        return l.func_110624_b().equals(this.func_130077_b());
    }

    private File getRealPath(String file) {
        return new File(mc_dir.getAbsolutePath(), "/mods/OpenSecurity/assets/opensecurity/sounds/" + file.substring(7));
    }

    private static InputStream generateSoundsJSON() {
        JsonObject root = new JsonObject();
        for (Map.Entry<String, String> entry : sound_map.entrySet()) {
            JsonObject event = new JsonObject();
            event.addProperty("category", "records");
            JsonArray sounds = new JsonArray();
            JsonObject sound = new JsonObject();
            sound.addProperty("name", "opensecurity:alarms/" + entry.getValue().substring(0, entry.getValue().lastIndexOf(46)));
            sound.addProperty("stream", Boolean.valueOf(false));
            sounds.add((JsonElement)sound);
            event.add("sounds", (JsonElement)sounds);
            root.add(entry.getValue().substring(0, entry.getValue().lastIndexOf(46)), (JsonElement)event);
        }
        return new ByteArrayInputStream(new Gson().toJson((JsonElement)root).getBytes());
    }

    public void addSoundReferenceMapping(int recordNum, String pathToSound) {
        sound_map.put(PACK_NAME + recordNum, pathToSound);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerAsResourceLocation() {
        List defaultResourcePacks = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
        defaultResourcePacks.add(this);
        Minecraft.func_71410_x().func_110436_a();
    }
}

