/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import pcl.opensecurity.Config;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.common.tileentity.TileEntityOSSound;

public class TileEntityAlarm
extends TileEntityOSSound {
    public static float volumeMax = 15.0f;

    public TileEntityAlarm() {
        super("os_alarm");
        this.setSound("klaxon1");
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    }

    public TileEntityAlarm(EnvironmentHost host) {
        super("os_alarm", host);
    }

    @Callback(doc="function(range:integer):string; Sets the range in blocks of the alarm", direct=true)
    public Object[] setRange(Context context, Arguments args) {
        if (args.count() == 0) {
            return new Object[]{false, "missing arguments"};
        }
        this.setVolume(Math.max(0.0f, Math.min((float)args.checkInteger(0) + 0.5f, volumeMax)));
        return new Object[]{true, Float.valueOf(this.getVolume() - 0.5f)};
    }

    @Callback(doc="function(soundName:string):string; Sets the alarm sound", direct=true)
    public Object[] setAlarm(Context context, Arguments args) {
        if (args.count() == 0) {
            return new Object[]{false, "missing arguments"};
        }
        String sound = args.checkString(0);
        this.setSound(sound);
        if (!this.isUpgrade) {
            this.func_189517_E_();
            this.func_70296_d();
        }
        return new Object[]{true};
    }

    @Callback(doc="function():string; Activates the alarm", direct=true)
    public Object[] activate(Context context, Arguments args) {
        this.setShouldPlay(true);
        return new Object[]{true};
    }

    @Callback(doc="function():string; Deactivates the alarm", direct=true)
    public Object[] deactivate(Context context, Arguments args) {
        this.setShouldPlay(false);
        return new Object[]{true};
    }

    @Callback(doc="function():array; returns a list of the available sounds", direct=true)
    public Object[] listSounds(Context context, Arguments args) {
        return new Object[]{OpenSecurity.alarmList.toArray()};
    }

    @Callback(doc="function(int:x, int:y, int:z [, string:sound, float:range(1-15 recommended)]):string; Plays sound at x y z", direct=true)
    public Object[] playSoundAt(Context context, Arguments args) {
        if (!Config.getConfig().getCategory("general").get("enableplaySoundAt").getBoolean()) {
            return new Object[]{false, "Feature disabled in configuration"};
        }
        if (args.count() < 3) {
            return new Object[]{false, "missing arguments"};
        }
        BlockPos alarmPosition = new BlockPos(args.checkDouble(0), args.checkDouble(1), args.checkDouble(2)).func_177971_a((Vec3i)this.func_174877_v());
        String sound = args.optString(3, this.getSoundName());
        float range = (float)Math.max(0.0, Math.min(args.optDouble(4, (double)(this.getVolume() - 0.5f)) + 0.5, (double)volumeMax));
        this.func_145831_w().func_184133_a(null, alarmPosition, new SoundEvent(new ResourceLocation(sound)), SoundCategory.BLOCKS, range, 1.0f);
        if (!this.isUpgrade) {
            this.func_189517_E_();
            this.func_70296_d();
        }
        return new Object[]{true};
    }

    @Override
    public boolean canUpdate() {
        return true;
    }
}

