/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.awt.Color;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.Nonnull;
import li.cil.oc.Settings;
import li.cil.oc.api.Items;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pcl.opensecurity.Config;
import pcl.opensecurity.common.items.ItemCard;
import pcl.opensecurity.common.items.ItemMagCard;
import pcl.opensecurity.common.items.ItemRFIDCard;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;

public class TileEntityCardWriter
extends TileEntityOSBase
implements ITickable {
    public static final int SIZE = 2;
    public boolean hasCards = false;
    private ItemStackHandler inventoryInput;
    private ItemStackHandler inventoryOutput;

    public TileEntityCardWriter() {
        super("os_cardwriter");
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
        if (this.node() != null) {
            this.initOCFilesystem("/lua/cardwriter/", "cardwriter");
        }
        this.inventoryInput = new ItemStackHandler(1);
        this.inventoryOutput = new ItemStackHandler(1){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
    }

    @Override
    public void onConnect(Node node) {
        if (node.equals(this.node())) {
            node.connect(this.oc_fs().node());
        }
    }

    @Override
    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            node.disconnect(this.oc_fs().node());
        } else if (node.equals(this.node())) {
            this.oc_fs().node().remove();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.hasCards && !this.inventoryInput.getStackInSlot(0).func_190926_b()) {
            this.hasCards = true;
            if (this.node != null) {
                this.node.sendToReachable("computer.signal", new Object[]{"cardInsert", "cardInsert"});
            }
        }
        if (this.hasCards && this.inventoryInput.getStackInSlot(0).func_190926_b()) {
            this.hasCards = false;
            if (this.node != null) {
                this.node.sendToReachable("computer.signal", new Object[]{"cardRemove", "cardRemove"});
            }
        }
    }

    @Callback
    public Object[] flash(Context context, Arguments args) {
        byte[] code = args.checkString(0).getBytes(Charset.forName("UTF-8"));
        String title = args.checkString(1);
        boolean locked = args.checkBoolean(2);
        ItemStack eepromItem = Items.get((String)"eeprom").createItemStack(1);
        if (!this.inventoryInput.getStackInSlot(0).func_190926_b()) {
            if (this.inventoryOutput.getStackInSlot(0).func_190926_b()) {
                System.out.println(this.inventoryInput.getStackInSlot(0).func_77973_b().func_77658_a());
                if (this.inventoryInput.getStackInSlot(0).func_77973_b().equals(Items.get((String)"eeprom").item())) {
                    boolean biggerEEPROM = Config.getConfig().getCategory("general").get("biggerEEPROM").getBoolean();
                    ItemStack outStack = eepromItem;
                    NBTTagCompound oc_data = new NBTTagCompound();
                    NBTTagCompound our_data = new NBTTagCompound();
                    int biggerSizeCode = Settings.get().eepromSize() * 2;
                    int biggerSizeData = Settings.get().eepromDataSize() * 2;
                    if (!biggerEEPROM && code.length > Settings.get().eepromSize()) {
                        code = Arrays.copyOfRange(code, 0, Settings.get().eepromSize());
                    } else if (biggerEEPROM && code.length > biggerSizeCode) {
                        code = Arrays.copyOfRange(code, 0, biggerSizeCode);
                    }
                    if (!biggerEEPROM && title.length() > Settings.get().eepromDataSize()) {
                        title = title.substring(0, Settings.get().eepromDataSize());
                    } else if (biggerEEPROM && title.length() > biggerSizeData) {
                        title = title.substring(0, biggerSizeData);
                    }
                    our_data.func_74773_a("oc:eeprom", code);
                    our_data.func_74778_a("oc:label", title);
                    our_data.func_74757_a("oc:readonly", locked);
                    oc_data.func_74782_a("oc:data", (NBTBase)our_data);
                    outStack.func_77982_d(oc_data);
                    this.inventoryOutput.setStackInSlot(0, outStack);
                    this.inventoryInput.getStackInSlot(0).func_190920_e(this.inventoryInput.getStackInSlot(0).func_190916_E() - 1);
                    return new Object[]{true};
                }
                return new Object[]{false, "Item is not EEPROM"};
            }
            return new Object[]{false, "No Empty Slots"};
        }
        return new Object[]{false, "No EEPROM in slot"};
    }

    @Callback(doc="function(string: data, string: displayName, boolean: locked, int: color):string; writes data to the card, (64 characters for RFID, or 128 for MagStripe), the rest is silently discarded, 2nd argument will change the displayed name of the card in your inventory. if you pass true to the 3rd argument you will not be able to erase, or rewrite data, the 3rd argument will set the color of the card, use OC's color api.", direct=true)
    public Object[] write(Context context, Arguments args) {
        ItemStack outStack;
        String data = args.checkString(0);
        if (data == null) {
            return new Object[]{false, "Data is Null"};
        }
        if (this.node.changeBuffer(-5.0) != 0.0) {
            return new Object[]{false, "Not enough power in OC Network."};
        }
        if (this.inventoryInput.getStackInSlot(0).func_190926_b()) {
            return new Object[]{false, "No card in slot"};
        }
        if (!this.inventoryOutput.getStackInSlot(0).func_190926_b()) {
            return new Object[]{false, "No Empty Slots"};
        }
        String title = args.optString(1, "");
        boolean locked = args.optBoolean(2, false);
        int colorIndex = Math.max(0, Math.min(args.optInteger(3, 0), 15));
        float[] dyeColor = EnumDyeColor.func_176764_b((int)colorIndex).func_193349_f();
        int color = new Color(dyeColor[0], dyeColor[1], dyeColor[2]).getRGB();
        if (this.inventoryInput.getStackInSlot(0).func_77973_b() instanceof ItemRFIDCard) {
            outStack = new ItemStack(ItemRFIDCard.DEFAULTSTACK.func_77973_b());
            if (data.length() > 64) {
                data = data.substring(0, 64);
            }
        } else if (this.inventoryInput.getStackInSlot(0).func_77973_b() instanceof ItemMagCard) {
            outStack = new ItemStack(ItemMagCard.DEFAULTSTACK.func_77973_b());
            if (data.length() > 128) {
                data = data.substring(0, 128);
            }
        } else {
            return new Object[]{false, "Wrong item in input slot"};
        }
        ItemCard.CardTag cardTag = new ItemCard.CardTag(this.inventoryInput.getStackInSlot(0));
        if (cardTag.locked) {
            return new Object[]{false, "card is locked"};
        }
        cardTag.color = color;
        cardTag.dataTag = data;
        cardTag.locked = locked;
        outStack.func_77982_d(cardTag.writeToNBT(new NBTTagCompound()));
        if (!title.isEmpty()) {
            outStack.func_151001_c(title);
        }
        this.inventoryInput.getStackInSlot(0).func_190920_e(this.inventoryInput.getStackInSlot(0).func_190916_E() - 1);
        this.inventoryOutput.setStackInSlot(0, outStack);
        return new Object[]{true, outStack.func_77978_p().func_74779_i("uuid")};
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventoryInput.deserializeNBT(data.func_74775_l("invIn"));
        this.inventoryOutput.deserializeNBT(data.func_74775_l("invOut"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74782_a("invIn", (NBTBase)this.inventoryInput.serializeNBT());
        data.func_74782_a("invOut", (NBTBase)this.inventoryOutput.serializeNBT());
        return data;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return facing != null && capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            if (facing.equals((Object)EnumFacing.DOWN)) {
                return (T)this.inventoryOutput;
            }
            return (T)this.inventoryInput;
        }
        return (T)super.getCapability(capability, facing);
    }
}

