/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import pcl.opensecurity.common.interfaces.IOwner;
import pcl.opensecurity.common.protection.IProtection;
import pcl.opensecurity.common.protection.Protection;
import pcl.opensecurity.common.tileentity.TileEntityOSCamoBase;
import pcl.opensecurity.common.tileentity.logic.DoorController;

public class TileEntityDoorController
extends TileEntityOSCamoBase
implements IOwner,
IProtection {
    static final String NAME = "os_doorcontroller";
    private UUID ownerUUID;

    public TileEntityDoorController() {
        super(NAME);
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    }

    public TileEntityDoorController(EnvironmentHost host) {
        super(NAME, host);
    }

    public void func_145829_t() {
        super.func_145829_t();
        Protection.addArea(this.func_145831_w(), new AxisAlignedBB(this.func_174877_v()), this.func_174877_v());
    }

    @Override
    public void func_145843_s() {
        Protection.removeArea(this.func_145831_w(), this.func_174877_v());
        super.func_145843_s();
    }

    @Override
    public boolean isProtected(Entity entityIn, Protection.UserAction action) {
        if (!action.equals((Object)Protection.UserAction.explode) && this.ownerUUID != null && entityIn.func_110124_au().equals(this.ownerUUID)) {
            return false;
        }
        if (entityIn != null && entityIn instanceof EntityPlayer) {
            ((EntityPlayer)entityIn).func_146105_b((ITextComponent)new TextComponentString("this block is protected"), false);
        }
        return true;
    }

    @Callback
    public Object[] isOpen(Context context, Arguments args) {
        return DoorController.isOpen(this.func_145831_w(), this.func_174877_v());
    }

    @Callback
    public Object[] toggle(Context context, Arguments args) {
        return DoorController.toggle(this.func_145831_w(), this.func_174877_v(), args.optString(0, ""));
    }

    @Callback
    public Object[] open(Context context, Arguments args) {
        return DoorController.setDoorStates(this.func_145831_w(), this.func_174877_v(), true, args.optString(0, ""));
    }

    @Callback
    public Object[] close(Context context, Arguments args) {
        return DoorController.setDoorStates(this.func_145831_w(), this.func_174877_v(), false, args.optString(0, ""));
    }

    @Callback
    public Object[] removePassword(Context context, Arguments args) {
        return DoorController.setDoorPasswords(this.func_145831_w(), this.func_174877_v(), args.checkString(0), "");
    }

    @Callback
    public Object[] setPassword(Context context, Arguments args) {
        return DoorController.setDoorPasswords(this.func_145831_w(), this.func_174877_v(), args.checkString(0), args.checkString(1));
    }

    @Override
    public void setOwner(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public UUID getOwner() {
        return this.ownerUUID;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ownerUUID = nbt.func_186855_b("owner") ? nbt.func_186857_a("owner") : (nbt.func_74764_b("owner") ? UUID.fromString(nbt.func_74779_i("owner")) : null);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.ownerUUID != null) {
            nbt.func_186854_a("owner", this.ownerUUID);
        }
        return nbt;
    }

    @Override
    public boolean playerCanChangeCamo(EntityPlayer player) {
        return player.func_184812_l_() || this.getOwner() == null || this.getOwner().equals(player.func_110124_au());
    }
}

