/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.common.SoundHandler;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;
import pcl.opensecurity.networking.PacketKeypadButton;

public class TileEntityKeypad
extends TileEntityOSBase {
    static final int MAX_LABEL_LENGTH = 3;
    static final int MAX_DISPLAY_LENGTH = 8;
    private boolean shouldBeep = true;
    public String data;
    public String eventName = "keypad";
    public String[] buttonLabels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"};
    public byte[] buttonColors = new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    public String displayText = "";
    public byte displayColor = (byte)7;
    public ButtonState[] buttonStates = new ButtonState[]{new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState(), new ButtonState()};

    public TileEntityKeypad() {
        super("os_keypad");
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    }

    static String trimString(String str, int len) {
        if (str == null || str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.eventName = nbt.func_74764_b("eventName") && !nbt.func_74779_i("eventName").isEmpty() ? nbt.func_74779_i("eventName") : "keypad";
        this.shouldBeep = nbt.func_74764_b("shouldBeep") ? nbt.func_74767_n("shouldBeep") : true;
        for (int i = 0; i < 12; ++i) {
            this.buttonLabels[i] = TileEntityKeypad.trimString(nbt.func_74779_i("btn:" + i), 3);
        }
        byte[] colors = nbt.func_74770_j("btn:colors");
        if (colors != null) {
            for (int i = 0; i < 12 && i < colors.length; ++i) {
                this.buttonColors[i] = colors[i];
            }
        }
        this.displayText = TileEntityKeypad.trimString(nbt.func_74779_i("fbText"), 8);
        this.displayColor = nbt.func_74771_c("fbColor");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("eventName", this.eventName);
        for (int i = 0; i < 12; ++i) {
            nbt.func_74778_a("btn:" + i, this.buttonLabels[i]);
        }
        nbt.func_74773_a("btn:colors", this.buttonColors);
        nbt.func_74778_a("fbText", this.displayText);
        nbt.func_74768_a("fbColor", (int)this.displayColor);
        nbt.func_74757_a("shouldBeep", this.shouldBeep);
        return nbt;
    }

    @Callback(doc="function(String:name):boolean; Sets the name of the event that gets sent when a key is pressed")
    public Object[] setEventName(Context context, Arguments args) {
        this.eventName = args.checkString(0);
        return new Object[]{true};
    }

    @Callback(doc="function(Boolean):boolean; Sets if the keys should beep when pressed")
    public Object[] setShouldBeep(Context context, Arguments args) {
        this.shouldBeep = args.checkBoolean(0);
        return new Object[]{true};
    }

    @Callback(doc="function(String:text[, color:number]):boolean; Sets the display string (0-8 chars), color (0-7) - 1 bit per channel")
    public Object[] setDisplay(Context context, Arguments args) {
        String text = args.checkString(0);
        this.displayColor = (byte)(args.optInteger(1, (int)this.displayColor) & 7);
        this.displayText = TileEntityKeypad.trimString(text, 8);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        this.func_189517_E_();
        this.func_70296_d();
        return new Object[]{true};
    }

    @Callback(doc="function(idx:number, text:string, color:number):boolean; Sets the key text (1-2 chars)")
    public Object[] setKey(Context context, Arguments args) {
        if (args.count() == 0) {
            throw new IllegalArgumentException("Not enough arguments");
        }
        if (args.isInteger(0)) {
            int idx = args.checkInteger(0);
            if (idx < 1 || idx > 12) {
                throw new IllegalArgumentException("Index " + idx + " is out of range");
            }
            this.buttonLabels[idx - 1] = TileEntityKeypad.trimString(args.checkString(1), 3);
            this.buttonColors[idx - 1] = (byte)(args.optInteger(2, (int)this.buttonColors[idx - 1]) & 7);
        } else if (args.isTable(0)) {
            Map labels = args.checkTable(0);
            Map colors = args.optTable(1, null);
            for (int i = 0; i < 12; ++i) {
                Integer id = new Integer(i + 1);
                Object val = labels.get(id);
                if (val != null && val instanceof String) {
                    this.buttonLabels[i] = TileEntityKeypad.trimString((String)val, 3);
                }
                if (colors == null || (val = colors.get(id)) == null || !(val instanceof Number)) continue;
                Number color = (Number)val;
                this.buttonColors[i] = (byte)(color.intValue() & 7);
            }
        } else {
            throw new IllegalArgumentException("First argument must be index or table");
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        this.func_189517_E_();
        this.func_70296_d();
        return new Object[]{true};
    }

    public IBlockState getFacing() {
        return this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
    }

    public float getAngle() {
        return this.getFacing().func_177230_c().func_176201_c(this.getFacing()) * 270;
    }

    public void pressedButton(EntityPlayer player, int buttonIndex) {
        if (this.shouldBeep) {
            this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundHandler.keypad_press, SoundCategory.BLOCKS, 1.5f, 1.0f);
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketKeypadButton packet = new PacketKeypadButton(1, this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), buttonIndex);
            EntityPlayerMP p = (EntityPlayerMP)player;
            OpenSecurity.network.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(p.field_71093_bK, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
            this.node.sendToReachable("computer.signal", new Object[]{this.eventName, buttonIndex + 1, buttonIndex >= 0 && buttonIndex < this.buttonLabels.length ? this.buttonLabels[buttonIndex] : ""});
        }
    }

    public static class ButtonState {
        public static int pressDelay = 5;
        public long pressedTime = 0L;

        public boolean isPressed(long time) {
            return time - this.pressedTime < (long)pressDelay;
        }

        public void press(long time) {
            this.pressedTime = time;
        }
    }
}

