/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.common.interfaces.ICamo;
import pcl.opensecurity.common.items.ItemNanoDNA;
import pcl.opensecurity.common.nanofog.EntityFilter;
import pcl.opensecurity.common.tileentity.TileEntityNanoFogTerminal;
import pcl.opensecurity.util.ItemUtils;

public class TileEntityNanoFog
extends TileEntity
implements ICamo {
    ICamo.MimicBlock mimicBlock = new ICamo.MimicBlock();
    public EntityFilter filterPass = new EntityFilter();
    public EntityFilter filterDamage = new EntityFilter();
    private boolean isSolid = false;
    private int knockback = 1;
    private int damage = 1;
    private BlockPos terminal;
    boolean isBuild = false;

    public TileEntityNanoFogTerminal getTerminal() {
        TileEntity te = this.func_145831_w().func_175625_s(this.terminal);
        return te != null ? (TileEntityNanoFogTerminal)te : null;
    }

    public void setTerminalLocation(BlockPos term) {
        this.terminal = term;
    }

    public int getKnockback() {
        return this.knockback;
    }

    public void setKnockback(int state) {
        this.knockback = state;
        this.markDirtyClient();
    }

    public boolean isBuild() {
        return this.isBuild;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int state) {
        this.damage = state;
        this.markDirtyClient();
    }

    public boolean isSolid() {
        return this.isSolid;
    }

    public void setSolid(boolean state) {
        this.isSolid = state;
        this.markDirtyClient();
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    @Override
    public IBlockState getCamoBlock() {
        return this.mimicBlock.get();
    }

    @Override
    @Deprecated
    public void setCamoBlock(Block block, int meta) {
        this.mimicBlock.set(block, meta);
        this.markDirtyClient();
    }

    @Override
    public boolean playerCanChangeCamo(EntityPlayer player) {
        return false;
    }

    public void notifyBuild() {
        this.isBuild = true;
        this.markDirtyClient();
    }

    public ItemStack notifyRemove() {
        ItemStack stack = ItemStack.field_190927_a;
        if (this.func_145831_w().field_72995_K) {
            this.isBuild = false;
            this.markDirtyClient();
        } else {
            stack = this.getFogMaterial();
            this.func_145831_w().func_175698_g(this.func_174877_v());
        }
        return stack;
    }

    private ItemStack getFogMaterial() {
        TileEntityNanoFogTerminal te = this.getTerminal();
        if (te != null && te.consumeBuildEnergy()) {
            return new ItemStack(ItemNanoDNA.DEFAULTSTACK.func_77973_b(), 1);
        }
        ItemUtils.dropItem(new ItemStack(ItemNanoDNA.DEFAULTSTACK.func_77973_b(), 1), this.func_145831_w(), this.func_174877_v(), false, 10);
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("camo", (NBTBase)this.mimicBlock.writeToNBT(new NBTTagCompound()));
        tagCompound.func_74768_a("knockback", this.knockback);
        tagCompound.func_74768_a("damageI", this.damage);
        tagCompound.func_74782_a("damage", (NBTBase)this.filterDamage.writeToNBT(new NBTTagCompound()));
        tagCompound.func_74782_a("pass", (NBTBase)this.filterPass.writeToNBT(new NBTTagCompound()));
        if (this.terminal != null) {
            tagCompound.func_74782_a("terminal", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.terminal));
        }
        tagCompound.func_74757_a("solid", this.isSolid);
        tagCompound.func_74757_a("build", this.isBuild);
        return tagCompound;
    }

    @Deprecated
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("camo")) {
            this.mimicBlock.readFromNBT(tagCompound.func_74775_l("camo"));
        } else {
            this.mimicBlock.readFromNBT(tagCompound);
        }
        this.isSolid = tagCompound.func_74767_n("solid");
        this.isBuild = tagCompound.func_74767_n("build");
        this.knockback = tagCompound.func_74762_e("knockback");
        this.damage = tagCompound.func_74762_e("damageI");
        this.filterDamage.readFromNBT(tagCompound.func_74775_l("damage"));
        this.filterPass.readFromNBT(tagCompound.func_74775_l("pass"));
        if (tagCompound.func_74764_b("terminal")) {
            this.terminal = NBTUtil.func_186861_c((NBTTagCompound)tagCompound.func_74775_l("terminal"));
        }
        if (tagCompound.func_74764_b("termX")) {
            this.terminal = new BlockPos(tagCompound.func_74762_e("termX"), tagCompound.func_74762_e("termY"), tagCompound.func_74762_e("termZ"));
        }
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

