/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.lang.ref.WeakReference;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import pcl.opensecurity.common.blocks.BlockOSBase;
import pcl.opensecurity.common.blocks.BlockRolldoor;
import pcl.opensecurity.common.blocks.BlockRolldoorElement;
import pcl.opensecurity.common.tileentity.TileEntityRolldoor;
import pcl.opensecurity.common.tileentity.TileEntityRolldoorController;
import pcl.opensecurity.util.AABBHelper;

public class TileEntityRolldoorElement
extends TileEntity {
    private static final AxisAlignedBB bbDefault = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    private AxisAlignedBB bb = bbDefault;
    private EnumFacing facing;
    private int position = -1;
    private WeakReference<TileEntityRolldoor> rolldoor;

    public AxisAlignedBB getBoundingBox() {
        this.getFacing();
        TileEntityRolldoor rolldoor = this.getRolldoor();
        if (rolldoor == null) {
            return BlockRolldoorElement.emptyBB;
        }
        TileEntityRolldoorController controller = rolldoor.getController();
        if (controller == null) {
            return BlockRolldoorElement.emptyBB;
        }
        double height = controller.getCurrentHeight() - (double)this.getPosition();
        if (height < 0.0) {
            return BlockRolldoorElement.emptyBB;
        }
        if (height < 1.0) {
            return this.bb.func_191500_a(new AxisAlignedBB(0.0, 1.0 - height, 0.0, 1.0, 1.0, 1.0));
        }
        return this.bb;
    }

    private TileEntityRolldoor getRolldoor() {
        if (this.rolldoor == null || this.rolldoor.get() == null || ((TileEntityRolldoor)this.rolldoor.get()).func_145837_r()) {
            TileEntity tile = this.func_145831_w().func_175625_s(this.origin());
            if (tile instanceof TileEntityRolldoor) {
                this.rolldoor = new WeakReference<TileEntityRolldoor>((TileEntityRolldoor)tile);
            } else {
                return null;
            }
        }
        return (TileEntityRolldoor)this.rolldoor.get();
    }

    private BlockPos origin() {
        return this.func_174877_v().func_177982_a(0, this.getPosition() + 1, 0);
    }

    private int getPosition() {
        IBlockState state;
        if (this.position == -1 && (state = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177228_b().containsKey((Object)BlockRolldoorElement.PROPERTYOFFSET)) {
            this.position = BlockRolldoorElement.getOffset(state);
        }
        return this.position;
    }

    public EnumFacing getFacing() {
        if (this.facing == null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.origin());
            if (state.func_177228_b().containsKey((Object)BlockOSBase.PROPERTYFACING)) {
                this.facing = BlockRolldoor.getFacing(state);
                this.bb = AABBHelper.rotateHorizontal(bbDefault, this.facing);
            } else {
                return EnumFacing.UP;
            }
        }
        return this.facing;
    }
}

