/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Logger;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import pcl.opensecurity.common.interfaces.IOwner;
import pcl.opensecurity.common.interfaces.IPasswordProtected;
import pcl.opensecurity.common.protection.IProtection;
import pcl.opensecurity.common.protection.Protection;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;

public class TileEntitySecureDoor
extends TileEntityOSBase
implements IProtection,
IPasswordProtected,
IOwner {
    private UUID ownerUUID;
    private String password = "";

    public TileEntitySecureDoor() {
        super("os_securedoor");
    }

    public void func_145829_t() {
        super.func_145829_t();
        Protection.addArea(this.func_145831_w(), new AxisAlignedBB(this.func_174877_v()), this.func_174877_v());
    }

    @Override
    public void func_145843_s() {
        Protection.removeArea(this.func_145831_w(), this.func_174877_v());
        super.func_145843_s();
    }

    @Override
    public boolean isProtected(Entity entityIn, Protection.UserAction action) {
        if (!action.equals((Object)Protection.UserAction.explode) && entityIn.func_110124_au().equals(this.ownerUUID)) {
            return false;
        }
        if (entityIn != null && entityIn instanceof EntityPlayer) {
            ((EntityPlayer)entityIn).func_146105_b((ITextComponent)new TextComponentString("this door is protected"), true);
        }
        return true;
    }

    private ArrayList<TileEntitySecureDoor> getDoorTiles() {
        ArrayList<TileEntitySecureDoor> doorTEs = new ArrayList<TileEntitySecureDoor>();
        doorTEs.add(this);
        int offset = ((BlockDoor.EnumDoorHalf)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.UPPER) ? -1 : 1;
        TileEntity teDoorOtherPart = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, offset, 0));
        if (teDoorOtherPart instanceof TileEntitySecureDoor) {
            doorTEs.add((TileEntitySecureDoor)teDoorOtherPart);
        } else {
            Logger.getLogger("opensecurity").warning("failed to get all door Tiles");
        }
        return doorTEs;
    }

    @Override
    public void setOwner(UUID uuid) {
        for (TileEntitySecureDoor door : this.getDoorTiles()) {
            door.ownerUUID = uuid;
        }
    }

    @Override
    public void setPassword(String pass) {
        for (TileEntitySecureDoor door : this.getDoorTiles()) {
            door.password = pass;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ownerUUID = tag.func_186855_b("owner") ? tag.func_186857_a("owner") : (tag.func_74764_b("owner") ? UUID.fromString(tag.func_74779_i("owner")) : null);
        this.password = tag.func_74779_i("password");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.ownerUUID != null) {
            tag.func_186854_a("owner", this.ownerUUID);
        }
        tag.func_74778_a("password", this.password);
        return tag;
    }

    @Override
    public UUID getOwner() {
        return this.ownerUUID;
    }

    @Override
    public String getPass() {
        return this.password;
    }
}

