/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity.logic;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import pcl.opensecurity.common.tileentity.TileEntityRolldoor;
import pcl.opensecurity.common.tileentity.TileEntityRolldoorController;

public class RolldoorHelper {
    public static HashMap<BlockPos, TileEntityRolldoor> getDoors(TileEntityRolldoorController controller) {
        TileEntity tile;
        HashMap<BlockPos, TileEntityRolldoor> doors = new HashMap<BlockPos, TileEntityRolldoor>();
        TileEntityRolldoor firstElement = RolldoorHelper.getAdjacentRolldoor(controller);
        if (firstElement == null) {
            return doors;
        }
        doors.put(firstElement.func_174877_v(), firstElement);
        Vec3i searchVector = firstElement.getFacing().func_176746_e().func_176730_m();
        BlockPos searchPos = firstElement.func_174877_v();
        int i = 0;
        while (doors.size() < 15) {
            searchPos = searchPos.func_177971_a(searchVector);
            tile = firstElement.func_145831_w().func_175625_s(searchPos);
            if (!(tile instanceof TileEntityRolldoor)) break;
            doors.put(searchPos, (TileEntityRolldoor)tile);
            ++i;
        }
        searchPos = firstElement.func_174877_v();
        i = 0;
        while (doors.size() < 15) {
            searchPos = searchPos.func_177973_b(searchVector);
            tile = firstElement.func_145831_w().func_175625_s(searchPos);
            if (!(tile instanceof TileEntityRolldoor)) break;
            doors.put(searchPos, (TileEntityRolldoor)tile);
            --i;
        }
        return doors;
    }

    public static HashMap<EnumFacing, TileEntityRolldoor> getAdjacentRolldoors(World world, BlockPos pos) {
        HashMap<EnumFacing, TileEntityRolldoor> doors = new HashMap<EnumFacing, TileEntityRolldoor>();
        for (Map.Entry<EnumFacing, TileEntity> entry : RolldoorHelper.getAdjacentTileEntities(world, pos).entrySet()) {
            if (!(entry.getValue() instanceof TileEntityRolldoor)) continue;
            doors.put(entry.getKey(), (TileEntityRolldoor)entry.getValue());
        }
        return doors;
    }

    public static TileEntityRolldoor getAdjacentRolldoor(TileEntity tile) {
        for (Map.Entry<EnumFacing, TileEntity> entry : RolldoorHelper.getAdjacentTileEntities(tile.func_145831_w(), tile.func_174877_v()).entrySet()) {
            if (!(entry.getValue() instanceof TileEntityRolldoor)) continue;
            return (TileEntityRolldoor)entry.getValue();
        }
        return null;
    }

    public static HashMap<EnumFacing, TileEntity> getAdjacentTileEntities(World world, BlockPos pos) {
        HashMap<EnumFacing, TileEntity> tiles = new HashMap<EnumFacing, TileEntity>();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity tile = world.func_175625_s(pos.func_177971_a(direction.func_176730_m()));
            if (tile == null) continue;
            tiles.put(direction, tile);
        }
        return tiles;
    }

    public static TileEntityRolldoorController getAdjacentController(World world, BlockPos pos) {
        for (Map.Entry<EnumFacing, TileEntity> entry : RolldoorHelper.getAdjacentTileEntities(world, pos).entrySet()) {
            if (!(entry.getValue() instanceof TileEntityRolldoorController)) continue;
            return (TileEntityRolldoorController)entry.getValue();
        }
        return null;
    }
}

