/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces.tileentity;

import cubex2.mods.morefurnaces.Config;
import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.MoreFurnaces;
import cubex2.mods.morefurnaces.inventory.ItemHandlerFurnace;
import cubex2.mods.morefurnaces.inventory.ItemHandlerMoveStacks;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TileEntityIronFurnace
extends TileEntity
implements ITickable {
    public int[] furnaceCookTime;
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    private final FurnaceType type;
    private byte facing;
    private boolean isActive = false;
    private int ticksSinceSync = 0;
    private boolean updateLight = false;
    private final ItemHandlerFurnace itemHandler;

    public TileEntityIronFurnace() {
        this(FurnaceType.IRON);
    }

    protected TileEntityIronFurnace(FurnaceType type) {
        this.type = type;
        this.furnaceCookTime = new int[type.parallelSmelting];
        Arrays.fill(this.furnaceCookTime, 0);
        this.itemHandler = new ItemHandlerFurnace(this);
    }

    public ItemHandlerFurnace getItemHandler() {
        return this.itemHandler;
    }

    public void copyStateFrom(TileEntityIronFurnace furnace) {
        int minParallel = Math.min(this.type.parallelSmelting, furnace.type.parallelSmelting);
        System.arraycopy(furnace.furnaceCookTime, 0, this.furnaceCookTime, 0, minParallel);
        this.furnaceBurnTime = furnace.furnaceBurnTime;
        this.currentItemBurnTime = furnace.currentItemBurnTime;
        this.facing = furnace.facing;
        this.isActive = furnace.isActive;
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)MoreFurnaces.blockFurnaces, 2, (int)((byte)(this.isActive ? 1 : 0)));
    }

    public void copyStateFrom(TileEntityFurnace furnace, byte facing) {
        this.furnaceCookTime[0] = furnace.func_174887_a_(2);
        this.furnaceBurnTime = furnace.func_174887_a_(0);
        this.currentItemBurnTime = furnace.func_174887_a_(1);
        this.setFacing(facing);
        this.isActive = furnace.func_145950_i();
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)MoreFurnaces.blockFurnaces, 2, (int)((byte)(this.isActive ? 1 : 0)));
    }

    public int getSpeed() {
        return Config.getFurnaceSpeed(this.type);
    }

    public float getConsumptionRate() {
        return Config.getConsumptionRate(this.type);
    }

    public byte getFacing() {
        return this.facing;
    }

    public void setFacing(byte value) {
        this.facing = value;
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)MoreFurnaces.blockFurnaces, 1, this.facing & 0xFF);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public FurnaceType getType() {
        return this.type;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.itemHandler.deserializeNBT(nbtTagCompound);
        this.furnaceBurnTime = nbtTagCompound.func_74765_d("BurnTime");
        this.currentItemBurnTime = this.getBurnTime(this.itemHandler.getStackInSlot(this.type.getFirstFuelSlot()));
        NBTTagList cookList = nbtTagCompound.func_150295_c("CookTimes", 10);
        this.furnaceCookTime = new int[this.type.parallelSmelting];
        for (int i = 0; i < cookList.func_74745_c(); ++i) {
            int cookTime;
            NBTTagCompound tag = cookList.func_150305_b(i);
            byte cookId = tag.func_74771_c("Id");
            this.furnaceCookTime[cookId] = cookTime = tag.func_74762_e("Time");
        }
        this.facing = nbtTagCompound.func_74771_c("facing");
        this.isActive = nbtTagCompound.func_74767_n("isActive");
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        NBTTagList cookList = new NBTTagList();
        for (int i = 0; i < this.furnaceCookTime.length; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Id", (byte)i);
            tag.func_74768_a("Time", this.furnaceCookTime[i]);
            cookList.func_74742_a((NBTBase)tag);
        }
        nbtTagCompound.func_74782_a("CookTimes", (NBTBase)cookList);
        nbtTagCompound.func_74774_a("facing", this.facing);
        nbtTagCompound.func_74757_a("isActive", this.isActive);
        NBTTagCompound nbt = this.itemHandler.serializeNBT();
        nbtTagCompound.func_74782_a("Items", nbt.func_74781_a("Items"));
        nbtTagCompound.func_74768_a("Size", nbt.func_74762_e("Size"));
        return nbtTagCompound;
    }

    public float getCookProgress(int id) {
        return (float)this.furnaceCookTime[id] / (float)this.getSpeed();
    }

    @SideOnly(value=Side.CLIENT)
    public float getBurnTimeRemaining() {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.getSpeed();
        }
        return (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_73660_a() {
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)MoreFurnaces.blockFurnaces, 1, this.facing & 0xFF);
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)MoreFurnaces.blockFurnaces, 2, (int)((byte)(this.isActive ? 1 : 0)));
        }
        boolean wasBurning = this.isBurning();
        boolean dirty = false;
        if (this.isBurning() && this.type.fuelSlots > 0) {
            --this.furnaceBurnTime;
        }
        if (this.updateLight && this.field_145850_b != null) {
            this.field_145850_b.func_180500_c(EnumSkyBlock.SKY, this.field_174879_c);
            this.updateLight = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.moveStacks();
            if (this.furnaceBurnTime == 0 && this.canSmelt() && this.type.fuelSlots > 0) {
                dirty |= this.consumeFuel();
            }
            for (int i = 0; i < this.type.parallelSmelting; ++i) {
                dirty |= this.progressCooking(i);
            }
            dirty |= this.updateBlockActiveState(wasBurning);
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        for (int i = 0; i < this.type.parallelSmelting; ++i) {
            if (!this.canSmelt(i)) continue;
            return true;
        }
        return false;
    }

    private boolean updateBlockActiveState(boolean wasBurning) {
        boolean dirty = false;
        if (wasBurning != this.isBurning() && this.type.fuelSlots > 0) {
            dirty = true;
            this.isActive = this.isBurning();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        } else if (this.type.fuelSlots == 0 && this.isActive != this.isBurning()) {
            this.furnaceBurnTime = 3600;
            this.currentItemBurnTime = 3600;
            dirty = true;
            this.isActive = this.isBurning();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        return dirty;
    }

    private boolean progressCooking(int id) {
        if (this.isBurning() && this.canSmelt(id)) {
            int n = id;
            this.furnaceCookTime[n] = this.furnaceCookTime[n] + 1;
            if (this.furnaceCookTime[id] >= this.getSpeed()) {
                this.furnaceCookTime[id] = 0;
                this.smeltItem(id);
                return true;
            }
        } else {
            this.furnaceCookTime[id] = 0;
        }
        return false;
    }

    private boolean consumeFuel() {
        int slot = this.type.getFirstFuelSlot();
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.currentItemBurnTime = this.furnaceBurnTime = this.getBurnTime(stack);
        if (this.isBurning()) {
            if (!stack.func_190926_b()) {
                Item item = stack.func_77973_b();
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    this.itemHandler.setStackInSlot(slot, item.getContainerItem(stack));
                }
            }
            return true;
        }
        return false;
    }

    private int getBurnTime(ItemStack stack) {
        return (int)((float)TileEntityFurnace.func_145952_a((ItemStack)stack) / this.getConsumptionRate());
    }

    private void moveStacks() {
        this.itemHandler.moveInputStacks();
        for (int id = 0; id < this.type.parallelSmelting; ++id) {
            ItemHandlerMoveStacks outputHandler = this.itemHandler.getOutputHandlers()[id];
            ItemStack result = ItemStack.field_190927_a;
            ItemStack input = this.itemHandler.getStackInSlot(this.type.getFirstInputSlot(id));
            if (!input.func_190926_b()) {
                result = FurnaceRecipes.func_77602_a().func_151395_a(input);
            }
            if (result.func_190926_b()) continue;
            this.itemHandler.slotChecksEnabled = false;
            ItemStack remainder = outputHandler.insertItem(0, result, true);
            this.itemHandler.slotChecksEnabled = true;
            if (remainder.func_190926_b()) continue;
            outputHandler.moveStacks();
        }
        this.itemHandler.moveFuelStacks();
    }

    public boolean func_145842_c(int i, int j) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return true;
        }
        if (i == 1) {
            this.facing = (byte)j;
            return true;
        }
        if (i == 2) {
            boolean bl = this.isActive = j == 1;
            if (this.field_145850_b != null) {
                this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
            } else {
                this.updateLight = true;
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    private boolean canSmelt(int id) {
        int inputIndex = this.type.getFirstInputSlot(id);
        int outputIndex = this.type.getFirstOutputSlot(id);
        ItemStack input = this.itemHandler.getStackInSlot(inputIndex);
        ItemStack output = this.itemHandler.getStackInSlot(outputIndex);
        if (input.func_190926_b()) {
            return false;
        }
        ItemStack res = FurnaceRecipes.func_77602_a().func_151395_a(input);
        if (res.func_190926_b()) {
            return false;
        }
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(res)) {
            return false;
        }
        int result = output.func_190916_E() + res.func_190916_E();
        return result <= this.itemHandler.getSlotLimit(outputIndex) && result <= res.func_77976_d();
    }

    private void smeltItem(int id) {
        if (this.canSmelt(id)) {
            int inputIndex = this.type.getFirstInputSlot(id);
            int outputIndex = this.type.getFirstOutputSlot(id);
            ItemStack input = this.itemHandler.getStackInSlot(inputIndex);
            ItemStack output = this.itemHandler.getStackInSlot(outputIndex);
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(input);
            if (output.func_190926_b()) {
                this.itemHandler.setStackInSlot(outputIndex, result.func_77946_l());
            } else if (output.func_77969_a(result)) {
                output.func_190917_f(result.func_190916_E());
            }
            if (input.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && input.func_77960_j() == 1) {
                this.fillBucketInFuelSlots();
            }
            input.func_190918_g(1);
            if (input.func_190926_b()) {
                this.itemHandler.setStackInSlot(inputIndex, ItemStack.field_190927_a);
            }
        }
    }

    private void fillBucketInFuelSlots() {
        int startIndex = this.type.getFirstFuelSlot();
        for (int i = 0; i < this.type.getNumFuelSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(startIndex + i);
            if (stack.func_190926_b() || stack.func_77973_b() != Items.field_151133_ar) continue;
            this.itemHandler.setStackInSlot(startIndex + i, new ItemStack(Items.field_151131_as));
            break;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)((Object)this.itemHandler);
            }
            return (T)this.itemHandler.getHandlerForSide(facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

