/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.ICardGui;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.containers.ContainerAdvancedInfoPanel;
import com.zuxelus.energycontrol.gui.GuiInfoPanel;
import com.zuxelus.energycontrol.gui.GuiPanelSlope;
import com.zuxelus.energycontrol.gui.GuiScreenColor;
import com.zuxelus.energycontrol.gui.IconButton;
import com.zuxelus.energycontrol.gui.controls.GuiInfoPanelCheckBox;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.items.cards.ItemCardSettingsReader;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityAdvancedInfoPanel;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiAdvancedInfoPanel
extends GuiInfoPanel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol:textures/gui/gui_advanced_info_panel.png");
    private static final int ID_LABELS = 1;
    private static final int ID_SLOPE = 2;
    private static final int ID_COLORS = 3;
    private static final int ID_POWER = 4;
    private static final int ID_SETTINGS = 5;
    private TileEntityAdvancedInfoPanel panel;
    private boolean initialized;

    public GuiAdvancedInfoPanel(ContainerAdvancedInfoPanel container) {
        super(container);
        this.field_147000_g = 223;
        this.panel = (TileEntityAdvancedInfoPanel)container.te;
        this.name = I18n.func_135052_a((String)"tile.info_panel_advanced.name", (Object[])new Object[0]);
        this.initialized = false;
    }

    @Override
    protected void initControls() {
        ItemStack stack = (ItemStack)this.panel.getCards().get((int)this.activeTab);
        if (stack.func_190926_b() && stack.equals(this.prevCard) && this.initialized) {
            return;
        }
        this.initialized = true;
        this.field_146292_n.clear();
        this.prevCard = stack;
        this.func_189646_b(new IconButton(1, this.field_147003_i + 83, this.field_147009_r + 42, 16, 16, TEXTURE, 176, this.getIconLabelsTopOffset(this.panel.getShowLabels())));
        this.func_189646_b(new IconButton(2, this.field_147003_i + 83 + 17, this.field_147009_r + 42, 16, 16, TEXTURE, 192, 15));
        this.func_189646_b(new IconButton(3, this.field_147003_i + 83 + 34, this.field_147009_r + 42, 16, 16, TEXTURE, 192, 31));
        this.func_189646_b(new IconButton(4, this.field_147003_i + 83 + 51, this.field_147009_r + 42, 16, 16, TEXTURE, 176, this.getIconPowerTopOffset(this.panel.getPowerMode())));
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCardMain) {
            int slot = this.panel.getCardSlot(stack);
            if (stack.func_77952_i() == 18) {
                this.func_189646_b(new IconButton(5, this.field_147003_i + 83 + 68, this.field_147009_r + 42, 16, 16, TEXTURE, 192, 47));
            }
            List<PanelSetting> settingsList = ItemCardMain.getSettingsList(stack);
            int hy = this.field_146289_q.field_78288_b + 1;
            int y = 1;
            int x = this.field_147003_i + 24;
            if (settingsList != null) {
                for (PanelSetting panelSetting : settingsList) {
                    this.func_189646_b(new GuiInfoPanelCheckBox(0, x + 4, this.field_147009_r + 51 + hy * y, panelSetting, this.panel, slot, this.field_146289_q));
                    ++y;
                }
            }
            if (!this.modified) {
                this.textboxTitle = new GuiTextField(0, this.field_146289_q, 7, 16, 162, 18);
                this.textboxTitle.func_146195_b(true);
                this.textboxTitle.func_146180_a(new ItemCardReader(stack).getTitle());
            }
        } else {
            this.modified = false;
            this.textboxTitle = null;
        }
    }

    private int getIconLabelsTopOffset(boolean checked) {
        return checked ? 15 : 31;
    }

    private int getIconPowerTopOffset(byte mode) {
        switch (mode) {
            case 0: {
                return 47;
            }
            case 1: {
                return 63;
            }
            case 2: {
                return 79;
            }
            case 3: {
                return 95;
            }
        }
        return 47;
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int left = (this.field_146294_l - this.field_146999_f) / 2;
        int top = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(left + 24, top + 62 + this.activeTab * 14, 182, 0, 1, 15);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseX >= this.field_147003_i + 7 && mouseX <= this.field_147003_i + 24 && mouseY >= this.field_147009_r + 62 && mouseY <= this.field_147009_r + 104) {
            byte newTab = (byte)((mouseY - this.field_147009_r - 62) / 14);
            if (newTab > 2) {
                newTab = 2;
            }
            if (newTab != this.activeTab && this.modified) {
                this.updateTitle();
                this.modified = false;
            }
            this.activeTab = newTab;
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 3: {
                GuiScreenColor colorGui = new GuiScreenColor(this, this.panel);
                this.field_146297_k.func_147108_a((GuiScreen)colorGui);
                this.initialized = false;
                break;
            }
            case 5: {
                ItemStack card = (ItemStack)this.panel.getCards().get((int)this.activeTab);
                if (card.func_190926_b() || !(card.func_77973_b() instanceof ItemCardMain) || card.func_77952_i() != 18) break;
                ItemCardReader reader = new ItemCardReader(card);
                ICardGui guiObject = ItemCardMain.getSettingsScreen(reader);
                if (!(guiObject instanceof GuiScreen)) {
                    EnergyControl.logger.warn("Invalid card, getSettingsScreen method should return GuiScreen object");
                    return;
                }
                GuiScreen gui = (GuiScreen)guiObject;
                ItemCardSettingsReader wrapper = new ItemCardSettingsReader(card, this.panel, this, this.activeTab);
                ((ICardGui)gui).setCardSettingsHelper(wrapper);
                this.field_146297_k.func_147108_a(gui);
                break;
            }
            case 1: {
                boolean checked;
                boolean bl = checked = !this.panel.getShowLabels();
                if (button instanceof IconButton) {
                    IconButton iButton = (IconButton)button;
                    iButton.textureTop = this.getIconLabelsTopOffset(checked);
                }
                NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), 3, checked ? 1 : 0);
                this.panel.setShowLabels(checked);
                break;
            }
            case 4: {
                byte mode = this.panel.getNextPowerMode();
                if (button instanceof IconButton) {
                    IconButton iButton = (IconButton)button;
                    iButton.textureTop = this.getIconPowerTopOffset(mode);
                }
                NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), 11, mode);
                this.panel.powerMode = mode;
                break;
            }
            case 2: {
                GuiPanelSlope slopeGui = new GuiPanelSlope(this, this.panel);
                this.field_146297_k.func_147108_a((GuiScreen)slopeGui);
                this.initialized = false;
            }
        }
    }
}

