/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui.controls;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityHowlerAlarm;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiHowlerAlarmSlider
extends GuiButton {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("energycontrol:textures/gui/gui_howler_alarm.png");
    public float sliderValue;
    public boolean dragging;
    private int minValue = 0;
    private int maxValue = 256;
    private int step = 8;
    private TileEntityHowlerAlarm alarm;

    public GuiHowlerAlarmSlider(int id, int x, int y, TileEntityHowlerAlarm alarm) {
        super(id, x, y, 107, 16, "");
        this.alarm = alarm;
        this.dragging = false;
        if (alarm.func_145831_w().field_72995_K) {
            this.maxValue = EnergyControl.config.maxAlarmRange;
        }
        int currentRange = alarm.getRange();
        if (alarm.func_145831_w().field_72995_K && currentRange > this.maxValue) {
            currentRange = this.maxValue;
        }
        this.sliderValue = ((float)currentRange - (float)this.minValue) / (float)(this.maxValue - this.minValue);
        this.field_146126_j = I18n.func_135052_a((String)"msg.ec.HowlerAlarmSoundRange", (Object[])new Object[]{this.getNormalizedValue()});
    }

    private int getNormalizedValue() {
        return (this.minValue + (int)Math.floor((float)(this.maxValue - this.minValue) * this.sliderValue)) / this.step * this.step;
    }

    private void setSliderPos(int targetX) {
        this.sliderValue = (float)(targetX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
        if (this.sliderValue < 0.0f) {
            this.sliderValue = 0.0f;
        }
        if (this.sliderValue > 1.0f) {
            this.sliderValue = 1.0f;
        }
        int newValue = this.getNormalizedValue();
        if (this.alarm.func_145831_w().field_72995_K && this.alarm.getRange() != newValue) {
            NetworkHelper.updateSeverTileEntity(this.alarm.func_174877_v(), 2, newValue);
            this.alarm.setRange(newValue);
        }
        this.field_146126_j = I18n.func_135052_a((String)"msg.ec.HowlerAlarmSoundRange", (Object[])new Object[]{newValue});
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_146125_m) {
            return;
        }
        mc.func_110434_K().func_110577_a(TEXTURE_LOCATION);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.dragging) {
            this.setSliderPos(mouseX);
        }
        this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 131, 0, 8, 16);
        mc.field_71466_p.func_78276_b(this.field_146126_j, this.field_146128_h, this.field_146129_i - 12, 0x404040);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (!super.func_146116_c(mc, mouseX, mouseY)) {
            return false;
        }
        this.setSliderPos(mouseX);
        this.dragging = true;
        return true;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
        this.dragging = false;
    }
}

