/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.brandon3055.draconicevolution.api.IExtendedRFStorage;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyInfuser;
import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardEnergyDraconic
extends ItemCardBase {
    public ItemCardEnergyDraconic() {
        super(20, "card_energy_draconic");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        if (te == null) {
            return CardState.NO_TARGET;
        }
        if (te instanceof IExtendedRFStorage) {
            reader.setDouble("storage", Double.valueOf(((IExtendedRFStorage)te).getExtendedCapacity()));
            reader.setDouble("energy", Double.valueOf(((IExtendedRFStorage)te).getExtendedCapacity()));
            return CardState.OK;
        }
        if (te instanceof TileEnergyInfuser) {
            reader.setDouble("storage", Double.valueOf(((TileEnergyInfuser)te).energyStorage.getMaxEnergyStored()));
            reader.setDouble("energy", Double.valueOf(((TileEnergyInfuser)te).energyStorage.getEnergyStored()));
            return CardState.OK;
        }
        if (te instanceof TileCrystalDirectIO) {
            reader.setDouble("storage", Double.valueOf(((TileCrystalDirectIO)te).getMaxEnergyStored()));
            reader.setDouble("energy", Double.valueOf(((TileCrystalDirectIO)te).getEnergyStored()));
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardReader reader, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        double energy = reader.getDouble("energy");
        double storage = reader.getDouble("storage");
        if ((displaySettings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergyRF", energy, showLabels));
        }
        if ((displaySettings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFreeRF", storage - energy, showLabels));
        }
        if ((displaySettings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacityRF", storage, showLabels));
        }
        if ((displaySettings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPercentage", storage == 0.0 ? 100.0 : energy / storage * 100.0, showLabels));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(4);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelFree", (Object[])new Object[0]), 2, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelCapacity", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelPercentage", (Object[])new Object[0]), 8, this.damage));
        return result;
    }

    @Override
    public int getKitFromCard() {
        return 12;
    }
}

