/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.LiquidCardHelper;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardLiquid
extends ItemCardBase {
    public ItemCardLiquid() {
        super(2, "card_liquid");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        IFluidTank storage = LiquidCardHelper.getStorageAt(world, target);
        if (storage == null) {
            return CardState.NO_TARGET;
        }
        int amount = 0;
        String name = "";
        if (storage.getFluid() != null && (amount = storage.getFluid().amount) > 0) {
            name = FluidRegistry.getFluidName((FluidStack)storage.getFluid());
        }
        reader.setInt("capacity", storage.getCapacity());
        reader.setInt("amount", amount);
        reader.setString("name", name);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardReader reader, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        int capacity = reader.getInt("capacity");
        int amount = reader.getInt("amount");
        if ((displaySettings & 1) > 0) {
            String name = reader.getString("name");
            if (name == "") {
                name = I18n.func_135052_a((String)"msg.ec.None", (Object[])new Object[0]);
            }
            result.add(new PanelString("msg.ec.InfoPanelName", name, showLabels));
        }
        if ((displaySettings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelAmountmB", amount, showLabels));
        }
        if ((displaySettings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFreemB", capacity - amount, showLabels));
        }
        if ((displaySettings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacitymB", capacity, showLabels));
        }
        if ((displaySettings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPercentage", capacity == 0 ? 100.0 : (double)(amount * 100 / capacity), showLabels));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidName", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidAmount", (Object[])new Object[0]), 2, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidFree", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidCapacity", (Object[])new Object[0]), 8, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidPercentage", (Object[])new Object[0]), 16, this.damage));
        return result;
    }

    @Override
    public int getKitFromCard() {
        return 2;
    }
}

