/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.network;

import com.zuxelus.energycontrol.network.ChannelHandler;
import com.zuxelus.energycontrol.network.PacketCard;
import com.zuxelus.energycontrol.network.PacketChat;
import com.zuxelus.energycontrol.network.PacketClientSensor;
import com.zuxelus.energycontrol.network.PacketTileEntity;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class NetworkHelper {
    public static final int FIELD_DOUBLE = 1;
    public static final int FIELD_INT = 2;
    public static final int FIELD_STRING = 3;
    public static final int FIELD_BOOLEAN = 4;
    public static final int FIELD_TAG = 5;
    public static final int FIELD_NULL = 6;
    public static final int FIELD_LONG = 7;

    private static void sendPacketToAllAround(BlockPos pos, int dist, World world, IMessage packet) {
        List players = world.field_73010_i;
        for (EntityPlayer player : players) {
            double dz;
            double dy;
            double dx;
            if (!(player instanceof EntityPlayerMP) || !((dx = (double)pos.func_177958_n() - player.field_70165_t) * dx + (dy = (double)pos.func_177956_o() - player.field_70163_u) * dy + (dz = (double)pos.func_177952_p() - player.field_70161_v) * dz < (double)(dist * dist))) continue;
            ChannelHandler.network.sendTo(packet, (EntityPlayerMP)player);
        }
    }

    public static void setSensorCardField(TileEntity panel, int slot, Map<String, Object> fields) {
        if (fields == null || fields.isEmpty() || panel == null || !(panel instanceof TileEntityInfoPanel) || slot == -1) {
            return;
        }
        if (panel.func_145831_w().field_72995_K) {
            return;
        }
        NetworkHelper.sendPacketToAllAround(panel.func_174877_v(), 64, panel.func_145831_w(), new PacketCard(panel.func_174877_v(), slot, fields));
    }

    public static void setCardSettings(ItemStack card, TileEntityInfoPanel panel, Map<String, Object> fields, byte slot) {
        if (card.func_190926_b() || fields == null || fields.isEmpty() || panel == null) {
            return;
        }
        if (!panel.func_145831_w().field_72995_K) {
            return;
        }
        ChannelHandler.network.sendToServer((IMessage)new PacketClientSensor(panel.func_174877_v(), slot, card.func_77973_b().getClass().getName(), fields));
    }

    public static void chatMessage(EntityPlayer player, String message) {
        NetworkHelper.chatMessage(player, message, 0, 0);
    }

    public static void chatMessage(EntityPlayer player, String message, int type, int value) {
        if (player instanceof EntityPlayerMP) {
            ChannelHandler.network.sendTo((IMessage)new PacketChat(message, type, value), (EntityPlayerMP)player);
        }
    }

    public static void updateClientTileEntity(IContainerListener crafter, BlockPos pos, int type, int value) {
        if (!(crafter instanceof EntityPlayerMP)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", type);
        tag.func_74768_a("value", value);
        ChannelHandler.network.sendTo((IMessage)new PacketTileEntity(pos, tag), (EntityPlayerMP)crafter);
    }

    public static void updateClientTileEntity(IContainerListener crafter, BlockPos pos, int type, double value) {
        if (!(crafter instanceof EntityPlayerMP)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", type);
        tag.func_74780_a("value", value);
        ChannelHandler.network.sendTo((IMessage)new PacketTileEntity(pos, tag), (EntityPlayerMP)crafter);
    }

    public static void updateClientTileEntity(IContainerListener crafter, BlockPos pos, NBTTagCompound tag) {
        if (!(crafter instanceof EntityPlayerMP)) {
            return;
        }
        ChannelHandler.network.sendTo((IMessage)new PacketTileEntity(pos, tag), (EntityPlayerMP)crafter);
    }

    public static void updateSeverTileEntity(BlockPos pos, int type, String string) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", type);
        tag.func_74778_a("string", string);
        ChannelHandler.network.sendToServer((IMessage)new PacketTileEntity(pos, tag));
    }

    public static void updateSeverTileEntity(BlockPos pos, int type, int value) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", type);
        tag.func_74768_a("value", value);
        ChannelHandler.network.sendToServer((IMessage)new PacketTileEntity(pos, tag));
    }

    public static void updateSeverTileEntity(BlockPos pos, NBTTagCompound tag) {
        ChannelHandler.network.sendToServer((IMessage)new PacketTileEntity(pos, tag));
    }
}

