/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.renderers;

import com.zuxelus.energycontrol.renderers.RotationOffset;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CubeRenderer {
    private boolean compiled;
    private int displayList;
    private CubeBox cube;

    public CubeRenderer(int faceOffsetX, int faceOffsetY) {
        this(0.0f, 0.0f, 0.0f, 32, 32, 32, 128.0f, 192.0f, faceOffsetX, faceOffsetY);
    }

    public CubeRenderer(float offX, float offY, float offZ, int width, int height, int depth, float textureWidth, float textureHeight, int faceOffsetX, int faceOffsetY) {
        this(offX, offY, offZ, width, height, depth, textureWidth, textureHeight, faceOffsetX, faceOffsetY, new RotationOffset());
    }

    public CubeRenderer(int faceOffsetX, int faceOffsetY, RotationOffset offset) {
        this(0.0f, 0.0f, 0.0f, 32, 32, 32, 128.0f, 192.0f, faceOffsetX, faceOffsetY, offset);
    }

    public CubeRenderer(float x, float y, float z, int dx, int dy, int dz, float textureWidth, float textureHeight, int faceTexU, int faceTexV, RotationOffset offset) {
        this.cube = new CubeBox(x, y, z, dx, dy, dz, textureWidth, textureHeight, faceTexU, faceTexV, offset.leftTop, offset.leftBottom, offset.rightTop, offset.rightBottom);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float scale) {
        if (!this.compiled) {
            this.compileDisplayList(scale);
        }
        GlStateManager.func_179148_o((int)this.displayList);
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        this.cube.render(bufferbuilder, scale);
        GlStateManager.func_187415_K();
        this.compiled = true;
    }

    private class CubeBox {
        private final PositionTextureVertex[] vertexPositions = new PositionTextureVertex[8];
        private final TexturedQuad[] quadList = new TexturedQuad[6];

        public CubeBox(float x, float y, float z, int dx, int dy, int dz, float textureWidth, float textureHeight, int faceTexU, int faceTexV, float leftTop, float leftBottom, float rightTop, float rightBottom) {
            float f = x + (float)dx;
            float f1 = y + (float)dy;
            float f2 = z + (float)dz;
            PositionTextureVertex v7 = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
            PositionTextureVertex v = new PositionTextureVertex(f, y, z, 0.0f, 8.0f);
            PositionTextureVertex v1 = new PositionTextureVertex(f, f1 - leftTop, z, 8.0f, 8.0f);
            PositionTextureVertex v2 = new PositionTextureVertex(x, f1 - leftBottom, z, 8.0f, 0.0f);
            PositionTextureVertex v3 = new PositionTextureVertex(x, y, f2, 0.0f, 0.0f);
            PositionTextureVertex v4 = new PositionTextureVertex(f, y, f2, 0.0f, 8.0f);
            PositionTextureVertex v5 = new PositionTextureVertex(f, f1 - rightTop, f2, 8.0f, 8.0f);
            PositionTextureVertex v6 = new PositionTextureVertex(x, f1 - rightBottom, f2, 8.0f, 0.0f);
            this.vertexPositions[0] = v7;
            this.vertexPositions[1] = v;
            this.vertexPositions[2] = v1;
            this.vertexPositions[3] = v2;
            this.vertexPositions[4] = v3;
            this.vertexPositions[5] = v4;
            this.vertexPositions[6] = v5;
            this.vertexPositions[7] = v6;
            this.quadList[0] = new TexturedQuad(new PositionTextureVertex[]{v4, v, v1, v5}, dz + dx, dz, dz + dx + dz, dz + dy, textureWidth, textureHeight);
            this.quadList[1] = new TexturedQuad(new PositionTextureVertex[]{v7, v3, v6, v2}, 0, dz, dz, dz + dy, textureWidth, textureHeight);
            this.quadList[2] = new TexturedQuad(new PositionTextureVertex[]{v4, v3, v7, v}, dz, 0, dz + dx, dz, textureWidth, textureHeight);
            this.quadList[3] = new TexturedQuad(new PositionTextureVertex[]{v1, v2, v6, v5}, faceTexU + dz + dx, faceTexV + dz, faceTexU + dz + dx + dx, faceTexV, textureWidth, textureHeight);
            this.quadList[4] = new TexturedQuad(new PositionTextureVertex[]{v, v7, v2, v1}, dz, dz, dz + dx, dz + dy, textureWidth, textureHeight);
            this.quadList[5] = new TexturedQuad(new PositionTextureVertex[]{v3, v4, v5, v6}, dz + dx + dz, dz, dz + dx + dz + dx, dz + dy, textureWidth, textureHeight);
        }

        @SideOnly(value=Side.CLIENT)
        public void render(BufferBuilder renderer, float scale) {
            for (TexturedQuad texturedquad : this.quadList) {
                texturedquad.func_178765_a(renderer, scale);
            }
        }
    }
}

