/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.renderers;

import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.renderers.CubeRenderer;
import com.zuxelus.energycontrol.renderers.RotationOffset;
import com.zuxelus.energycontrol.tileentities.Screen;
import com.zuxelus.energycontrol.tileentities.TileEntityAdvancedInfoPanel;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class TEAdvancedInfoPanelRenderer
extends TileEntitySpecialRenderer<TileEntityAdvancedInfoPanel> {
    private static final ResourceLocation[] TEXTUREOFF;
    private static final ResourceLocation[] TEXTUREON;
    private static final CubeRenderer[] model;

    private static String implodeArray(String[] inputArray, String glueString) {
        String output = "";
        if (inputArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < inputArray.length; ++i) {
                if (inputArray[i] == null || inputArray[i].isEmpty()) continue;
                sb.append(glueString);
                sb.append(inputArray[i]);
            }
            output = sb.toString();
            if (output.length() > 1) {
                output = output.substring(1);
            }
        }
        return output;
    }

    public void render(TileEntityAdvancedInfoPanel te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        switch (te.getFacing()) {
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
            }
        }
        int color = 6;
        if (te.getColored() && ((color = te.getColorBackground()) > 15 || color < 0)) {
            color = 6;
        }
        if (te.powered) {
            this.func_147499_a(TEXTUREON[color]);
        } else {
            this.func_147499_a(TEXTUREOFF[color]);
        }
        int textureId = te.findTexture();
        byte thickness = te.thickness;
        if (thickness < 1 || thickness > 16) {
            thickness = 16;
        }
        int rotateHor = te.rotateHor / 7;
        int rotateVert = te.rotateVert / 7;
        RotationOffset offset = new RotationOffset(thickness * 2, rotateHor, rotateVert);
        Screen screen = te.getScreen();
        if (screen != null) {
            if (thickness == 16 && rotateHor == 0 && rotateVert == 0) {
                model[textureId].render(0.03125f);
            } else {
                new CubeRenderer(textureId / 4 * 32 + 64, textureId % 4 * 32 + 64, offset.addOffset(screen, te.func_174877_v(), te.getFacing(), te.getRotation())).render(0.03125f);
            }
            if (te.powered) {
                boolean anyCardFound = false;
                List<PanelString> joinedData = te.getPanelStringList(te.getShowLabels());
                if (joinedData != null) {
                    this.drawText(te, joinedData, thickness, offset);
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    private void drawText(TileEntityAdvancedInfoPanel panel, List<PanelString> joinedData, byte thickness, RotationOffset offset) {
        int offsetY;
        int offsetX;
        int i;
        Screen screen = panel.getScreen();
        BlockPos pos = panel.func_174877_v();
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        if (screen != null) {
            block0 : switch (panel.getFacing()) {
                case UP: {
                    switch (panel.getRotation()) {
                        case NORTH: {
                            dz = pos.func_177952_p() - screen.maxZ - screen.minZ + pos.func_177952_p();
                            dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                            displayWidth += (float)(screen.maxX - screen.minX);
                            displayHeight += (float)(screen.maxZ - screen.minZ);
                            break block0;
                        }
                        case SOUTH: {
                            dx = screen.minX - pos.func_177958_n();
                            dz = pos.func_177952_p() - screen.maxZ;
                            displayWidth += (float)(screen.maxX - screen.minX);
                            displayHeight += (float)(screen.maxZ - screen.minZ);
                            break block0;
                        }
                        case EAST: {
                            dz = pos.func_177952_p() - screen.maxZ - screen.minZ + pos.func_177952_p();
                            dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                            displayWidth += (float)(screen.maxZ - screen.minZ);
                            displayHeight += (float)(screen.maxX - screen.minX);
                            break block0;
                        }
                        case WEST: {
                            dx = screen.minX - pos.func_177958_n();
                            dz = screen.minZ - pos.func_177952_p();
                            displayWidth += (float)(screen.maxZ - screen.minZ);
                            displayHeight += (float)(screen.maxX - screen.minX);
                            break block0;
                        }
                        case DOWN: {
                            break block0;
                        }
                    }
                    break;
                }
                case DOWN: {
                    switch (panel.getRotation()) {
                        case NORTH: {
                            dx = pos.func_177958_n() - screen.maxX;
                            dz = pos.func_177952_p() - screen.maxZ;
                            displayWidth += (float)(screen.maxX - screen.minX);
                            displayHeight += (float)(screen.maxZ - screen.minZ);
                            break block0;
                        }
                        case SOUTH: {
                            dx = screen.minX - pos.func_177958_n();
                            dz = screen.minZ - pos.func_177952_p();
                            displayWidth += (float)(screen.maxX - screen.minX);
                            displayHeight += (float)(screen.maxZ - screen.minZ);
                            break block0;
                        }
                        case EAST: {
                            dx = pos.func_177958_n() - screen.maxX;
                            dz = screen.minZ - pos.func_177952_p();
                            displayWidth += (float)(screen.maxZ - screen.minZ);
                            displayHeight += (float)(screen.maxX - screen.minX);
                            break block0;
                        }
                        case WEST: {
                            dx = screen.minX - pos.func_177958_n();
                            dz = pos.func_177952_p() - screen.maxZ;
                            displayWidth += (float)(screen.maxZ - screen.minZ);
                            displayHeight += (float)(screen.maxX - screen.minX);
                            break block0;
                        }
                        case DOWN: {
                            break block0;
                        }
                    }
                    break;
                }
                case NORTH: {
                    dx = pos.func_177958_n() - screen.maxX;
                    dz = screen.minY - pos.func_177956_o();
                    displayWidth += (float)(screen.maxX - screen.minX);
                    displayHeight += (float)(screen.maxY - screen.minY);
                    break;
                }
                case SOUTH: {
                    dx = screen.minX - pos.func_177958_n();
                    dz = screen.minY - pos.func_177956_o();
                    displayWidth += (float)(screen.maxX - screen.minX);
                    displayHeight += (float)(screen.maxY - screen.minY);
                    break;
                }
                case WEST: {
                    dz = screen.minZ - pos.func_177952_p();
                    dx = screen.minY - pos.func_177956_o();
                    displayWidth += (float)(screen.maxZ - screen.minZ);
                    displayHeight += (float)(screen.maxY - screen.minY);
                    break;
                }
                case EAST: {
                    dz = pos.func_177952_p() - screen.maxZ;
                    dx = screen.minY - pos.func_177956_o();
                    displayWidth += (float)(screen.maxZ - screen.minZ);
                    displayHeight += (float)(screen.maxY - screen.minY);
                }
            }
        }
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        switch (panel.getRotation()) {
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(dx - 1.0f), (float)dz, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179109_b((float)dx, (float)(dz - 1.0f), (float)0.0f);
                break;
            }
            case DOWN: {
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)dz, (float)dx, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(dz - 1.0f), (float)(dx - 1.0f), (float)0.0f);
            }
        }
        double h = (offset.leftBottom - offset.rightBottom) / 32.0f;
        double v = (offset.leftTop - offset.leftBottom) / 32.0f;
        double b = Math.atan(h / (double)displayWidth);
        double a = Math.atan(Math.cos(b) * v / (double)displayHeight);
        int n = offset.rotateVert == 0 ? 0 : (i = offset.rotateVert > 0 ? -1 : 1);
        int j = offset.rotateHor == 0 ? 0 : (offset.rotateHor > 0 ? -1 : 1);
        GlStateManager.func_179137_b((double)(displayWidth / 2.0f), (double)(displayHeight / 2.0f), (double)(1.0 + (32.0 * h - (double)offset.leftTop - (double)offset.leftBottom) / 64.0));
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(b)), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(a)), (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(90.0f - (float)Math.toDegrees(Math.acos((h * h + v * v) / 2.0 / Math.sqrt((double)(displayWidth * displayWidth) + h * h) / Math.sqrt((double)(displayHeight * displayHeight) + v * v)))), (float)0.0f, (float)0.0f, (float)(i * j));
        GlStateManager.func_179109_b((float)0.0f, (float)(0.001f * (float)i), (float)0.001f);
        displayHeight = (float)((double)(displayHeight - 0.125f) / Math.cos(a));
        displayWidth = (float)((double)(displayWidth - 0.125f) / Math.cos(b));
        FontRenderer fontRenderer = this.func_147498_b();
        int maxWidth = 1;
        for (PanelString panelString : joinedData) {
            String currentString = TEAdvancedInfoPanelRenderer.implodeArray(new String[]{panelString.textLeft, panelString.textCenter, panelString.textRight}, " ");
            maxWidth = Math.max(fontRenderer.func_78256_a(currentString), maxWidth);
        }
        int lineHeight = fontRenderer.field_78288_b + 2;
        int requiredHeight = lineHeight * joinedData.size();
        float scaleX = displayWidth / (float)(maxWidth += 4);
        float scaleY = displayHeight / (float)requiredHeight;
        float scale = Math.min(scaleX, scaleY);
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        if (scaleX < scaleY) {
            offsetX = 2;
            offsetY = (realHeight - requiredHeight) / 2;
        } else {
            offsetX = (realWidth - maxWidth) / 2 + 2;
            offsetY = 0;
        }
        GlStateManager.func_179140_f();
        int row = 0;
        int colorHex = 0;
        if (panel.getColored()) {
            colorHex = panel.getColorTextHex();
        }
        for (PanelString panelString : joinedData) {
            if (panelString.textLeft != null) {
                fontRenderer.func_78276_b(panelString.textLeft, offsetX - realWidth / 2, 1 + offsetY - realHeight / 2 + row * lineHeight, panelString.colorLeft != 0 ? panelString.colorLeft : colorHex);
            }
            if (panelString.textCenter != null) {
                fontRenderer.func_78276_b(panelString.textCenter, -fontRenderer.func_78256_a(panelString.textCenter) / 2, offsetY - realHeight / 2 + row * lineHeight, panelString.colorCenter != 0 ? panelString.colorCenter : colorHex);
            }
            if (panelString.textRight != null) {
                fontRenderer.func_78276_b(panelString.textRight, realWidth / 2 - fontRenderer.func_78256_a(panelString.textRight), offsetY - realHeight / 2 + row * lineHeight, panelString.colorRight != 0 ? panelString.colorRight : colorHex);
            }
            ++row;
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        int i;
        TEXTUREOFF = new ResourceLocation[16];
        TEXTUREON = new ResourceLocation[16];
        for (i = 0; i < 16; ++i) {
            TEAdvancedInfoPanelRenderer.TEXTUREOFF[i] = new ResourceLocation("energycontrol" + String.format(":textures/blocks/info_panel/off/alladv%d.png", i));
            TEAdvancedInfoPanelRenderer.TEXTUREON[i] = new ResourceLocation("energycontrol" + String.format(":textures/blocks/info_panel/on/alladv%d.png", i));
        }
        model = new CubeRenderer[16];
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                TEAdvancedInfoPanelRenderer.model[i * 4 + j] = new CubeRenderer(i * 32 + 64, j * 32 + 64);
            }
        }
    }
}

