/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.tileentities.TileEntityEnergyStorage;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityAFSU
extends TileEntityEnergyStorage
implements ITickable,
IEnergyStorage {
    public static final int TIER = 5;
    public static final int CAPACITY = 400000000;
    public static final int OUTPUT = 8192;
    public static final int SLOT_CHARGER = 0;
    public static final int SLOT_DISCHARGER = 1;
    private byte redstoneMode = 0;
    private boolean poweredBlock;

    public TileEntityAFSU() {
        super("tile.afsu.name", 5, 8192, 400000000);
    }

    public byte getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(byte value) {
        byte old = this.redstoneMode;
        this.redstoneMode = value;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.redstoneMode != old) {
            this.notifyBlockUpdate();
        }
    }

    public boolean getPowered() {
        return this.poweredBlock;
    }

    protected boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 1: {
                return this.energy >= this.capacity - (double)this.output * 20.0;
            }
            case 2: {
                return this.energy > (double)this.output && this.energy < this.capacity - (double)this.output;
            }
            case 3: {
                return this.energy < this.capacity - (double)this.output;
            }
            case 4: {
                return this.energy < (double)this.output;
            }
        }
        return false;
    }

    protected boolean shouldEmitEnergy() {
        boolean redstone = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (this.redstoneMode == 5) {
            return !redstone;
        }
        if (this.redstoneMode == 6) {
            return !redstone || this.energy > this.capacity - (double)this.output * 20.0;
        }
        return true;
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("value")) break;
                this.setRedstoneMode((byte)tag.func_74769_h("value"));
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("value")) break;
                this.energy = tag.func_74769_h("value");
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        this.allowEmit = this.shouldEmitEnergy();
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        this.setRedstoneMode(tag.func_74771_c("redstoneMode"));
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74774_a("redstoneMode", this.redstoneMode);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    public void func_73660_a() {
        IElectricItem ielectricitem;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.onLoad();
        ItemStack stack = this.func_70301_a(1);
        if (!stack.func_190926_b() && this.energy < 4.0E8 && stack.func_77973_b() instanceof IElectricItem && (ielectricitem = (IElectricItem)stack.func_77973_b()).canProvideEnergy(stack)) {
            this.energy += ElectricItem.manager.discharge(stack, 4.0E8 - this.energy, 5, false, false, false);
        }
        if (!(stack = this.func_70301_a(0)).func_190926_b() && this.energy > 0.0 && stack.func_77973_b() instanceof IElectricItem) {
            IElectricItem item = (IElectricItem)stack.func_77973_b();
            int tier = item.getTier(stack);
            double amount = ElectricItem.manager.charge(stack, Double.POSITIVE_INFINITY, tier, true, true);
            if ((amount = Math.min(amount, this.energy)) > 0.0) {
                this.energy -= ElectricItem.manager.charge(stack, amount, tier, false, false);
            }
        }
        this.updateState();
    }

    public void updateState() {
        boolean old = this.poweredBlock;
        this.poweredBlock = this.shouldEmitRedstone();
        if (!(this.field_145850_b.field_72995_K || this.poweredBlock == old && this.allowEmit == this.shouldEmitEnergy())) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (this.poweredBlock != old) {
                this.field_145850_b.func_175685_c(this.field_174879_c, state.func_177230_c(), false);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private void notifyBlockUpdate() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IElectricItem)) {
            return false;
        }
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        return (item.canProvideEnergy(stack) || slot == 0) && item.getTier(stack) <= 5;
    }

    @Override
    public int getStored() {
        return (int)this.getEnergy();
    }

    @Override
    public void setStored(int energy) {
    }

    @Override
    public int addEnergy(int amount) {
        amount = (int)Math.min(this.capacity - this.energy, (double)amount);
        this.energy += (double)amount;
        return amount;
    }

    @Override
    public int getCapacity() {
        return (int)this.capacity;
    }

    @Override
    public double getOutputEnergyUnitsPerTick() {
        return 8192.0;
    }

    @Override
    public boolean isTeleporterCompatible(EnumFacing side) {
        return true;
    }
}

