/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.containers.ISlotItemFilter;
import com.zuxelus.energycontrol.tileentities.ITilePacketHandler;
import com.zuxelus.energycontrol.tileentities.TileEntityInventory;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.info.Info;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEntityEnergyStorage
extends TileEntityInventory
implements IEnergySink,
IEnergySource,
ISlotItemFilter,
ITilePacketHandler {
    protected boolean addedToEnet = false;
    protected boolean allowEmit = true;
    protected int tier;
    protected int output;
    protected double energy = 0.0;
    protected double capacity;

    public TileEntityEnergyStorage(String name, int tier, int output, int capacity) {
        super(name);
        this.tier = tier;
        this.output = output;
        this.capacity = capacity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public int getOutput() {
        return this.output;
    }

    @Override
    public void setFacing(int meta) {
        this.onChunkUnload();
        super.setFacing(meta);
        this.onLoad();
    }

    public void setEnergy(double value) {
        this.energy = Math.min(value, this.capacity);
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        this.energy = tag.func_74769_h("energy");
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74780_a("energy", this.energy);
        return tag;
    }

    public void onLoad() {
        if (!this.addedToEnet && this.field_145850_b != null && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void func_145843_s() {
        this.onChunkUnload();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && this.field_145850_b != null && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return side == this.getFacing();
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy -= amount;
    }

    @Override
    public double getOfferedEnergy() {
        return this.allowEmit ? (this.energy >= (double)this.output ? (double)this.output : 0.0) : 0.0;
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return side != this.getFacing();
    }

    @Override
    public double getDemandedEnergy() {
        return Math.min(this.capacity - this.energy, (double)this.output);
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (this.energy >= this.capacity) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }
}

