/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.minecraft.client.resources.I18n;

public class StringUtils {
    private static DecimalFormat formatter = null;

    private static DecimalFormat getFormatter() {
        if (formatter == null) {
            DecimalFormat lFormatter = new DecimalFormat("#,###.###");
            DecimalFormatSymbols smb = new DecimalFormatSymbols();
            smb.setGroupingSeparator(' ');
            lFormatter.setDecimalFormatSymbols(smb);
            formatter = lFormatter;
        }
        return formatter;
    }

    public static String getFormatted(String resourceName, String value, boolean showLabels) {
        if (showLabels) {
            return I18n.func_135052_a((String)resourceName, (Object[])new Object[]{value});
        }
        return value;
    }

    public static String getFormatted(String resourceName, double value, boolean showLabels) {
        return StringUtils.getFormatted(resourceName, StringUtils.getFormatter().format(value), showLabels);
    }

    public static String getFormattedKey(String resourceName, Object ... arguments) {
        return I18n.func_135052_a((String)resourceName, (Object[])arguments);
    }
}

