/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.items.ItemPhantomConnector;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemSpawnerChanger
extends ItemBase {
    public ItemSpawnerChanger(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            String entity;
            TileEntity tile;
            ItemStack stack = player.func_184614_ca();
            if (player.func_175151_a(pos.func_177972_a(facing), facing, stack) && (tile = world.func_175625_s(pos)) instanceof TileEntityMobSpawner && (entity = this.getStoredEntity(stack)) != null) {
                MobSpawnerBaseLogic logic = ((TileEntityMobSpawner)tile).func_145881_a();
                NBTTagCompound compound = new NBTTagCompound();
                logic.func_189530_b(compound);
                compound.func_82580_o("SpawnPotentials");
                compound.func_82580_o("SpawnData");
                logic.func_98270_a(compound);
                logic.func_190894_a(new ResourceLocation(entity));
                tile.func_70296_d();
                IBlockState state = world.func_180495_p(pos);
                world.func_184138_a(pos, state, state, 3);
                ItemPhantomConnector.clearStorage(stack, "Entity");
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, StackUtil.shrink(stack, 1));
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean func_111207_a(ItemStack aStack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            ItemStack stack = player.func_184614_ca();
            if (this.getStoredEntity(stack) == null && this.storeClickedEntity(stack, entity)) {
                entity.func_70106_y();
            }
            return true;
        }
        return false;
    }

    private boolean storeClickedEntity(ItemStack stack, EntityLivingBase entity) {
        String entityName;
        ResourceLocation entityLoc;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(entity instanceof EntityPlayer) && entity.func_184222_aU() && (entityLoc = EntityList.func_191306_a(entity.getClass())) != null && (entityName = entityLoc.toString()) != null && !entityName.isEmpty()) {
            for (String name : ConfigStringListValues.SPAWNER_CHANGER_BLACKLIST.getValue()) {
                if (!entityName.equals(name)) continue;
                return false;
            }
            stack.func_77978_p().func_74778_a("Entity", entityName);
            return true;
        }
        return false;
    }

    private String getStoredEntity(ItemStack stack) {
        String entity;
        if (stack.func_77942_o() && (entity = stack.func_77978_p().func_74779_i("Entity")) != null && !entity.isEmpty()) {
            return entity;
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World playerIn, List<String> list, ITooltipFlag advanced) {
        String entity = this.getStoredEntity(stack);
        if (entity != null) {
            list.add("Entity: " + entity);
            list.add(TextFormatting.ITALIC + StringUtil.localize("tooltip.actuallyadditions.clearStorage.desc"));
        }
    }
}

