/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileEntityInventoryBase
extends TileEntityBase {
    public final ItemStackHandlerAA inv;

    public TileEntityInventoryBase(int slots, String name) {
        super(name);
        this.inv = new TileStackHandler(slots);
    }

    public static void saveSlots(IItemHandler slots, NBTTagCompound compound) {
        if (slots != null && slots.getSlots() > 0) {
            NBTTagList tagList = new NBTTagList();
            for (int i = 0; i < slots.getSlots(); ++i) {
                ItemStack slot = slots.getStackInSlot(i);
                NBTTagCompound tagCompound = new NBTTagCompound();
                if (StackUtil.isValid(slot)) {
                    slot.func_77955_b(tagCompound);
                }
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            compound.func_74782_a("Items", (NBTBase)tagList);
        }
    }

    public static void loadSlots(IItemHandlerModifiable slots, NBTTagCompound compound) {
        if (slots != null && slots.getSlots() > 0) {
            NBTTagList tagList = compound.func_150295_c("Items", 10);
            for (int i = 0; i < slots.getSlots(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                slots.setStackInSlot(i, tagCompound != null && tagCompound.func_74764_b("id") ? new ItemStack(tagCompound) : StackUtil.getEmpty());
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE || type == TileEntityBase.NBTType.SYNC && this.shouldSyncSlots()) {
            TileEntityInventoryBase.saveSlots((IItemHandler)this.inv, compound);
        }
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.inv;
    }

    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return ItemStackHandlerAA.ACCEPT_TRUE;
    }

    public ItemStackHandlerAA.IRemover getRemover() {
        return ItemStackHandlerAA.REMOVE_TRUE;
    }

    public int getMaxStackSize(int slot) {
        return 64;
    }

    public boolean shouldSyncSlots() {
        return false;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.shouldSyncSlots()) {
            this.sendUpdate();
        }
    }

    @Override
    public int getComparatorStrength() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inv);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE || type == TileEntityBase.NBTType.SYNC && this.shouldSyncSlots()) {
            TileEntityInventoryBase.loadSlots((IItemHandlerModifiable)this.inv, compound);
        }
    }

    protected class TileStackHandler
    extends ItemStackHandlerAA {
        protected TileStackHandler(int slots) {
            super(slots);
        }

        @Override
        public ItemStackHandlerAA.IAcceptor getAcceptor() {
            return TileEntityInventoryBase.this.getAcceptor();
        }

        @Override
        public ItemStackHandlerAA.IRemover getRemover() {
            return TileEntityInventoryBase.this.getRemover();
        }

        public int getSlotLimit(int slot) {
            return TileEntityInventoryBase.this.getMaxStackSize(slot);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityInventoryBase.this.func_70296_d();
        }
    }
}

