/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.client.handlers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.api.item.IModularArmor;
import com.mjr.extraplanets.api.prefabs.entity.EntityElectricRocketBase;
import com.mjr.extraplanets.api.prefabs.world.WorldProviderRealisticSpace;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.blocks.machines.ExtraPlanets_Machines;
import com.mjr.extraplanets.client.gui.overlay.OverlayElectricLaunchCountdown;
import com.mjr.extraplanets.client.gui.overlay.OverlayGeneralLander;
import com.mjr.extraplanets.client.gui.overlay.OverlayJupiterLander;
import com.mjr.extraplanets.client.gui.overlay.OverlayMercuryLander;
import com.mjr.extraplanets.client.gui.overlay.OverlayNeptuneLander;
import com.mjr.extraplanets.client.gui.overlay.OverlayPressure;
import com.mjr.extraplanets.client.gui.overlay.OverlaySaturnLander;
import com.mjr.extraplanets.client.gui.overlay.OverlaySolarRadiation;
import com.mjr.extraplanets.client.gui.overlay.OverlayUranusLander;
import com.mjr.extraplanets.client.gui.screen.CustomCelestialSelection;
import com.mjr.extraplanets.client.handlers.capabilities.CapabilityStatsClientHandler;
import com.mjr.extraplanets.client.handlers.capabilities.IStatsClientCapability;
import com.mjr.extraplanets.entities.landers.EntityGeneralLander;
import com.mjr.extraplanets.entities.landers.EntityJupiterLander;
import com.mjr.extraplanets.entities.landers.EntityMercuryLander;
import com.mjr.extraplanets.entities.landers.EntityNeptuneLander;
import com.mjr.extraplanets.entities.landers.EntitySaturnLander;
import com.mjr.extraplanets.entities.landers.EntityUranusLander;
import com.mjr.extraplanets.items.armor.modules.Module;
import com.mjr.extraplanets.items.armor.modules.ModuleHelper;
import com.mjr.extraplanets.network.ExtraPlanetsPacketHandler;
import com.mjr.extraplanets.network.PacketSimpleEP;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.Jupiter.WorldProviderJupiter;
import com.mjr.mjrlegendslib.network.IPacket;
import com.mjr.mjrlegendslib.util.MCUtilities;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlayRocket;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.network.PacketRotateRocket;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.venus.client.FakeLightningBoltRenderer;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class MainHandlerClient {
    private static List<ExtraPlanetsPacketHandler> packetHandlers = Lists.newCopyOnWriteArrayList();
    private Map<BlockPos, Integer> lightning = Maps.newHashMap();

    public static void addPacketHandler(ExtraPlanetsPacketHandler handler) {
        packetHandlers.add(handler);
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        for (ExtraPlanetsPacketHandler packetHandler : packetHandlers) {
            packetHandler.unload(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = MCUtilities.getClient();
        WorldClient world = minecraft.field_71441_e;
        EntityPlayerSP player = minecraft.field_71439_g;
        if (event.phase == TickEvent.Phase.END && world != null) {
            for (ExtraPlanetsPacketHandler handler : packetHandlers) {
                handler.tick((World)world);
            }
        }
        if (event.phase == TickEvent.Phase.START && player != null) {
            boolean inSpaceShip = false;
            if (player.func_184187_bx() instanceof EntityElectricRocketBase) {
                inSpaceShip = true;
                EntityElectricRocketBase rocket = (EntityElectricRocketBase)player.func_184187_bx();
                if (rocket.field_70127_C != rocket.field_70125_A || rocket.field_70126_B != rocket.field_70177_z) {
                    GalacticraftCore.packetPipeline.sendToServer((micdoodle8.mods.galacticraft.core.network.IPacket)new PacketRotateRocket(player.func_184187_bx()));
                }
            }
            if (inSpaceShip) {
                EntityElectricRocketBase ship = (EntityElectricRocketBase)player.func_184187_bx();
                boolean hasChanged = false;
                if (minecraft.field_71474_y.field_74370_x.func_151470_d()) {
                    ship.turnYaw(-1.0f);
                    hasChanged = true;
                }
                if (minecraft.field_71474_y.field_74366_z.func_151470_d()) {
                    ship.turnYaw(1.0f);
                    hasChanged = true;
                }
                if (minecraft.field_71474_y.field_74351_w.func_151470_d() && ship.getLaunched()) {
                    ship.turnPitch(-0.7f);
                    hasChanged = true;
                }
                if (minecraft.field_71474_y.field_74368_y.func_151470_d() && ship.getLaunched()) {
                    ship.turnPitch(0.7f);
                    hasChanged = true;
                }
                if (hasChanged) {
                    GalacticraftCore.packetPipeline.sendToServer((micdoodle8.mods.galacticraft.core.network.IPacket)new PacketRotateRocket((Entity)ship));
                }
            }
            if (Config.USE_CUSTOM_CELESTIAL_SELECTION && MCUtilities.getClient().field_71462_r instanceof CustomCelestialSelection) {
                player.field_70181_x = 0.0;
            }
            if (player.func_184187_bx() != null && KeyHandlerClient.spaceKey.func_151470_d()) {
                ExtraPlanets.packetPipeline.sendToServer((IPacket)new PacketSimpleEP(PacketSimpleEP.EnumSimplePacket.S_IGNITE_ROCKET, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[0]));
            }
        }
    }

    public void showPressureHUD(int amount) {
        OverlayPressure.renderPressureIndicator(amount, !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
    }

    public void showRadiationHUD(int amount) {
        OverlaySolarRadiation.renderSolarRadiationIndicator(amount, !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = MCUtilities.getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        if (player != null && player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && OxygenUtil.shouldDisplayTankGui((GuiScreen)minecraft.field_71462_r) && OxygenUtil.noAtmosphericCombustion((WorldProvider)player.field_70170_p.field_73011_w) && !playerBaseClient.func_175149_v() && !minecraft.field_71474_y.field_74330_P) {
            int radiationLevel;
            IStatsClientCapability stats = null;
            boolean showPressure = false;
            boolean showRadiation = false;
            if (player != null) {
                stats = (IStatsClientCapability)playerBaseClient.getCapability(CapabilityStatsClientHandler.EP_STATS_CLIENT_CAPABILITY, null);
            }
            int pressureLevel = 0;
            if (player.field_70170_p.field_73011_w instanceof WorldProviderRealisticSpace) {
                if (Config.PRESSURE) {
                    pressureLevel = ((WorldProviderRealisticSpace)player.field_70170_p.field_73011_w).getPressureLevel();
                    showPressure = true;
                }
                if (Config.RADIATION) {
                    showRadiation = true;
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderMoon) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    pressureLevel = 80;
                    showPressure = true;
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    showRadiation = true;
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderMars) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    pressureLevel = 90;
                    showPressure = true;
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    showRadiation = true;
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderVenus) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    pressureLevel = 100;
                    showPressure = true;
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    showRadiation = true;
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderAsteroids) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    pressureLevel = 100;
                    showPressure = true;
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    showRadiation = true;
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    pressureLevel = 100;
                    showPressure = true;
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    showRadiation = true;
                }
            } else if (Config.OTHER_ADDON_PLANET_MOON_RAD_VALUES_LIST.containsKey(((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getCelestialBody().getUnlocalizedName())) {
                showRadiation = true;
            }
            if ((pressureLevel != 0 || !Config.HIDE_RADIATION_PRESSURE_HUD) && showPressure) {
                this.showPressureHUD(pressureLevel);
            }
            if (((radiationLevel = (int)Math.floor(stats.getRadiationLevel())) != 0 || !Config.HIDE_RADIATION_PRESSURE_HUD) && showRadiation) {
                this.showRadiationHUD(radiationLevel);
            }
        }
        if (minecraft.field_71462_r == null && player.func_184187_bx() instanceof EntityElectricRocketBase && minecraft.field_71474_y.field_74320_O != 0 && !minecraft.field_71474_y.field_74319_N) {
            OverlayRocket.renderSpaceshipOverlay((Minecraft)FMLClientHandler.instance().getClient(), (ResourceLocation)((EntityElectricRocketBase)player.func_184187_bx()).getSpaceshipGui());
        }
        if (minecraft.field_71462_r == null && player.func_184187_bx() instanceof EntityElectricRocketBase && minecraft.field_71474_y.field_74320_O != 0 && !minecraft.field_71474_y.field_74319_N && !((EntityElectricRocketBase)minecraft.field_71439_g.func_184187_bx()).getLaunched()) {
            OverlayElectricLaunchCountdown.renderCountdownOverlay();
        }
        if (minecraft.field_71462_r == null && player.func_184187_bx() instanceof EntityJupiterLander && minecraft.field_71474_y.field_74320_O != 0 && !minecraft.field_71474_y.field_74319_N) {
            OverlayJupiterLander.renderLanderOverlay();
        }
        if (minecraft.field_71462_r == null && player.func_184187_bx() instanceof EntitySaturnLander && minecraft.field_71474_y.field_74320_O != 0 && !minecraft.field_71474_y.field_74319_N) {
            OverlaySaturnLander.renderLanderOverlay();
        }
        if (minecraft.field_71462_r == null && player.func_184187_bx() instanceof EntityMercuryLander && minecraft.field_71474_y.field_74320_O != 0 && !minecraft.field_71474_y.field_74319_N) {
            OverlayMercuryLander.renderLanderOverlay();
        }
        if (minecraft.field_71462_r == null && player.func_184187_bx() instanceof EntityUranusLander && minecraft.field_71474_y.field_74320_O != 0 && !minecraft.field_71474_y.field_74319_N) {
            OverlayUranusLander.renderLanderOverlay();
        }
        if (minecraft.field_71462_r == null && player.func_184187_bx() instanceof EntityNeptuneLander && minecraft.field_71474_y.field_74320_O != 0 && !minecraft.field_71474_y.field_74319_N) {
            OverlayNeptuneLander.renderLanderOverlay();
        }
        if (minecraft.field_71462_r == null && player.func_184187_bx() instanceof EntityGeneralLander && minecraft.field_71474_y.field_74320_O != 0 && !minecraft.field_71474_y.field_74319_N) {
            OverlayGeneralLander.renderLanderOverlay();
        }
    }

    @SubscribeEvent
    public void renderLightning(ClientProxyCore.EventSpecialRender event) {
        Minecraft minecraft = MCUtilities.getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player != null && Config.JUITPER_LIGHTING_CLIENT) {
            for (Map.Entry<BlockPos, Integer> entry : this.lightning.entrySet()) {
                long seed = entry.getValue() / 10 + entry.getKey().func_177958_n() + entry.getKey().func_177952_p();
                FakeLightningBoltRenderer.renderBolt((long)seed, (double)((double)entry.getKey().func_177958_n() - ClientProxyCore.playerPosX), (double)((double)entry.getKey().func_177956_o() - ClientProxyCore.playerPosY), (double)((double)entry.getKey().func_177952_p() - ClientProxyCore.playerPosZ));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Minecraft minecraft = MCUtilities.getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player == event.player) {
            if (Config.JUITPER_LIGHTING_CLIENT) {
                Iterator<Map.Entry<BlockPos, Integer>> it = this.lightning.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<BlockPos, Integer> entry = it.next();
                    int val = entry.getValue();
                    if (val - 1 <= 0) {
                        it.remove();
                        continue;
                    }
                    entry.setValue(val - 1);
                }
                if (player.func_70681_au().nextInt(100) == 0 && minecraft.field_71441_e.field_73011_w instanceof WorldProviderJupiter) {
                    double freq = player.func_70681_au().nextDouble() * Math.PI * 2.0;
                    double dist = 180.0;
                    double dX = dist * Math.cos(freq);
                    double dZ = dist * Math.sin(freq);
                    double posX = player.field_70165_t + dX;
                    double posY = 70.0;
                    double posZ = player.field_70161_v + dZ;
                    minecraft.field_71441_e.func_184148_a((EntityPlayer)player, posX, posY, posZ, SoundEvents.field_187754_de, SoundCategory.WEATHER, 1000.0f, 5.0f + player.func_70681_au().nextFloat() * 0.2f);
                    this.lightning.put(new BlockPos(posX, posY, posZ), 20);
                }
            }
            this.tickModules(event, (EntityLivingBase)player);
        }
    }

    private void tickModules(TickEvent.PlayerTickEvent event, EntityLivingBase entityLiving) {
        EntityPlayerSP player = (EntityPlayerSP)entityLiving;
        ItemStack helmet = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        ItemStack chest = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        ItemStack leggins = (ItemStack)player.field_71071_by.field_70460_b.get(1);
        ItemStack boots = (ItemStack)player.field_71071_by.field_70460_b.get(0);
        if (helmet.func_77973_b() instanceof IModularArmor) {
            for (Module hemletModules : ModuleHelper.getModules(helmet)) {
                if (!hemletModules.isActive() || !ModuleHelper.hasPower(helmet, ModuleHelper.getModuleUseCost(hemletModules))) continue;
                hemletModules.tickClient(player);
            }
        }
        if (chest.func_77973_b() instanceof IModularArmor) {
            for (Module chestModules : ModuleHelper.getModules(chest)) {
                if (!chestModules.isActive() || !ModuleHelper.hasPower(helmet, ModuleHelper.getModuleUseCost(chestModules))) continue;
                chestModules.tickClient(player);
            }
        }
        if (leggins.func_77973_b() instanceof IModularArmor) {
            for (Module legginsModules : ModuleHelper.getModules(leggins)) {
                if (!legginsModules.isActive() || !ModuleHelper.hasPower(helmet, ModuleHelper.getModuleUseCost(legginsModules))) continue;
                legginsModules.tickClient(player);
            }
        }
        if (boots.func_77973_b() instanceof IModularArmor) {
            for (Module bootsModules : ModuleHelper.getModules(boots)) {
                if (!bootsModules.isActive() || !ModuleHelper.hasPower(helmet, ModuleHelper.getModuleUseCost(bootsModules))) continue;
                bootsModules.tickClient(player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack != null && stack.func_77973_b() != null) {
            if (stack.func_77973_b() instanceof UniversalBucket) {
                if (FluidUtil.getFluidContained((ItemStack)stack) != null && FluidUtil.getFluidContained((ItemStack)stack).getFluid() != null) {
                    FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
                    Fluid fluid = fluidStack.getFluid();
                    if (fluid.equals(ExtraPlanets_Fluids.FROZEN_WATER_FLUID) || fluid.equals(ExtraPlanets_Fluids.GLOWSTONE_FLUID) || fluid.equals(ExtraPlanets_Fluids.INFECTED_WATER_FLUID) || fluid.equals(ExtraPlanets_Fluids.LIQUID_HYDROCARBON_FLUID) || fluid.equals(ExtraPlanets_Fluids.MAGMA_FLUID) || fluid.equals(ExtraPlanets_Fluids.METHANE_FLUID) || fluid.equals(ExtraPlanets_Fluids.NITROGEN_FLUID) || fluid.equals(ExtraPlanets_Fluids.RADIO_ACTIVE_WATER_FLUID) || fluid.equals(ExtraPlanets_Fluids.SALT_FLUID) || fluid.equals(ExtraPlanets_Fluids.LIQUID_CARAMEL_FLUID) || fluid.equals(ExtraPlanets_Fluids.LIQUID_CHOCOLATE_FLUID) || fluid.equals(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID)) {
                        event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"gui.bucket.message.finding"));
                        event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)("gui.bucket.message.finding.2." + fluid.getUnlocalizedName().substring(6))));
                    } else if (fluid.equals(ExtraPlanets_Fluids.CLEAN_WATER_FLUID)) {
                        event.getToolTip().add(EnumColor.ORANGE + TranslateUtilities.translate((String)"gui.bucket.message.crafting"));
                    }
                    if (fluid.equals(ExtraPlanets_Fluids.FROZEN_WATER_FLUID) || fluid.equals(ExtraPlanets_Fluids.INFECTED_WATER_FLUID) || fluid.equals(ExtraPlanets_Fluids.NITROGEN_FLUID) || fluid.equals(ExtraPlanets_Fluids.NITROGEN_ICE_FLUID) || fluid.equals(ExtraPlanets_Fluids.RADIO_ACTIVE_WATER_FLUID) || fluid.equals(ExtraPlanets_Fluids.CLEAN_WATER_FLUID)) {
                        event.getToolTip().add(EnumColor.BRIGHT_GREEN + TranslateUtilities.translate((String)"gui.bucket.message.extreme.reactors.compact"));
                    }
                }
            } else if (stack.func_77973_b().equals(Item.func_150898_a((Block)ExtraPlanets_Blocks.VOLCANIC_ROCK))) {
                event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"gui.message.finding.block"));
                event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"gui.message.finding.volcanic.rock"));
            } else if (stack.func_77973_b().equals(Item.func_150898_a((Block)ExtraPlanets_Machines.BASIC_DECONTAMINATION_UNIT))) {
                event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"gui.message.decontamination.unit"));
            } else if (stack.func_77973_b().equals(Item.func_150898_a((Block)ExtraPlanets_Blocks.ORE_POTASH))) {
                event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"gui.message.finding.block"));
                event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"gui.message.finding.potash"));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (Config.USE_CUSTOM_CELESTIAL_SELECTION && event.getGui() instanceof GuiCelestialSelection) {
            if (event.getGui().getClass().getName().equalsIgnoreCase("asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection")) {
                MessageUtilities.throwCrashError((String)"Please disable the following option: enableNewGalaxyMap in configs/AsmodeusCore/core.conf");
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.galaxyMap)) {
                event.setGui((GuiScreen)new CustomCelestialSelection(true, ((GuiCelestialSelection)event.getGui()).possibleBodies, ((GuiCelestialSelection)event.getGui()).canCreateStations));
            } else {
                event.setGui((GuiScreen)new CustomCelestialSelection(false, ((GuiCelestialSelection)event.getGui()).possibleBodies, ((GuiCelestialSelection)event.getGui()).canCreateStations));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onRenderFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (event.getEntity().func_180799_ab() || event.getEntity().func_70090_H()) {
            return;
        }
        if (Config.CUSTOM_FOG) {
            if (event.getEntity().field_70170_p.field_73011_w.func_186058_p().func_186068_a() == Config.JUPITER_ID) {
                event.setDensity(0.02f);
                GL11.glFogi((int)2917, (int)2048);
                event.setCanceled(true);
            } else if (event.getEntity().field_70170_p.field_73011_w.func_186058_p().func_186068_a() == Config.URANUS_ID) {
                event.setDensity(0.008f);
                GL11.glFogi((int)2917, (int)2048);
                event.setCanceled(true);
            } else if (event.getEntity().field_70170_p.field_73011_w.func_186058_p().func_186068_a() == Config.SATURN_ID) {
                event.setDensity(0.015f);
                GL11.glFogi((int)2917, (int)2048);
                event.setCanceled(true);
            } else if (event.getEntity().field_70170_p.field_73011_w.func_186058_p().func_186068_a() == Config.NEPTUNE_ID) {
                event.setDensity(0.01f);
                GL11.glFogi((int)2917, (int)2048);
                event.setCanceled(true);
            } else {
                GL11.glFogi((int)2917, (int)9729);
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlanetPost(CelestialBodyRenderEvent.Post event) {
        Minecraft mc = MCUtilities.getMinecraft();
        if (mc.field_71462_r instanceof GuiCelestialSelection) {
            GuiCelestialSelection screen = (GuiCelestialSelection)mc.field_71462_r;
            if (event.celestialBody == ExtraPlanets_Planets.SATURN) {
                mc.field_71446_o.func_110577_a(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/saturn_rings.png"));
                float size = (float)screen.getWidthForCelestialBody(event.celestialBody) / 6.0f;
                screen.drawTexturedModalRect(-7.5f * size, -1.75f * size, 15.0f * size, 3.5f * size, 0.0f, 0.0f, 30.0f, 7.0f, false, false, 32.0f, 32.0f);
            } else if (event.celestialBody == ExtraPlanets_Planets.URANUS) {
                mc.field_71446_o.func_110577_a(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/uranus_rings.png"));
                float size = (float)screen.getWidthForCelestialBody(event.celestialBody) / 6.0f;
                screen.drawTexturedModalRect(-1.75f * size, -7.0f * size, 3.5f * size, 14.0f * size, 0.0f, 0.0f, 7.0f, 28.0f, false, false, 32.0f, 32.0f);
            }
        }
    }
}

