/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.jei.crystallizer;

import com.mjr.mjrlegendslib.util.TranslateUtilities;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class CrystallizerRecipeCategory
implements IRecipeCategory<IRecipeWrapper> {
    private static final ResourceLocation guiTexture = new ResourceLocation("extraplanets", "textures/gui/crystallizer.png");
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;
    @Nonnull
    private final IDrawableAnimated saltBar;

    @Nonnull
    public CrystallizerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(guiTexture, 3, 4, 168, 80);
        this.localizedName = TranslateUtilities.translate((String)"container.basic.crystallizer.name");
        IDrawableStatic progressBarDrawableSalt = guiHelper.createDrawable(guiTexture, 192, 0, 16, 38);
        this.saltBar = guiHelper.createAnimatedDrawable(progressBarDrawableSalt, 70, IDrawableAnimated.StartDirection.TOP, true);
    }

    @Nonnull
    public String getUid() {
        return "extraplanets.crystallizer";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.saltBar.draw(minecraft, 4, 24);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 3, 2);
        itemStacks.init(1, false, 108, 30);
        itemStacks.set(ingredients);
    }

    public String getModName() {
        return "ExtraPlanets";
    }
}

