/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Jupiter;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanetsDimensions;
import com.mjr.extraplanets.api.prefabs.world.WorldProviderRealisticSpace;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.Jupiter.worldgen.BiomeProviderJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.ChunkProviderJupiter;
import com.mjr.mjrlegendslib.util.MCUtilities;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class WorldProviderJupiter
extends WorldProviderRealisticSpace {
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.98039216f * f), (double)(0.7529412f * f), (double)(0.4509804f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.9411765f * f), (double)(0.627451f * f), (double)(0.21568628f * f));
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 9550L;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderJupiter.class;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ExtraPlanets_Planets.JUPITER);
        return BiomeProviderJupiter.class;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public float getGravity() {
        if (Config.OLD_STYLE_GRAVITY) {
            return 0.058f;
        }
        return 0.015f;
    }

    public int getHeight() {
        return 800;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return 1.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= ExtraPlanets_Planets.JUPITER.getTierRequirement();
    }

    public float getFallDamageModifier() {
        if (Config.OLD_STYLE_GRAVITY) {
            return 0.38f;
        }
        return 2.1f;
    }

    public CelestialBody getCelestialBody() {
        return ExtraPlanets_Planets.JUPITER;
    }

    public float getThermalLevelModifier() {
        if (Config.THERMAL_PADDINGS) {
            if (MCUtilities.isServer() && this.isDaytime()) {
                return 100.0f;
            }
            return 90.0f;
        }
        return 5.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 4.0;
    }

    @Override
    public int getPressureLevel() {
        return 2;
    }

    @Override
    public int getSolarRadiationLevel() {
        return Config.JUPITER_RADIATION_AMOUNT;
    }

    public DimensionType func_186058_p() {
        return ExtraPlanetsDimensions.JUPITER;
    }

    public int getDungeonSpacing() {
        return 800;
    }

    public ResourceLocation getDungeonChestType() {
        return RoomTreasure.MOONCHEST;
    }

    public List<Block> getSurfaceBlocks() {
        LinkedList<Block> list = new LinkedList<Block>();
        list.add(ExtraPlanets_Blocks.JUPITER_BLOCKS);
        list.add(ExtraPlanets_Blocks.RED_SAND);
        list.add(ExtraPlanets_Blocks.ORANGE_SAND);
        list.add(ExtraPlanets_Blocks.ORANGE_SANDSTONE);
        return list;
    }
}

