/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Mercury.worldgen.dungeon;

import com.mjr.extraplanets.planets.Mercury.worldgen.RoomBossMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.DungeonStartMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.PieceMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.RoomChestMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.RoomSpawner2Mercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.RoomSpawner3Mercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.RoomSpawnerMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.SizedPieceMercury;
import java.lang.reflect.Constructor;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockUnlitTorch;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class CorridorMercury
extends SizedPieceMercury {
    public CorridorMercury() {
    }

    public CorridorMercury(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing direction) {
        super(configuration, sizeX, sizeY, sizeZ, direction);
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(blockPosX, configuration.getYPosition(), blockPosZ, blockPosX + sizeX, configuration.getYPosition() + sizeY, blockPosZ + sizeZ);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        for (int i = 0; i < this.field_74887_e.func_78883_b(); ++i) {
            for (int j = 0; j < this.field_74887_e.func_78882_c(); ++j) {
                for (int k = 0; k < this.field_74887_e.func_78880_d(); ++k) {
                    if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (i == 0 || i == this.field_74887_e.func_78883_b() - 1) || j == 0 || j == this.field_74887_e.func_78882_c() - 1 || this.getDirection().func_176740_k() == EnumFacing.Axis.X && (k == 0 || k == this.field_74887_e.func_78880_d() - 1)) {
                        if (randomIn.nextInt(20) == 1) {
                            this.func_175811_a(worldIn, Blocks.field_189877_df.func_176223_P(), i, j, k, this.field_74887_e);
                            continue;
                        }
                        this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (j == this.field_74887_e.func_78882_c() - 2) {
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (k + 1) % 4 == 0 && (i == 1 || i == this.field_74887_e.func_78883_b() - 2)) {
                            this.func_175811_a(worldIn, GCBlocks.unlitTorch.func_176223_P().func_177226_a((IProperty)BlockUnlitTorch.FACING, (Comparable)(i == 1 ? EnumFacing.WEST.func_176734_d() : EnumFacing.EAST.func_176734_d())), i, j, k, this.field_74887_e);
                            continue;
                        }
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.X && (i + 1) % 4 == 0 && (k == 1 || k == this.field_74887_e.func_78880_d() - 2)) {
                            this.func_175811_a(worldIn, GCBlocks.unlitTorch.func_176223_P().func_177226_a((IProperty)BlockUnlitTorch.FACING, (Comparable)(k == 1 ? EnumFacing.NORTH.func_176734_d() : EnumFacing.SOUTH.func_176734_d())), i, j, k, this.field_74887_e);
                            continue;
                        }
                    }
                    if (randomIn.nextInt(20) == 1) {
                        this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (randomIn.nextInt(10) == 1) {
                        this.func_175811_a(worldIn, Blocks.field_150321_G.func_176223_P(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                }
            }
        }
        return true;
    }

    private <T extends SizedPieceMercury> T getRoom(Class<?> clazz, DungeonStartMercury startPiece, Random rand) {
        try {
            Constructor<?> c0 = clazz.getConstructor(DungeonConfiguration.class, Random.class, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            SizedPieceMercury dummy = (SizedPieceMercury)((Object)c0.newInstance(this.configuration, rand, 0, 0, this.getDirection().func_176734_d()));
            StructureBoundingBox extension = this.getExtension(this.getDirection(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeX() : dummy.getSizeZ(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeZ() : dummy.getSizeX());
            if (startPiece.checkIntersection(extension)) {
                return null;
            }
            int sizeX = extension.field_78893_d - extension.field_78897_a;
            int sizeZ = extension.field_78892_f - extension.field_78896_c;
            int sizeY = dummy.sizeY;
            int blockX = extension.field_78897_a;
            int blockZ = extension.field_78896_c;
            Constructor<?> c1 = clazz.getConstructor(DungeonConfiguration.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            return (T)((Object)((SizedPieceMercury)((Object)c1.newInstance(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d()))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PieceMercury getNextPiece(DungeonStartMercury startPiece, Random rand) {
        int pieceCount = startPiece.attachedComponents.size();
        if (pieceCount > 10 && startPiece.attachedComponents.get(pieceCount - 2) instanceof RoomBossMercury) {
            try {
                return this.getRoom(this.configuration.getTreasureRoom(), startPiece, rand);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            boolean bossRoom;
            int bossRoomChance = Math.max((int)(20.0 / (double)(pieceCount - 10)), 1);
            boolean bl = bossRoom = pieceCount > 25 || pieceCount > 15 && rand.nextInt(bossRoomChance) == 0;
            if (bossRoom) {
                try {
                    return this.getRoom(this.configuration.getBossRoom(), startPiece, rand);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            int randomChoice = rand.nextInt(4);
            int toAdd = randomChoice == 0 || randomChoice == 3 ? 12 : (randomChoice == 2 ? 16 : 6);
            StructureBoundingBox extension = this.getExtension(this.getDirection(), rand.nextInt(4) + toAdd, rand.nextInt(4) + toAdd);
            if (startPiece.checkIntersection(extension)) {
                return null;
            }
            int sizeX = extension.field_78893_d - extension.field_78897_a;
            int sizeZ = extension.field_78892_f - extension.field_78896_c;
            int sizeY = this.configuration.getRoomHeight();
            int blockX = extension.field_78897_a;
            int blockZ = extension.field_78896_c;
            if (Math.abs(startPiece.func_74874_b().field_78892_f - this.field_74887_e.field_78896_c) > 200) {
                return null;
            }
            if (Math.abs(startPiece.func_74874_b().field_78893_d - this.field_74887_e.field_78897_a) > 200) {
                return null;
            }
            switch (randomChoice) {
                case 0: {
                    return new RoomSpawner2Mercury(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
                }
                case 1: {
                    return new RoomChestMercury(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
                }
                case 2: {
                    return new RoomSpawner3Mercury(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
                }
            }
            return new RoomSpawnerMercury(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
        }
        return null;
    }
}

