/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Mercury.worldgen.dungeon;

import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.CorridorMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.DungeonStartMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.dungeon.PieceMercury;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class DirectionalPieceMercury
extends PieceMercury {
    private EnumFacing direction;

    public DirectionalPieceMercury() {
    }

    public DirectionalPieceMercury(DungeonConfiguration configuration, EnumFacing direction) {
        super(configuration);
        this.direction = direction;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("direction", this.direction.ordinal());
    }

    @Override
    protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        super.func_143011_b(nbt, manager);
        this.direction = nbt.func_74764_b("direction") ? EnumFacing.func_82600_a((int)nbt.func_74762_e("direction")) : EnumFacing.NORTH;
    }

    public PieceMercury getCorridor(Random rand, DungeonStartMercury startPiece, int maxAttempts, boolean small) {
        int sizeZ;
        int sizeX;
        int blockZ;
        int blockX;
        EnumFacing randomDir;
        boolean valid;
        int attempts = maxAttempts;
        int randDir = rand.nextInt(3);
        do {
            randomDir = EnumFacing.func_176731_b((int)((this.getDirection().func_176734_d().func_176736_b() + 1 + randDir) % 4));
            StructureBoundingBox extension = this.getExtension(randomDir, this.configuration.getHallwayLengthMin() + rand.nextInt(this.configuration.getHallwayLengthMax() - this.configuration.getHallwayLengthMin()), 3);
            blockX = extension.field_78897_a;
            blockZ = extension.field_78896_c;
            sizeX = extension.field_78893_d - extension.field_78897_a;
            sizeZ = extension.field_78892_f - extension.field_78896_c;
            valid = !startPiece.checkIntersection(extension);
            ++randDir;
        } while (!valid && --attempts > 0);
        if (!valid) {
            return null;
        }
        return new CorridorMercury(this.configuration, rand, blockX, blockZ, sizeX, small ? 3 : this.configuration.getHallwayHeight(), sizeZ, randomDir);
    }
}

