/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.channels.handling;

import java.util.ArrayList;
import java.util.Map;
import sonar.core.utils.Pair;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.api.core.tiles.readers.INetworkReader;
import sonar.logistics.api.core.tiles.readers.channels.IEntityMonitorHandler;
import sonar.logistics.api.core.tiles.readers.channels.INetworkListChannels;
import sonar.logistics.api.core.tiles.readers.channels.INetworkListHandler;
import sonar.logistics.api.core.tiles.readers.channels.ITileMonitorHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.EntityConnection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.channels.NodeConnectionType;
import sonar.logistics.base.utils.CacheType;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;

public abstract class ListNetworkHandler<I extends IInfo, L extends AbstractChangeableList>
implements INetworkListHandler<I, L> {
    Boolean tiles;
    Boolean entities;

    @Override
    public int getReaderID(IListReader reader) {
        return 0;
    }

    @Override
    public InfoUUID getReaderUUID(IListReader reader) {
        return new InfoUUID(reader.getIdentity(), this.getReaderID(reader));
    }

    public AbstractChangeableList<I> getUUIDLatestList(InfoUUID uuid) {
        return ServerInfoHandler.instance().getChangeableListMap().getOrDefault(uuid, (AbstractChangeableList)this.newChangeableList());
    }

    public boolean canHandleTiles() {
        if (this.tiles == null) {
            this.tiles = this instanceof ITileMonitorHandler;
        }
        return this.tiles;
    }

    public boolean canHandleEntities() {
        if (this.entities == null) {
            this.entities = this instanceof IEntityMonitorHandler;
        }
        return this.entities;
    }

    public boolean canHandle(NodeConnection connection) {
        NodeConnectionType type = connection.getType();
        switch (type) {
            case ENTITY: {
                return this.canHandleEntities();
            }
            case TILE: {
                return this.canHandleTiles();
            }
        }
        return false;
    }

    @Override
    public Map<NodeConnection, L> getAllChannels(Map<NodeConnection, L> list, ILogisticsNetwork network) {
        for (NodeConnection connection : network.getConnections(CacheType.ALL)) {
            if (!network.validateTile(connection.source) || !this.canHandle(connection) || list.containsKey(connection)) continue;
            list.put(connection, this.newChangeableList());
        }
        return list;
    }

    @Override
    public L updateConnection(INetworkListChannels channels, L newList, NodeConnection c) {
        EntityConnection connection;
        if (c instanceof BlockConnection) {
            BlockConnection connection2 = (BlockConnection)c;
            if (channels.isCoordsMonitored(connection2)) {
                ((AbstractChangeableList)newList).saveStates();
                return ((ITileMonitorHandler)((Object)this)).updateInfo(channels, newList, connection2);
            }
        } else if (c instanceof EntityConnection && channels.isEntityMonitored(connection = (EntityConnection)c)) {
            ((AbstractChangeableList)newList).saveStates();
            return ((IEntityMonitorHandler)((Object)this)).updateInfo(channels, newList, connection);
        }
        return newList;
    }

    @Override
    public Pair<InfoUUID, AbstractChangeableList<I>> updateAndSendList(ILogisticsNetwork network, IListReader<I> reader, Map<NodeConnection, AbstractChangeableList<I>> channelLists, boolean send) {
        InfoUUID uuid = this.getReaderUUID(reader);
        if (network.validateTile(reader)) {
            ArrayList<NodeConnection> usedChannels = new ArrayList<NodeConnection>();
            AbstractChangeableList<I> updateList = this.getUUIDLatestList(uuid);
            updateList.saveStates();
            AbstractChangeableList<I> viewableList = reader.getViewableList(updateList, uuid, channelLists, usedChannels);
            if (reader instanceof INetworkReader) {
                ((INetworkReader)reader).setMonitoredInfo(updateList, usedChannels, uuid);
            }
            ServerInfoHandler.instance().getChangeableListMap().put(uuid, updateList);
            if (send && (!updateList.wasLastListNull || updateList.wasLastListNull != updateList.getList().isEmpty())) {
                InfoPacketHelper.sendReaderToListeners(reader, updateList, uuid);
            }
            return new Pair((Object)uuid, updateList);
        }
        return new Pair((Object)uuid, this.newChangeableList());
    }
}

