/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.guide;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.FontHelper;
import sonar.logistics.PL2Translate;
import sonar.logistics.base.gui.GuiSelectionList;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.base.gui.buttons.LogisticsButton;
import sonar.logistics.core.items.guide.ContainerGuide;
import sonar.logistics.core.items.guide.GuidePageRegistry;
import sonar.logistics.core.items.guide.pages.elements.Element3DRenderer;
import sonar.logistics.core.items.guide.pages.pages.IGuidePage;

public class GuiGuide
extends GuiSelectionList<IGuidePage> {
    public static IGuidePage currentPage;
    public static int pagePos;
    public static int currentPos;
    public int lastPos = -1;
    public int lastPagePos = -1;
    private SonarTextField searchField;
    public boolean updateSearchList;
    public int coolDown = 0;

    public GuiGuide(EntityPlayer player) {
        super(new ContainerGuide(player), null);
        this.listHeight = 20;
        this.listWidth = 330;
        this.field_146999_f = 350;
        this.field_147000_g = 250;
    }

    @Override
    public double listScale() {
        return 1.0;
    }

    @Override
    public void func_73866_w_() {
        this.coolDown = 25;
        this.enableListRendering = currentPage == null;
        super.func_73866_w_();
        if (this.scroller != null) {
            this.scroller.renderScroller = this.enableListRendering;
        }
        if (currentPage != null) {
            currentPage.initGui(this, pagePos);
            this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 0, this.field_147003_i + 6, this.field_147009_r + 3, 488, 0, 16, 11, PL2Translate.BUTTON_BACK.t(), ""));
            this.field_146292_n.add(new GuiButton(-1, this.field_147003_i + 6, this.field_147009_r + this.field_147000_g - 26, 20, 20, "<<"));
            this.field_146292_n.add(new GuiButton(-2, this.field_147003_i + this.field_146999_f - 26, this.field_147009_r + this.field_147000_g - 26, 20, 20, ">>"));
            this.field_146292_n.add(new GuiButton(-3, this.field_147003_i + 26, this.field_147009_r + this.field_147000_g - 26, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(-4, this.field_147003_i + this.field_146999_f - 26 - 20, this.field_147009_r + this.field_147000_g - 26, 20, 20, ">"));
        } else {
            this.infoList = GuidePageRegistry.pages;
            Keyboard.enableRepeatEvents((boolean)true);
            this.searchField = new SonarTextField(0, this.field_146289_q, 50, 17, 240, 10);
            this.searchField.func_146203_f(20);
            this.searchField.func_146180_a("");
            this.fieldList.add(this.searchField);
        }
        this.updateSearchList();
    }

    public void onTextFieldChanged(SonarTextField field) {
        if (field == this.searchField) {
            this.updateSearchList = true;
        }
    }

    public void updateSearchList() {
        String search = this.searchField == null ? "" : this.searchField.func_146179_b();
        ArrayList<IGuidePage> searchList = new ArrayList<IGuidePage>();
        for (IGuidePage page : GuidePageRegistry.pages) {
            if (page == null || !page.getDisplayName().toLowerCase().contains(search.toLowerCase())) continue;
            searchList.add(page);
        }
        this.infoList = searchList;
    }

    public void setCurrentPage(int pageID, int newPos) {
        if (currentPage == null || currentPage.pageID() != pageID) {
            this.lastPos = currentPage == null ? -1 : currentPage.pageID();
            int n = this.lastPagePos = currentPage == null ? -1 : pagePos;
            if (this.searchField != null) {
                this.searchField.func_146180_a("");
            }
            this.infoList = GuidePageRegistry.pages;
            for (int i = 0; i < this.infoList.size(); ++i) {
                IGuidePage listPage = (IGuidePage)this.infoList.get(i);
                if (listPage.pageID() != pageID) continue;
                currentPos = i;
                currentPage = (IGuidePage)this.infoList.get(currentPos);
                pagePos = newPos;
                this.reset();
                break;
            }
        }
    }

    public void resetLastPos() {
        this.lastPos = -1;
        this.lastPagePos = -1;
    }

    public void updatePage() {
        currentPage = (IGuidePage)this.infoList.get(currentPos);
        pagePos = 0;
        this.resetLastPos();
        this.reset();
        Element3DRenderer.reset();
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (currentPage != null) {
            this.buttonAction(button.field_146127_k);
        }
    }

    public void buttonAction(int buttonID) {
        switch (buttonID) {
            case 0: {
                if (this.lastPos != -1) {
                    this.setCurrentPage(this.lastPos, this.lastPagePos);
                    this.lastPos = -1;
                    this.lastPagePos = -1;
                    return;
                }
                if (currentPage != null) {
                    currentPage = null;
                    this.reset();
                    break;
                }
                Element3DRenderer.reset();
                this.field_146297_k.field_71439_g.func_71053_j();
                break;
            }
            case -1: {
                if (currentPos - 1 >= 0) {
                    --currentPos;
                    this.updatePage();
                    break;
                }
                currentPos = this.infoList.size() - 1;
                this.updatePage();
                break;
            }
            case -2: {
                if (currentPos + 1 < this.infoList.size()) {
                    ++currentPos;
                    this.updatePage();
                    break;
                }
                currentPos = 0;
                this.updatePage();
                break;
            }
            case -3: {
                pagePos = pagePos - 1 >= 0 ? --pagePos : currentPage.getPageCount() - 1;
                this.reset();
                Element3DRenderer.reset();
                break;
            }
            case -4: {
                pagePos = pagePos + 1 < currentPage.getPageCount() ? ++pagePos : 0;
                this.reset();
                Element3DRenderer.reset();
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (currentPage != null) {
            currentPage.drawPage(this, mouseX, mouseY, pagePos);
        }
    }

    @Override
    public void func_146979_b(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (currentPage != null) {
            FontHelper.textCentre((String)currentPage.getDisplayName(), (int)this.field_146999_f, (int)6, (int)-1);
            currentPage.drawForegroundPage(this, x, y, pagePos, 0.0f);
            FontHelper.textCentre((String)("Sub Page: " + (pagePos + 1) + "/" + currentPage.getPageCount()), (int)this.field_146999_f, (int)(this.field_147000_g - 26), (int)-1);
            FontHelper.textCentre((String)("Page: " + (currentPos + 1) + "/" + this.infoList.size()), (int)this.field_146999_f, (int)(this.field_147000_g - 16), (int)-1);
        } else {
            FontHelper.text((String)"Search: ", (int)8, (int)18, (int)-1);
            FontHelper.textCentre((String)PL2Translate.GUIDE_TITLE.t(), (int)this.field_146999_f, (int)6, (int)-1);
        }
        if (this.coolDown != 0) {
            --this.coolDown;
        }
        super.func_146979_b(x, y);
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        if (currentPage != null) {
            currentPage.drawBackgroundPage(this, var2, var3, pagePos);
        }
    }

    @Override
    public void renderInfo(IGuidePage info, int yPos) {
        info.drawPageInGui(this, yPos);
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, IGuidePage info) {
        currentPage = info;
        pagePos = 0;
        currentPos = infoPos;
        this.reset();
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (currentPage != null && this.coolDown == 0) {
            currentPage.mouseClicked(this, x, y, button);
        }
    }

    @Override
    public void setInfo() {
        if (this.updateSearchList) {
            this.updateSearchList();
        }
    }

    @Override
    public int getColour(int i, int type) {
        return PL2Colours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isPairedInfo(IGuidePage info) {
        return false;
    }

    @Override
    public boolean isSelectedInfo(IGuidePage info) {
        return false;
    }

    @Override
    public boolean isCategoryHeader(IGuidePage info) {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 203) {
            if (pagePos == 0) {
                this.buttonAction(-1);
                pagePos = currentPage.getPageCount() - 1;
                this.reset();
            } else {
                this.buttonAction(-3);
            }
            return;
        }
        if (keyCode == 205) {
            if (pagePos == currentPage.getPageCount() - 1) {
                this.buttonAction(-2);
            } else {
                this.buttonAction(-4);
            }
            return;
        }
        Element3DRenderer.reset();
        if ((keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) && currentPage != null) {
            if (this.lastPos == -1 || this.lastPagePos == -1) {
                currentPage = null;
                this.reset();
                return;
            }
            this.setCurrentPage(this.lastPos, this.lastPagePos);
            this.resetLastPos();
            this.reset();
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    static {
        currentPos = -1;
    }
}

