/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.transceiver;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.logistics.api.core.tiles.wireless.transceivers.IEntityTransceiver;

public class ItemWirelessEntityTransceiver
extends SonarItem
implements IEntityTransceiver {
    @Override
    public UUID getEntityUUID(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_186857_a("uuid");
        }
        return null;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.onRightClickEntity(player, stack, (Entity)player, hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public ItemStack onRightClickEntity(EntityPlayer player, ItemStack stack, Entity entity, EnumHand hand) {
        if (entity != null) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_186854_a("uuid", entity.getPersistentID());
            tag.func_74778_a("targetName", entity.func_145748_c_().func_150260_c());
            FontHelper.sendMessage((String)(stack.func_77942_o() ? "Overwritten Entity" : "Saved Entity"), (World)player.func_130014_f_(), (EntityPlayer)player);
            stack.func_77982_d(tag);
            player.func_184611_a(hand, stack);
        }
        return stack;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!player.func_70093_af() && !player.func_130014_f_().field_72995_K) {
            stack = this.onRightClickEntity(player, stack, (Entity)target, hand);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(stack, world, list, par4);
        list.add(TextFormatting.RED + "THE ENTITY SYSTEM IS CURRENTLY BROKEN");
        if (stack.func_77942_o()) {
            list.add("Entity: " + TextFormatting.ITALIC + FontHelper.translate((String)stack.func_77978_p().func_74779_i("targetName")));
        }
    }
}

