/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.base;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.handlers.inventories.ItemStackHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.PL2;
import sonar.logistics.PL2Logging;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.core.items.operator.IOperatorProvider;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.channels.PacketChannels;
import sonar.logistics.base.events.LogisticsEventHandler;
import sonar.logistics.base.events.types.NetworkPartEvent;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.base.utils.CacheType;
import sonar.logistics.base.utils.PL2AdditionType;
import sonar.logistics.base.utils.PL2RemovalType;
import sonar.logistics.core.tiles.base.BlockLogistics;
import sonar.logistics.core.tiles.connections.data.network.EmptyLogisticsNetwork;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredBlockCoords;
import sonar.logistics.core.tiles.displays.info.types.general.InfoChangeableList;
import sonar.logistics.core.tiles.readers.info.TileInfoReader;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;
import sonar.logistics.network.sync.SyncTileMessages;

public abstract class TileLogistics
extends TileSonarMultipart
implements INetworkTile,
IOperatorProvider {
    public int identity = -1;
    public static final ErrorMessage[] defaultValidStates = new ErrorMessage[]{ErrorMessage.NO_NETWORK};
    public ILogisticsNetwork network = EmptyLogisticsNetwork.INSTANCE;
    public SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(0).setDefault((Object)-1);
    public SyncTileMessages states = new SyncTileMessages(this, 101);
    private boolean PART_ADDED;

    public TileLogistics() {
        this.syncList.addParts(new IDirtyPart[]{this.networkID, this.states});
        this.states.markAllMessages(true);
        this.PART_ADDED = false;
    }

    public abstract EnumFacing getCableFace();

    @Override
    public PL2Multiparts getMultipart() {
        if (this.func_145838_q() instanceof BlockLogistics) {
            return ((BlockLogistics)this.func_145838_q()).getMultipart();
        }
        return null;
    }

    public void sendNetworkCoordMap(EntityPlayer player) {
        if (this.isClient() || !this.network.isValid() || this.getNetworkID() == -1) {
            return;
        }
        InfoChangeableList<MonitoredBlockCoords> coords = this.network.createConnectionsList(CacheType.ALL);
        NBTTagCompound coordTag = InfoHelper.writeMonitoredList(new NBTTagCompound(), coords, NBTHelper.SyncType.DEFAULT_SYNC);
        if (!coordTag.func_82582_d()) {
            PL2.network.sendTo((IMessage)new PacketChannels(this.getNetworkID(), coordTag), (EntityPlayerMP)player);
        }
    }

    @Override
    public int getIdentity() {
        if (this.identity == -1 && this.isServer()) {
            this.identity = ServerInfoHandler.instance().getNextIdentity();
            this.func_70296_d();
        }
        return this.identity;
    }

    @Override
    public ItemStack getDisplayStack() {
        return ItemStackHelper.getBlockItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
    }

    public boolean isValid() {
        return !this.field_145846_f;
    }

    public void doAdditionEvent(PL2AdditionType type) {
        if (!this.func_145831_w().field_72995_K) {
            LogisticsEventHandler.instance().queueNetworkAddition(this, type);
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new NetworkPartEvent.AddedPart(this, this.getActualWorld(), type));
        }
    }

    public void doRemovalEvent(PL2RemovalType type) {
        if (!this.func_145831_w().field_72995_K) {
            LogisticsEventHandler.instance().queueNetworkRemoval(this, type);
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new NetworkPartEvent.RemovedPart(this, this.getActualWorld(), type));
        }
    }

    public void doChunkLoadEvent() {
        if (!this.PART_ADDED) {
            this.doAdditionEvent(PL2AdditionType.CHUNK_LOADED);
            this.PART_ADDED = true;
        }
    }

    public void doChunkUnloadEvent() {
        if (this.PART_ADDED) {
            this.doRemovalEvent(PL2RemovalType.CHUNK_UNLOADED);
            this.PART_ADDED = false;
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.isServer()) {
            this.doChunkLoadEvent();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getIdentity() != -1) {
            this.doChunkUnloadEvent();
        }
        if (this instanceof ILogicListenable) {
            ((ILogicListenable)((Object)this)).getListenerList().invalidateList();
        }
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        if (this.isClient()) {
            this.doChunkLoadEvent();
        }
    }

    @Override
    public final void onNetworkConnect(ILogisticsNetwork network) {
        if (!this.network.isValid() || ((Integer)this.networkID.getObject()).intValue() != network.getNetworkID()) {
            this.network = network;
            this.networkID.setObject((Object)network.getNetworkID());
            this.states.markTileMessage(ErrorMessage.NO_NETWORK, false);
        }
    }

    @Override
    public final void onNetworkDisconnect(ILogisticsNetwork network) {
        if (((Integer)this.networkID.getObject()).intValue() == network.getNetworkID()) {
            this.network = EmptyLogisticsNetwork.INSTANCE;
            this.networkID.setObject((Object)-1);
            this.states.markTileMessage(ErrorMessage.NO_NETWORK, true);
        } else if ((Integer)this.networkID.getObject() != -1) {
            PL2Logging.disconnectFromWrongDataNetwork(this, this.getNetwork(), network);
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.identity = nbt.func_74762_e("identity");
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74768_a("identity", this.getIdentity());
        return super.writeData(nbt, type);
    }

    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
    }

    public void onListenerRemoved(ListenerTally<PlayerListener> tally) {
    }

    public void onSubListenableAdded(ISonarListenable<PlayerListener> listen) {
    }

    public void onSubListenableRemoved(ISonarListenable<PlayerListener> listen) {
    }

    @Override
    public ILogisticsNetwork getNetwork() {
        return this.network;
    }

    @Override
    public int getNetworkID() {
        return (Integer)this.networkID.getObject();
    }

    @Override
    public void updateOperatorInfo() {
        this.requestSyncPacket();
    }

    @Override
    public void addInfo(List<String> info) {
        PL2Multiparts multipart = this.getMultipart();
        if (multipart != null) {
            info.add(TextFormatting.UNDERLINE + multipart.getDisplayName());
        }
        info.add("Network ID: " + this.networkID.getObject());
        info.add("Has channels: " + (this instanceof TileInfoReader));
        info.add("IDENTITY: " + this.getIdentity());
    }

    @Override
    public ErrorMessage[] getValidMessages() {
        return defaultValidStates;
    }
}

