/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.data.tiles;

import java.util.ArrayList;
import java.util.List;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RayTraceHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.utils.LabelledAxisAlignedBB;
import sonar.core.utils.Pair;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.core.items.operator.IOperatorProvider;
import sonar.logistics.api.core.items.operator.IOperatorTile;
import sonar.logistics.api.core.items.operator.OperatorMode;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.connections.data.IDataCable;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.base.events.LogisticsEventHandler;
import sonar.logistics.base.utils.PL2AdditionType;
import sonar.logistics.base.utils.PL2RemovalType;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHandler;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHelper;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetworkHandler;
import sonar.logistics.core.tiles.connections.data.tiles.BlockDataCable;

public class TileDataCable
extends TileSonarMultipart
implements IDataCable,
IOperatorTile,
IOperatorProvider {
    public int[] isBlocked = new int[6];
    public int[] isConnected = new int[6];
    public SyncTagType.INT registryID = (SyncTagType.INT)new SyncTagType.INT(0).setDefault((Object)-1);

    public TileDataCable() {
        this.syncList.addPart((IDirtyPart)this.registryID);
    }

    @Override
    public ILogisticsNetwork getNetwork() {
        return LogisticsNetworkHandler.instance().getNetwork((Integer)this.registryID.getObject());
    }

    public final void onFirstTick() {
        super.onFirstTick();
        LogisticsEventHandler.instance().queueNetworkAddition(this, PL2AdditionType.PLAYER_ADDED);
    }

    public final void func_145843_s() {
        super.func_145843_s();
        LogisticsEventHandler.instance().queueNetworkRemoval(this, PL2RemovalType.PLAYER_REMOVED);
    }

    @Override
    public void updateCableRenders() {
        if (this.isServer()) {
            SonarMultipartHelper.sendMultipartUpdateSyncAround((TileSonarMultipart)this, (int)128);
        }
    }

    public EnumCableRenderSize getRenderType(EnumFacing face) {
        return EnumCableRenderSize.values()[this.isConnected[face.ordinal()]];
    }

    @Override
    public EnumCableConnectionType canRenderConnection(EnumFacing dir) {
        return CableConnectionHelper.getConnectableType(this, dir);
    }

    @Override
    public boolean isBlocked(EnumFacing dir) {
        return this.isBlocked[dir.ordinal()] == 1;
    }

    public void invertBlock(EnumFacing dir) {
        this.isBlocked[dir.ordinal()] = this.isBlocked[dir.ordinal()] == 1 ? 0 : 1;
    }

    public boolean isInternallyBlocked(EnumFacing dir) {
        return this.info != null && dir != null && this.info.getContainer().getPart((IPartSlot)EnumFaceSlot.fromFace((EnumFacing)dir)).isPresent();
    }

    @Override
    public EnumCableConnection canConnect(int registryID, EnumCableConnectionType type, EnumFacing dir, boolean internal) {
        if (type != this.getConnectableType()) {
            return EnumCableConnection.NONE;
        }
        boolean internallyBlocked = this.isInternallyBlocked(dir);
        if (this.isBlocked(dir) || !internal && internallyBlocked) {
            return EnumCableConnection.NONE;
        }
        return EnumCableConnection.NETWORK;
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return EnumCableRenderSize.CABLE;
    }

    @Override
    public int getRegistryID() {
        return (Integer)this.registryID.getObject();
    }

    @Override
    public void setRegistryID(int id) {
        if ((Integer)this.registryID.getObject() != id) {
            this.registryID.setObject((Object)id);
        }
    }

    @Override
    public EnumCableConnectionType getConnectableType() {
        return EnumCableConnectionType.CONNECTABLE;
    }

    @Override
    public void updateOperatorInfo() {
        this.requestSyncPacket();
    }

    @Override
    public void addInfo(List<String> info) {
        info.add(TextFormatting.UNDERLINE + PL2Multiparts.DATA_CABLE.getDisplayName());
        info.add("Network ID: " + this.registryID.getObject());
    }

    @Override
    public boolean performOperation(RayTraceResult rayTrace, OperatorMode mode, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Pair look;
        Pair trace;
        if (mode == OperatorMode.DEFAULT && (trace = RayTraceHelper.rayTraceBoxes((BlockPos)this.field_174879_c, (Vec3d)((Vec3d)(look = RayTraceHelper.getPlayerLookVec((EntityPlayer)player)).getLeft()), (Vec3d)((Vec3d)look.getRight()), BlockDataCable.getSelectionBoxes(this.field_145850_b, this.field_174879_c, new ArrayList<AxisAlignedBB>()))) != null && trace.b instanceof LabelledAxisAlignedBB) {
            if (this.isClient()) {
                return true;
            }
            String label = ((LabelledAxisAlignedBB)trace.b).label;
            EnumFacing face = null;
            face = !label.equals("c") ? EnumFacing.valueOf((String)label.toUpperCase()) : facing;
            TileDataCable adjCable = CableConnectionHelper.getCable((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(face));
            if (adjCable != null) {
                CableConnectionHandler.instance().removeConnection(this);
                CableConnectionHandler.instance().removeConnection(adjCable);
                this.invertBlock(face);
                adjCable.isBlocked[face.func_176734_d().ordinal()] = this.isBlocked[face.ordinal()];
                CableConnectionHandler.instance().addConnection(adjCable);
                CableConnectionHandler.instance().addConnection(this);
                ILogisticsNetwork thisNet = LogisticsNetworkHandler.instance().getOrCreateNetwork(this.getRegistryID());
                ILogisticsNetwork adjNetNet = LogisticsNetworkHandler.instance().getOrCreateNetwork(adjCable.getRegistryID());
                SonarMultipartHelper.sendMultipartUpdateSyncAround((TileSonarMultipart)this, (int)128);
                SonarMultipartHelper.sendMultipartUpdateSyncAround((TileSonarMultipart)adjCable, (int)128);
            }
            return true;
        }
        return false;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.isBlocked = nbt.func_74759_k("isBlocked");
        this.isConnected = nbt.func_74759_k("isConnected");
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = new NBTTagCompound();
        nbt.func_74783_a("isBlocked", this.isBlocked);
        nbt.func_74783_a("isConnected", this.isConnected);
        return super.writeData(nbt, type);
    }
}

