/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.Tuple;
import sonar.core.handlers.inventories.containers.ContainerMultipartSync;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.utils.CustomColour;
import sonar.logistics.base.gui.GuiLogistics;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.GSIInteractionHelper;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.types.text.gui.GuiStyledStringFunctions;
import sonar.logistics.core.tiles.displays.info.types.text.gui.hotkeys.GuiActions;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public abstract class GuiAbstractEditScreen
extends GuiLogistics {
    public DisplayGSI gsi;
    public double userScaling = 1.0;
    public double percentageFill = 1.0;
    public double actualLeft;
    public double actualTop;
    public double actualElementScale;
    public double actualElementWidth;
    public double actualElementHeight;
    public double[] scaling = new double[]{0.0, 0.0, 0.0};
    public long field_146997_J;
    public TileAbstractDisplay display;

    public GuiAbstractEditScreen(DisplayGSI gsi, TileAbstractDisplay display) {
        super((Container)new ContainerMultipartSync((TileSonarMultipart)display), gsi.getDisplay());
        this.display = display;
        this.gsi = gsi;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.setContainerScaling();
    }

    public abstract double[] getUnscaled();

    public abstract void renderDisplayScreen(float var1, int var2, int var3);

    public abstract boolean doDisplayScreenClick(double var1, double var3, int var5);

    public void setContainerScaling() {
        this.scaling = new double[]{this.field_146999_f - 8, this.field_147000_g / 2 - 8, 1.0};
        double[] unscaled = this.getUnscaled();
        this.actualLeft = this.field_147003_i + 4;
        this.actualTop = this.field_147009_r + 4;
        this.actualElementScale = Math.min(this.scaling[0] / unscaled[0], this.scaling[1] / unscaled[1]);
        this.actualElementWidth = unscaled[0] * this.actualElementScale * this.percentageFill;
        this.actualElementHeight = unscaled[1] * this.actualElementScale * this.percentageFill;
        this.gsi.updateScaling();
        if (this instanceof GuiStyledStringFunctions) {
            GuiActions.UPDATE_TEXT_SCALING.trigger((GuiStyledStringFunctions)this);
        }
    }

    @Override
    public void func_146976_a(float partialTicks, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiAbstractEditScreen.drawTransparentRect((int)this.field_147003_i, (int)(this.field_147009_r + this.field_146999_f / 2 + 20), (int)(this.field_147003_i + this.field_146999_f), (int)(this.field_147009_r + this.field_146999_f / 2 + 20 + 80), (int)PL2Colours.layers[1].getRGB());
        GuiAbstractEditScreen.drawTransparentRect((int)(this.field_147003_i + 1), (int)(this.field_147009_r + 1 + this.field_146999_f / 2 + 20), (int)(this.field_147003_i + this.field_146999_f - 1), (int)(this.field_147009_r + this.field_146999_f / 2 + 20 + 80 - 1), (int)PL2Colours.layers[2].getRGB());
        double pixel = 0.625;
        double[] actualScaling = this.getActualScaling();
        GlStateManager.func_179094_E();
        DisplayElementHelper.align(this.getAlignmentTranslation());
        DisplayElementHelper.drawRect(-pixel, -pixel, actualScaling[0] + pixel, actualScaling[1] + pixel, new CustomColour(174, 227, 227).getRGB());
        DisplayElementHelper.drawRect(0.0, 0.0, actualScaling[0], actualScaling[1], new CustomColour(40, 40, 40).getRGB());
        GlStateManager.func_179139_a((double)actualScaling[2], (double)actualScaling[2], (double)actualScaling[2]);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
        this.renderDisplayScreen(partialTicks, x, y);
        GlStateManager.func_179121_F();
    }

    public final double[] getAlignmentTranslation() {
        double x = this.actualLeft + (this.scaling[0] - this.actualElementWidth) / 2.0 + (1.0 - this.userScaling) * this.actualElementWidth / 2.0;
        double y = this.actualTop + (this.scaling[1] - this.actualElementHeight) / 2.0 + (1.0 - this.userScaling) * this.actualElementHeight / 2.0;
        double z = 0.001;
        return new double[]{x, y, z};
    }

    public final double[] getActualScaling() {
        return new double[]{this.actualElementWidth * this.userScaling, this.actualElementHeight * this.userScaling, this.actualElementScale * this.userScaling};
    }

    public boolean skipContainerClick() {
        return false;
    }

    public void func_73864_a(int x, int y, int key) throws IOException {
        Tuple<Boolean, double[]> canClick = this.canClickContainer(x, y);
        if (this.skipContainerClick() || !((Boolean)canClick.func_76341_a()).booleanValue() || !this.doDisplayScreenClick(((double[])canClick.func_76340_b())[0], ((double[])canClick.func_76340_b())[1], key)) {
            super.func_73864_a(x, y, key);
        }
    }

    public final Tuple<Boolean, double[]> canClickContainer(int x, int y) {
        double startX = this.getAlignmentTranslation()[0];
        double startY = this.getAlignmentTranslation()[1];
        double endX = startX + this.getActualScaling()[0];
        double endY = startY + this.getActualScaling()[1];
        if (GSIInteractionHelper.checkClick(x, y, new double[]{startX, startY, endX, endY})) {
            double clickX = ((double)x - startX) / this.getActualScaling()[2];
            double clickY = ((double)y - startY) / this.getActualScaling()[2];
            return new Tuple((Object)true, (Object)new double[]{clickX, clickY});
        }
        return new Tuple((Object)false, (Object)new double[2]);
    }

    public final boolean isDoubleClick() {
        boolean isDoubleClick = false;
        if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - this.field_146997_J < 5L) {
            isDoubleClick = true;
        }
        this.field_146997_J = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        return isDoubleClick;
    }
}

