/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.storage;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.GSIInteractionHelper;
import sonar.logistics.core.tiles.displays.gsi.storage.ElementStorage;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.HeightAlignment;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayRenderable;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.elements.base.IInfoReferenceElement;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;

public class DisplayElementContainer
implements IElementStorageHolder,
INBTSyncable {
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    public static final int SCALE = 2;
    public ElementStorage elements = new ElementStorage(this);
    public double[] createdTranslation = new double[]{0.0, 0.0, 0.0};
    public double[] createdScaling = new double[]{0.0, 0.0, 0.0};
    public boolean locked = false;
    public double[] translation;
    private double[] actualContainerScaling;
    private double[] maxContainerScaling;
    private double[] maxElementScaling;
    public double percentageScale;
    protected int defaultColour = -1;
    public int containerIdentity;
    public DisplayGSI gsi;
    public boolean isWithinScreenBounds;

    public DisplayElementContainer() {
    }

    public DisplayElementContainer(DisplayGSI gsi, double xPos, double yPos, double zPos, double width, double height, double pScale, int identity) {
        this.gsi = gsi;
        this.resize(new double[]{xPos, yPos, zPos}, new double[]{width, height, 1.0}, pScale);
        this.percentageScale = pScale;
        this.containerIdentity = identity;
    }

    public DisplayElementContainer(DisplayGSI gsi, double[] translate, double[] scale, double pScale, int identity) {
        this.gsi = gsi;
        this.resize(translate, scale, pScale);
        this.containerIdentity = identity;
    }

    public DisplayElementContainer(double[] translate, double[] scale, double pScale, int identity, double[] display_scaling) {
        this.createdTranslation = DisplayElementHelper.percentageFromScale(translate, display_scaling);
        this.createdScaling = DisplayElementHelper.percentageFromScale(scale, display_scaling);
        this.percentageScale = pScale;
        this.translation = null;
        this.maxElementScaling = null;
        this.maxElementScaling = null;
        this.containerIdentity = identity;
    }

    public void resize(double[] translate, double[] scale, double pScale) {
        this.createdTranslation = DisplayElementHelper.percentageFromScale(translate, this.gsi.getDisplayScaling());
        this.createdScaling = DisplayElementHelper.percentageFromScale(scale, this.gsi.getDisplayScaling());
        this.percentageScale = pScale;
        this.translation = null;
        this.maxElementScaling = null;
        this.maxElementScaling = null;
    }

    public DisplayGSI getGSI() {
        return this.gsi;
    }

    public boolean canRender() {
        return this.isWithinScreenBounds && this.gsi.mode.renderElements();
    }

    public void render() {
        if (this.canRender()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)this.getTranslation()[0], (double)this.getTranslation()[1], (double)this.getTranslation()[2]);
            this.elements.forEach(IDisplayRenderable::updateRender);
            DisplayElementHelper.align(this.getAlignmentTranslation());
            DisplayElementHelper.renderElementStorageHolder(this);
            if (!this.gsi.isEditContainer(this)) {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.02);
                if (this.gsi.mode == this.gsi.selection_mode && this.gsi.selection_mode.selected_identities.contains(this.getContainerIdentity())) {
                    DisplayElementHelper.drawRect(0.0, 0.0, this.getContainerMaxScaling()[0], this.getContainerMaxScaling()[1], this.gsi.selection_mode.selectionType.getTypeColour());
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void startElementRender(IDisplayElement e) {
    }

    @Override
    public void endElementRender(IDisplayElement e) {
    }

    public List<InfoUUID> getInfoReferences() {
        ArrayList<InfoUUID> holders = new ArrayList<InfoUUID>();
        for (IDisplayElement s : this.elements) {
            if (!(s instanceof IInfoReferenceElement)) continue;
            ListHelper.addWithCheck(holders, ((IInfoReferenceElement)s).getInfoReferences());
        }
        return holders;
    }

    @Override
    public Tuple<IDisplayElement, double[]> getClickBoxes(double x, double y) {
        return this.getClickBoxes(this.getAlignmentTranslation(), x, y);
    }

    public Tuple<IDisplayElement, double[]> getClickBoxes(double[] align, double x, double y) {
        for (IDisplayElement e : this.elements) {
            if (e instanceof IElementStorageHolder) continue;
            double[] alignArray = this.getAlignmentTranslation(e);
            double startX = align[0] + alignArray[0];
            double startY = align[1] + alignArray[1];
            double endX = align[0] + alignArray[0] + e.getActualScaling()[0];
            double endY = align[1] + alignArray[1] + e.getActualScaling()[1];
            double[] eBox = new double[]{startX, startY, endX, endY};
            if (!GSIInteractionHelper.checkClick(x, y, eBox)) continue;
            double subClickX = x - startX;
            double subClickY = y - startY;
            return new Tuple((Object)e, (Object)new double[]{subClickX, subClickY});
        }
        for (IElementStorageHolder h : this.elements.getSubHolders()) {
            Tuple<IDisplayElement, double[]> clicked = h.getClickBoxes(x, y);
            if (clicked == null) continue;
            return clicked;
        }
        return null;
    }

    @Override
    public void updateActualScaling() {
        this.translation = null;
        this.maxContainerScaling = null;
        this.maxElementScaling = null;
        this.elements.forEach(e -> {
            if (e instanceof IElementStorageHolder) {
                ((IElementStorageHolder)((Object)e)).updateActualScaling();
            } else {
                e.onElementChanged();
            }
        });
        double[] listScaling = new double[3];
        for (IDisplayElement e2 : this.elements) {
            double[] scaling = e2.getActualScaling();
            for (int i = 0; i < 3; ++i) {
                double lValue = listScaling[i];
                double eValue = scaling[i];
                if (!(lValue < eValue)) continue;
                listScaling[i] = eValue;
            }
        }
        this.actualContainerScaling = listScaling;
        if (this.locked) {
            double endX = this.getTranslation()[0] + this.getActualScaling()[0];
            double endY = this.getTranslation()[1] + this.getActualScaling()[1];
            this.isWithinScreenBounds = endX <= this.gsi.getDisplayScaling()[0] && endY <= this.gsi.getDisplayScaling()[1];
        } else {
            this.isWithinScreenBounds = true;
        }
    }

    public boolean canClickContainer(double x, double y) {
        double startX = this.getTranslation()[0];
        double startY = this.getTranslation()[1];
        double endX = this.getTranslation()[0] + this.getContainerMaxScaling()[0];
        double endY = this.getTranslation()[1] + this.getContainerMaxScaling()[1];
        return GSIInteractionHelper.checkClick(x, y, new double[]{startX, startY, endX, endY});
    }

    public Tuple<IDisplayElement, double[]> getElementFromXY(double x, double y) {
        double offsetX = x - this.getTranslation()[0];
        double offsetY = y - this.getTranslation()[1];
        return this.getClickBoxes(offsetX, offsetY);
    }

    @Override
    public DisplayElementContainer getContainer() {
        return this;
    }

    public double[] getTranslation() {
        if (this.translation == null) {
            this.translation = this.locked ? this.createdTranslation : DisplayElementHelper.scaleFromPercentage(this.createdTranslation, this.gsi.getDisplayScaling());
        }
        return this.translation;
    }

    @Override
    public double[] getMaxScaling() {
        if (this.maxElementScaling == null) {
            this.maxElementScaling = DisplayElementHelper.scaleArray(this.getContainerMaxScaling(), this.percentageScale);
            this.maxElementScaling[2] = 1.0;
        }
        return this.maxElementScaling;
    }

    public double[] getContainerMaxScaling() {
        if (this.maxContainerScaling == null) {
            this.maxContainerScaling = this.locked ? this.createdScaling : DisplayElementHelper.scaleFromPercentage(this.createdScaling, this.gsi.getDisplayScaling());
            this.maxContainerScaling[2] = 1.0;
        }
        return this.maxContainerScaling;
    }

    @Override
    public double[] getActualScaling() {
        if (this.actualContainerScaling == null) {
            this.updateActualScaling();
        }
        return this.actualContainerScaling;
    }

    @Override
    public ElementStorage getElements() {
        return this.elements;
    }

    @Override
    public void onElementAdded(IDisplayElement e) {
        e.setHolder(this);
        this.updateActualScaling();
        this.gsi.onElementAdded(this, e);
    }

    @Override
    public void onElementRemoved(IDisplayElement element) {
        element.setHolder(this);
        this.updateActualScaling();
        this.gsi.onElementRemoved(this, element);
    }

    public int getContainerIdentity() {
        return this.containerIdentity;
    }

    public int setDefaultColour(int colour) {
        this.defaultColour = colour;
        return this.defaultColour;
    }

    public final int getDefaultColour() {
        return this.defaultColour;
    }

    public void lock() {
        this.createdTranslation = DisplayElementHelper.scaleFromPercentage(this.createdTranslation, this.gsi.getDisplayScaling());
        this.createdScaling = DisplayElementHelper.scaleFromPercentage(this.createdScaling, this.gsi.getDisplayScaling());
        this.translation = null;
        this.maxContainerScaling = null;
        this.locked = true;
    }

    public void unlock() {
        this.createdTranslation = DisplayElementHelper.percentageFromScale(this.createdTranslation, this.gsi.getDisplayScaling());
        this.createdScaling = DisplayElementHelper.percentageFromScale(this.createdScaling, this.gsi.getDisplayScaling());
        this.translation = null;
        this.maxContainerScaling = null;
        this.locked = false;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.containerIdentity = nbt.func_74762_e("iden");
        this.locked = nbt.func_74767_n("locked");
        this.percentageScale = nbt.func_74769_h("percent");
        this.createdTranslation = NBTHelper.readDoubleArray((NBTTagCompound)nbt, (String)"c_trans", (int)3);
        this.createdScaling = NBTHelper.readDoubleArray((NBTTagCompound)nbt, (String)"c_scale", (int)3);
        this.elements.readData(nbt, type);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74768_a("iden", this.containerIdentity);
        nbt.func_74757_a("locked", this.locked);
        nbt.func_74780_a("percent", this.percentageScale);
        NBTHelper.writeDoubleArray((NBTTagCompound)nbt, (double[])this.createdTranslation, (String)"c_trans");
        NBTHelper.writeDoubleArray((NBTTagCompound)nbt, (double[])this.createdScaling, (String)"c_scale");
        this.elements.writeData(nbt, type);
        return nbt;
    }

    @Override
    public double[] createMaxScaling(IDisplayElement element) {
        switch (element.getFillType()) {
            case FILL_CONTAINER: {
                return this.getContainerMaxScaling();
            }
            case FILL_SCALED_CONTAINER: {
                return this.getMaxScaling();
            }
        }
        return DisplayElementHelper.getScaling(element.getUnscaledWidthHeight(), this.getMaxScaling(), 1.0);
    }

    @Override
    public double[] createActualScaling(IDisplayElement element) {
        switch (element.getFillType()) {
            case FILL_CONTAINER: {
                return this.getContainerMaxScaling();
            }
            case FILL_SCALED_CONTAINER: {
                return this.getMaxScaling();
            }
        }
        return DisplayElementHelper.getScaling(element.getUnscaledWidthHeight(), element.getMaxScaling(), 1.0);
    }

    @Override
    public double[] getAlignmentTranslation() {
        return DisplayElementHelper.alignArray(this.getContainerMaxScaling(), this.getMaxScaling(), WidthAlignment.LEFT, HeightAlignment.TOP);
    }

    public double[] getFullAlignmentTranslation(IDisplayElement e) {
        double[] containerAlign = this.getAlignmentTranslation();
        double[] holderAlign = new double[]{0.0, 0.0, 0.0};
        double[] elementAlign = e.getHolder().getAlignmentTranslation(e);
        if (e.getHolder() instanceof IDisplayElement) {
            holderAlign = this.getAlignmentTranslation((IDisplayElement)((Object)e.getHolder()));
        }
        double fullX = containerAlign[0] + holderAlign[0] + elementAlign[0];
        double fullY = containerAlign[1] + holderAlign[1] + elementAlign[1];
        return new double[]{fullX, fullY, elementAlign[2]};
    }

    @Override
    public double[] getAlignmentTranslation(IDisplayElement e) {
        return e.getAlignmentTranslation(this.getContainerMaxScaling(), e.getActualScaling());
    }
}

