/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.IClickableElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.elements.base.ILookableElement;

public class ElementStorage
implements INBTSyncable,
Iterable<IDisplayElement> {
    public static final String TAG_NAME = "element_storage";
    protected Map<Integer, List<IDisplayElement>> elements = new HashMap<Integer, List<IDisplayElement>>();
    protected List<IClickableElement> clickables = new ArrayList<IClickableElement>();
    protected List<ILookableElement> lookables = new ArrayList<ILookableElement>();
    protected List<IElementStorageHolder> holders = new ArrayList<IElementStorageHolder>();
    public IElementStorageHolder holder;
    public int elementCount;

    public ElementStorage(IElementStorageHolder holder) {
        this.holder = holder;
    }

    public void addElement(IDisplayElement e) {
        int id = DisplayElementHelper.getRegisteredID(e);
        this.elements.putIfAbsent(id, new ArrayList());
        if (ListHelper.addWithCheck((Collection)this.elements.get(id), (Object)e)) {
            if (e instanceof IClickableElement) {
                ListHelper.addWithCheck(this.clickables, (Object)((IClickableElement)e));
            }
            this.onElementAdded(e);
        }
    }

    public void removeElement(IDisplayElement e) {
        int id = DisplayElementHelper.getRegisteredID(e);
        if (((List)this.elements.getOrDefault(id, new ArrayList())).remove(e)) {
            if (e instanceof IClickableElement) {
                this.clickables.remove(e);
            }
            this.onElementRemoved(e);
        }
    }

    public IDisplayElement getElementFromIdentity(int identity) {
        for (IDisplayElement e : this) {
            if (e.getElementIdentity() != identity) continue;
            return e;
        }
        for (IElementStorageHolder holder : this.getSubHolders()) {
            IDisplayElement e = holder.getElements().getElementFromIdentity(identity);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public IDisplayElement replaceElement(IDisplayElement element, int identity) {
        int id = DisplayElementHelper.getRegisteredID(element);
        this.elements.putIfAbsent(id, new ArrayList());
        IDisplayElement toReplace = null;
        for (IDisplayElement e : this.holder.getElements()) {
            if (e.getElementIdentity() != identity) continue;
            toReplace = e;
            break;
        }
        this.addElement(element);
        if (toReplace != null) {
            this.removeElement(toReplace);
        }
        return null;
    }

    public void onElementAdded(IDisplayElement e) {
        ++this.elementCount;
        e.setHolder(this.holder);
        if (e instanceof IClickableElement) {
            this.clickables.add((IClickableElement)e);
        }
        if (e instanceof ILookableElement) {
            this.lookables.add((ILookableElement)e);
        }
        if (e instanceof IElementStorageHolder) {
            this.holders.add((IElementStorageHolder)((Object)e));
        }
        this.holder.onElementAdded(e);
    }

    public void onElementRemoved(IDisplayElement e) {
        --this.elementCount;
        if (e instanceof IClickableElement) {
            this.clickables.remove(e);
        }
        if (e instanceof ILookableElement) {
            this.lookables.remove(e);
        }
        if (e instanceof IElementStorageHolder) {
            this.holders.remove(e);
        }
        this.holder.onElementRemoved(e);
    }

    public void forEachElement(Consumer<IDisplayElement> action) {
        this.elements.values().forEach(l -> l.forEach(action));
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        ArrayList<Integer> loaded = new ArrayList<Integer>();
        NBTTagList tagList = nbt.func_150295_c(TAG_NAME, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound elementsTag = tagList.func_150305_b(i);
            if (elementsTag.func_82582_d()) continue;
            int registryID = elementsTag.func_74762_e("rID");
            Class<? extends IDisplayElement> currentClass = DisplayElementHelper.getElementClass(registryID);
            NBTTagList subList = elementsTag.func_150295_c("list", 10);
            for (int s = 0; s < subList.func_74745_c(); ++s) {
                NBTTagCompound eTag = subList.func_150305_b(s);
                int iden = eTag.func_74762_e("identity");
                IDisplayElement ide = this.getElementFromIdentity(iden);
                if (ide != null) {
                    ide.readData(eTag, type);
                } else {
                    IDisplayElement e = DisplayElementHelper.loadElement(eTag, this.holder);
                    if (e != null) {
                        this.addElement(e);
                    }
                }
                loaded.add(iden);
            }
        }
        ArrayList toRemove = new ArrayList();
        this.forEach(element -> {
            if (!loaded.contains(element.getElementIdentity())) {
                toRemove.add(element);
            }
        });
        toRemove.forEach(this::removeElement);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<Integer, List<IDisplayElement>> map : this.elements.entrySet()) {
            if (map.getValue().isEmpty()) continue;
            NBTTagList subList = new NBTTagList();
            for (IDisplayElement e : map.getValue()) {
                NBTTagCompound eTag = DisplayElementHelper.saveElement(new NBTTagCompound(), e, type);
                subList.func_74742_a((NBTBase)eTag);
            }
            if (subList.func_82582_d()) continue;
            NBTTagCompound elementsTag = new NBTTagCompound();
            elementsTag.func_74768_a("rID", map.getKey().intValue());
            elementsTag.func_74782_a("list", (NBTBase)subList);
            tagList.func_74742_a((NBTBase)elementsTag);
        }
        nbt.func_74782_a(TAG_NAME, (NBTBase)tagList);
        return nbt;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public boolean hasClickables() {
        if (!this.clickables.isEmpty()) {
            return true;
        }
        List<IElementStorageHolder> allHolders = this.getAllSubHolders(new ArrayList<IElementStorageHolder>());
        for (IElementStorageHolder holder : allHolders) {
            if (holder.getElements().getClickables().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<IClickableElement> getClickables() {
        return this.clickables;
    }

    public boolean hasLookables() {
        if (!this.lookables.isEmpty()) {
            return true;
        }
        List<IElementStorageHolder> allHolders = this.getAllSubHolders(new ArrayList<IElementStorageHolder>());
        for (IElementStorageHolder holder : allHolders) {
            if (holder.getElements().getClickables().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<ILookableElement> getLookables() {
        return this.lookables;
    }

    public boolean hasSubHolders() {
        return !this.holders.isEmpty();
    }

    public List<IElementStorageHolder> getSubHolders() {
        return this.holders;
    }

    public List<IElementStorageHolder> getAllSubHolders(List<IElementStorageHolder> holders) {
        this.getSubHolders().forEach(holder -> {
            ListHelper.addWithCheck((Collection)holders, (Object)holder);
            holder.getElements().getAllSubHolders(holders);
        });
        return holders;
    }

    @Override
    @Nonnull
    public Iterator<IDisplayElement> iterator() {
        return new StorageIterator(this);
    }

    public class StorageIterator
    implements Iterator<IDisplayElement> {
        public Iterator<Map.Entry<Integer, List<IDisplayElement>>> entries;
        public Iterator<IDisplayElement> elements;

        public StorageIterator(ElementStorage s) {
            this.entries = s.elements.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.elements != null && this.elements.hasNext()) {
                return true;
            }
            Iterator<IDisplayElement> nextList = null;
            while (nextList == null || !nextList.hasNext()) {
                if (this.entries.hasNext()) {
                    nextList = this.entries.next().getValue().iterator();
                    continue;
                }
                return false;
            }
            this.elements = nextList;
            return true;
        }

        @Override
        public IDisplayElement next() {
            return this.elements.next();
        }
    }
}

