/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.PlayerListener;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.readers.ClientLocalProvider;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.api.core.tiles.readers.INetworkReader;
import sonar.logistics.api.core.tiles.wireless.IWirelessManager;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.base.listeners.PL2ListenerList;
import sonar.logistics.core.tiles.connections.data.network.NetworkHelper;
import sonar.logistics.core.tiles.displays.DisplayHelper;
import sonar.logistics.core.tiles.displays.info.types.fluids.FluidChangeableList;
import sonar.logistics.core.tiles.displays.info.types.fluids.FluidCount;
import sonar.logistics.core.tiles.displays.info.types.items.ItemChangeableList;
import sonar.logistics.core.tiles.displays.info.types.items.ItemCount;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.core.tiles.misc.signaller.TileRedstoneSignaller;
import sonar.logistics.core.tiles.readers.fluids.handling.FluidNetworkChannels;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;
import sonar.logistics.core.tiles.readers.items.handling.ItemNetworkChannels;
import sonar.logistics.core.tiles.wireless.base.PacketClientEmitters;
import sonar.logistics.network.packets.PacketInfoUpdates;
import sonar.logistics.network.packets.PacketLocalProviders;
import sonar.logistics.network.packets.PacketMonitoredList;

public class InfoPacketHelper {
    public static void sendLocalProvidersFromScreen(TileAbstractDisplay part, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        List<ILogicListenable> providers = DisplayHelper.getLocalProviders(part, world, pos);
        int identity = part.getInfoContainerID();
        ArrayList<ClientLocalProvider> clientMonitors = new ArrayList<ClientLocalProvider>();
        providers.forEach(provider -> {
            provider.getListenerList().addListener(player, new Enum[]{ListenerType.TEMPORARY_LISTENER});
            clientMonitors.add(new ClientLocalProvider((ILogicListenable)provider, provider.getSorter(), provider.getDisplayStack()));
        });
        PL2.network.sendTo((IMessage)new PacketLocalProviders(clientMonitors, identity), (EntityPlayerMP)player);
    }

    public static void sendLocalProviders(TileRedstoneSignaller tileRedstoneSignaller, int identity, EntityPlayer player) {
        List<IInfoProvider> providers = tileRedstoneSignaller.getNetwork().getGlobalInfoProviders();
        ArrayList<ClientLocalProvider> clientProviders = new ArrayList<ClientLocalProvider>();
        providers.forEach(provider -> {
            provider.getListenerList().addListener(player, new Enum[]{ListenerType.TEMPORARY_LISTENER});
            clientProviders.add(new ClientLocalProvider((ILogicListenable)provider, provider.getSorter(), provider.getDisplayStack()));
        });
        PL2.network.sendTo((IMessage)new PacketLocalProviders(clientProviders, identity), (EntityPlayerMP)player);
    }

    public static void createInfoUpdatesForListeners(Map<EntityPlayerMP, NBTTagList> listenerPackets, List<PlayerListener> players, NBTTagCompound updateTag, NBTTagCompound saveTag, boolean fullPacket) {
        players.forEach(player -> InfoPacketHelper.addPlayerUpdatesToList(listenerPackets, player.player, updateTag, saveTag, fullPacket));
    }

    public static void createInfoUpdatesForPlayers(Map<EntityPlayerMP, NBTTagList> listenerPackets, List<EntityPlayerMP> players, NBTTagCompound updateTag, NBTTagCompound saveTag, boolean fullPacket) {
        players.forEach(player -> InfoPacketHelper.addPlayerUpdatesToList(listenerPackets, player, updateTag, saveTag, fullPacket));
    }

    public static void addPlayerUpdatesToList(Map<EntityPlayerMP, NBTTagList> listenerPackets, EntityPlayerMP player, NBTTagCompound updateTag, NBTTagCompound saveTag, boolean fullPacket) {
        NBTTagList list = listenerPackets.get(player);
        if (list == null) {
            listenerPackets.put(player, new NBTTagList());
            list = listenerPackets.get(player);
        }
        list.func_74742_a((NBTBase)(fullPacket ? saveTag.func_74737_b() : updateTag.func_74737_b()));
    }

    public static void sendInfoUpdatePacket(EntityPlayerMP player, NBTTagList list, NBTHelper.SyncType type) {
        if (list.func_82582_d()) {
            return;
        }
        NBTTagCompound packetTag = new NBTTagCompound();
        packetTag.func_74782_a("infoList", (NBTBase)list);
        PL2.network.sendTo((IMessage)new PacketInfoUpdates(packetTag, type), player);
    }

    public static void receiveInfoUpdate(NBTTagCompound packetTag, NBTHelper.SyncType type) {
        NBTTagList packetList = packetTag.func_150295_c("infoList", 10);
        boolean save = type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE});
        for (int i = 0; i < packetList.func_74745_c(); ++i) {
            IInfo currentInfo;
            NBTTagCompound infoTag = packetList.func_150305_b(i);
            InfoUUID id = (InfoUUID)NBTHelper.instanceNBTSyncable(InfoUUID.class, (NBTTagCompound)infoTag);
            if (save) {
                currentInfo = ClientInfoHandler.instance().getInfoMap().get(id);
                IInfo newInfo = InfoHelper.readInfoFromNBT(infoTag);
                if (currentInfo == null || !currentInfo.isMatchingType(newInfo)) {
                    ClientInfoHandler.instance().setInfo(id, newInfo);
                    continue;
                }
                currentInfo.readData(infoTag, type);
                ClientInfoHandler.instance().setInfo(id, currentInfo);
                continue;
            }
            currentInfo = ClientInfoHandler.instance().getInfoMap().get(id);
            if (currentInfo == null) continue;
            currentInfo.readData(infoTag, type);
            ClientInfoHandler.instance().setInfo(id, currentInfo);
        }
    }

    public static void sendEmittersToPlayer(EntityPlayer player, IWirelessManager manager) {
        PL2.network.sendTo((IMessage)new PacketClientEmitters(manager.type(), manager.getClientEmitters(player)), (EntityPlayerMP)player);
    }

    public static void sendNormalProviderInfo(IInfoProvider monitor) {
        InfoPacketHelper.sendReaderToListeners(monitor, null, new InfoUUID(monitor.getIdentity(), 0));
    }

    public static void sendReaderFullInfo(List<PlayerListener> listeners, ILogicListenable monitor, AbstractChangeableList b, InfoUUID uuid) {
        NBTTagCompound saveTag;
        NBTTagCompound nBTTagCompound = saveTag = b != null ? InfoHelper.writeMonitoredList(new NBTTagCompound(), b, NBTHelper.SyncType.SAVE) : null;
        if (saveTag.func_82582_d()) {
            return;
        }
        listeners.forEach(listener -> PL2.network.sendTo((IMessage)new PacketMonitoredList(monitor.getIdentity(), uuid, monitor.getNetworkID(), saveTag, NBTHelper.SyncType.SAVE, monitor.getSorter()), listener.player));
    }

    public static void createRapidFluidUpdate(List<FluidStack> toUpdate, int networkID) {
        FluidNetworkChannels channels = NetworkHelper.getNetwork(networkID).getNetworkChannels(FluidNetworkChannels.class);
        if (channels != null) {
            channels.createRapidFluidUpdate(toUpdate);
        }
    }

    public static void sendRapidFluidUpdate(ILogicListenable reader, InfoUUID listUUID, FluidChangeableList list, List<FluidStack> toUpdate) {
        for (FluidStack update : toUpdate) {
            FluidCount value = list.find(update);
            if (value == null) continue;
            value.setNew();
        }
        InfoPacketHelper.sendStandardListenerPacket(reader, list, listUUID);
    }

    public static void createRapidItemUpdate(List<ItemStack> toUpdate, int networkID) {
        ItemNetworkChannels channels = NetworkHelper.getNetwork(networkID).getNetworkChannels(ItemNetworkChannels.class);
        if (channels != null) {
            channels.createRapidItemUpdate(toUpdate);
        }
    }

    public static void sendRapidItemUpdate(ILogicListenable reader, InfoUUID listUUID, ItemChangeableList list, List<ItemStack> toUpdate) {
        for (ItemStack update : toUpdate) {
            ItemCount value = list.find(update);
            if (value == null) continue;
            value.setNew();
        }
        InfoPacketHelper.sendStandardListenerPacket(reader, list, listUUID);
    }

    public static boolean sendStandardListenerPacket(ILogicListenable reader, AbstractChangeableList updateList, InfoUUID listUUID) {
        NBTTagCompound tag = InfoHelper.writeMonitoredList(new NBTTagCompound(), updateList, NBTHelper.SyncType.DEFAULT_SYNC);
        if (!tag.func_82582_d()) {
            List<PlayerListener> listeners = reader.getListenerList().getAllListeners(ListenerType.OLD_GUI_LISTENER, ListenerType.OLD_DISPLAY_LISTENER);
            listeners.forEach(listener -> PL2.network.sendTo((IMessage)new PacketMonitoredList(reader.getIdentity(), listUUID, reader.getNetworkID(), tag, NBTHelper.SyncType.DEFAULT_SYNC, reader.getSorter()), listener.player));
            return true;
        }
        return false;
    }

    public static void sendReaderToListeners(ILogicListenable reader, AbstractChangeableList updateList, InfoUUID listUUID) {
        if (updateList == null) {
            return;
        }
        PL2ListenerList list = reader.getListenerList();
        block4: for (ListenerType type : ListenerType.ALL) {
            if (type == ListenerType.OLD_GUI_LISTENER) {
                InfoPacketHelper.sendStandardListenerPacket(reader, updateList, listUUID);
                continue;
            }
            List tallies = list.getTallies(new Enum[]{type});
            if (tallies.isEmpty()) continue;
            switch (type) {
                case NEW_DISPLAY_LISTENER: 
                case NEW_GUI_LISTENER: {
                    NBTTagCompound saveTag = InfoHelper.writeMonitoredList(new NBTTagCompound(), updateList, NBTHelper.SyncType.SAVE);
                    if (saveTag == null || saveTag.func_82582_d()) continue block4;
                    tallies.forEach(tally -> {
                        PL2.network.sendTo((IMessage)new PacketMonitoredList(reader.getIdentity(), listUUID, reader.getNetworkID(), saveTag, NBTHelper.SyncType.SAVE, reader.getSorter()), ((PlayerListener)tally.listener).player);
                        tally.removeTallies(1, new Enum[]{ListenerType.NEW_GUI_LISTENER});
                        tally.addTallies(1, new Enum[]{ListenerType.OLD_GUI_LISTENER});
                        tally.source.updateState();
                    });
                    list.updateState();
                    continue block4;
                }
                case TEMPORARY_LISTENER: {
                    NBTTagCompound saveTag = InfoHelper.writeMonitoredList(new NBTTagCompound(), updateList, NBTHelper.SyncType.SAVE);
                    NBTTagList tagList = new NBTTagList();
                    if (reader instanceof INetworkReader) {
                        INetworkReader r = (INetworkReader)reader;
                        for (int i = 0; i < r.getMaxInfo(); ++i) {
                            InfoUUID infoID = new InfoUUID(reader.getIdentity(), i);
                            IInfo info = ServerInfoHandler.instance().getInfoMap().get(infoID);
                            if (info == null) continue;
                            NBTTagCompound nbt = InfoHelper.writeInfoToNBT(new NBTTagCompound(), info, NBTHelper.SyncType.SAVE);
                            nbt = infoID.writeData(nbt, NBTHelper.SyncType.SAVE);
                            tagList.func_74742_a((NBTBase)nbt);
                        }
                    }
                    tallies.forEach(tally -> {
                        PL2.network.sendTo((IMessage)new PacketMonitoredList(reader.getIdentity(), listUUID, reader.getNetworkID(), saveTag, NBTHelper.SyncType.SAVE, reader.getSorter()), ((PlayerListener)tally.listener).player);
                        tally.removeTallies(1, new Enum[]{ListenerType.TEMPORARY_LISTENER});
                        InfoPacketHelper.sendInfoUpdatePacket(((PlayerListener)tally.listener).player, tagList, NBTHelper.SyncType.SAVE);
                    });
                    continue block4;
                }
            }
        }
    }
}

