/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.elements;

import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.core.tiles.displays.info.elements.base.HeightAlignment;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;

public abstract class AbstractDisplayElement
implements IDisplayElement {
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    public static final int SCALE = 2;
    public IElementStorageHolder holder;
    protected double[] maxScaling;
    protected double[] actualScaling;
    protected int[] unscaledWidthHeight;
    protected double percentageFill = 1.0;
    protected WidthAlignment width_align = WidthAlignment.CENTERED;
    protected HeightAlignment height_align = HeightAlignment.CENTERED;
    private int identity = -1;
    public static final String IDENTITY_TAG_NAME = "identity";

    @Override
    public int getElementIdentity() {
        if (this.identity == -1) {
            this.identity = ServerInfoHandler.instance().getNextIdentity();
        }
        return this.identity;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.identity = nbt.func_74762_e(IDENTITY_TAG_NAME);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74768_a(IDENTITY_TAG_NAME, this.getElementIdentity());
        return nbt;
    }

    @Override
    public final IElementStorageHolder setHolder(IElementStorageHolder c) {
        this.holder = c;
        return this.holder;
    }

    @Override
    public IElementStorageHolder getHolder() {
        return this.holder;
    }

    @Override
    public void onElementChanged() {
        this.unscaledWidthHeight = null;
        this.maxScaling = null;
        this.actualScaling = null;
    }

    @Override
    public WidthAlignment getWidthAlignment() {
        return this.width_align;
    }

    @Override
    public WidthAlignment setWidthAlignment(WidthAlignment align) {
        this.width_align = align;
        return this.width_align;
    }

    @Override
    public HeightAlignment getHeightAlignment() {
        return this.height_align;
    }

    @Override
    public HeightAlignment setHeightAlignment(HeightAlignment align) {
        this.height_align = align;
        return this.height_align;
    }

    @Override
    public double getPercentageFill() {
        return this.percentageFill;
    }

    @Override
    public double setPercentageFill(double fill) {
        this.onElementChanged();
        this.percentageFill = fill;
        return this.percentageFill;
    }

    @Override
    public double[] getMaxScaling() {
        if (this.maxScaling == null) {
            this.maxScaling = this.getHolder().createMaxScaling(this);
        }
        return this.maxScaling;
    }

    @Override
    public double[] setMaxScaling(double[] scaling) {
        this.maxScaling = scaling;
        return scaling;
    }

    @Override
    public double[] getActualScaling() {
        if (this.actualScaling == null) {
            this.actualScaling = this.getHolder().createActualScaling(this);
        }
        return this.actualScaling;
    }

    @Override
    public double[] setActualScaling(double[] scaling) {
        this.actualScaling = scaling;
        return scaling;
    }

    @Override
    public final int[] getUnscaledWidthHeight() {
        if (this.unscaledWidthHeight == null) {
            this.unscaledWidthHeight = this.createUnscaledWidthHeight();
        }
        return this.unscaledWidthHeight;
    }

    public int[] createUnscaledWidthHeight() {
        return new int[]{1, 1};
    }
}

